/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayDeque;
import jdk.vm.ci.code.Architecture;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.core.common.util.FrequencyEncoder;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphComparison;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.InliningLogCodec;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.OptimizationLogCodec;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.replacements.nodes.MethodHandleWithExceptionNode;

public class GraphEncoder {
    public static final int NULL_ORDER_ID = 0;
    public static final int START_NODE_ORDER_ID = 1;
    public static final int FIRST_NODE_ORDER_ID = 2;
    public static final int MAX_INDEX_1_BYTE = 128;
    public static final int MAX_INDEX_2_BYTES = 32768;
    protected static final int BEGIN_NEXT_ORDER_ID_OFFSET = 1;
    protected final Architecture architecture;
    protected final FrequencyEncoder<Object> objects;
    protected final FrequencyEncoder<NodeClass<?>> nodeClasses;
    protected final UnsafeArrayTypeWriter writer;
    protected Object[] objectsArray;
    protected NodeClass<?>[] nodeClassesArray;
    protected DebugContext debug;
    private final InliningLogCodec inliningLogCodec;
    private final OptimizationLogCodec optimizationLogCodec;

    public static EncodedGraph encodeSingleGraph(StructuredGraph graph, Architecture architecture) {
        return GraphEncoder.encodeSingleGraph(graph, architecture, null);
    }

    public static EncodedGraph encodeSingleGraph(StructuredGraph graph, Architecture architecture, Iterable<EncodedGraph.EncodedNodeReference> nodeReferences) {
        GraphEncoder encoder = new GraphEncoder(architecture);
        encoder.prepare(graph);
        encoder.finishPrepare();
        int startOffset = encoder.encode(graph, nodeReferences);
        return new EncodedGraph(encoder.getEncoding(), startOffset, encoder.getObjects(), encoder.getNodeClasses(), graph);
    }

    public GraphEncoder(Architecture architecture) {
        this(architecture, null);
    }

    public GraphEncoder(Architecture architecture, DebugContext debug) {
        this.architecture = architecture;
        this.debug = debug;
        this.objects = FrequencyEncoder.createEqualityEncoder();
        this.nodeClasses = FrequencyEncoder.createIdentityEncoder();
        this.writer = UnsafeArrayTypeWriter.create(architecture.supportsUnalignedMemoryAccess());
        this.inliningLogCodec = new InliningLogCodec();
        this.optimizationLogCodec = new OptimizationLogCodec();
    }

    public void prepare(StructuredGraph graph) {
        this.addObject((Object)graph.getGuardsStage());
        this.addObject(graph.getGraphState().getStageFlags());
        this.inliningLogCodec.prepare(graph, this::addObject);
        this.optimizationLogCodec.prepare(graph, this::addObject);
        for (Node node : graph.getNodes()) {
            NodeClass<? extends Node> nodeClass = node.getNodeClass();
            this.nodeClasses.addObject(nodeClass);
            this.addObject(node.getNodeSourcePosition());
            for (int i = 0; i < nodeClass.getData().getCount(); ++i) {
                if (nodeClass.getData().getType(i).isPrimitive()) continue;
                this.addObject(nodeClass.getData().get(node, i));
            }
            if (!(node instanceof Invoke) && !(node instanceof MethodHandleWithExceptionNode)) continue;
            this.addObject(((Invokable)((Object)node)).getContextType());
        }
    }

    protected void addObject(Object object) {
        this.objects.addObject(object);
    }

    public void finishPrepare() {
        this.objectsArray = this.objects.encodeAll((Object[])new Object[this.objects.getLength()]);
        this.nodeClassesArray = this.nodeClasses.encodeAll(new NodeClass[this.nodeClasses.getLength()]);
    }

    public Object[] getObjects() {
        return this.objectsArray;
    }

    public NodeClass<?>[] getNodeClasses() {
        return this.nodeClassesArray;
    }

    public int encode(StructuredGraph graph) {
        return this.encode(graph, null);
    }

    protected int encode(StructuredGraph graph, Iterable<EncodedGraph.EncodedNodeReference> nodeReferences) {
        assert (this.objectsArray != null && this.nodeClassesArray != null) : "finishPrepare() must be called before encode()";
        NodeOrder nodeOrder = new NodeOrder(graph);
        int nodeCount = nodeOrder.nextOrderId;
        assert (nodeOrder.orderIds.get(graph.start()) == 1);
        assert (nodeOrder.orderIds.get(graph.start().next()) == 2);
        if (nodeReferences != null) {
            for (EncodedGraph.EncodedNodeReference nodeReference : nodeReferences) {
                if (nodeReference.orderId != -1) {
                    throw GraalError.shouldNotReachHere("EncodedNodeReference is not in 'decoded' state");
                }
                nodeReference.orderId = nodeOrder.orderIds.get(nodeReference.node);
                nodeReference.node = null;
            }
        }
        long[] nodeStartOffsets = new long[nodeCount];
        MapCursor<Node, Integer> cursor = nodeOrder.orderIds.getEntries();
        while (cursor.advance()) {
            FixedNode next;
            Node node = (Node)cursor.getKey();
            Integer orderId = (Integer)cursor.getValue();
            assert (!(node instanceof AbstractBeginNode) || nodeOrder.orderIds.get(((AbstractBeginNode)node).next()) == orderId + 1);
            assert (nodeStartOffsets[orderId] == 0L);
            nodeStartOffsets[orderId.intValue()] = this.writer.getBytesWritten();
            NodeClass<? extends Node> nodeClass = node.getNodeClass();
            this.writer.putUV(this.nodeClasses.getIndex(nodeClass));
            this.writeEdges(node, nodeClass.getEdges(Edges.Type.Inputs), nodeOrder);
            this.writeProperties(node, nodeClass.getData());
            this.writeEdges(node, nodeClass.getEdges(Edges.Type.Successors), nodeOrder);
            if (node instanceof AbstractEndNode) {
                AbstractEndNode end = (AbstractEndNode)node;
                AbstractMergeNode merge = end.merge();
                this.writeOrderId(merge, nodeOrder);
                this.writer.putUV(merge.phis().count());
                for (PhiNode phi : merge.phis()) {
                    this.writeOrderId(phi.valueAt(end), nodeOrder);
                    this.writeOrderId(phi, nodeOrder);
                }
                continue;
            }
            if (node instanceof LoopExitNode) {
                LoopExitNode exit = (LoopExitNode)node;
                this.writeOrderId(exit.stateAfter(), nodeOrder);
                this.writer.putUV(exit.proxies().count());
                for (ProxyNode proxy : exit.proxies()) {
                    this.writeOrderId(proxy, nodeOrder);
                }
                continue;
            }
            if (!(node instanceof Invoke) && !(node instanceof MethodHandleWithExceptionNode)) continue;
            if (node instanceof Invoke) {
                Invoke invoke = (Invoke)((Object)node);
                assert (invoke.stateDuring() == null) : "stateDuring is not used in high-level graphs";
                this.writeOrderId(invoke.callTarget(), nodeOrder);
                next = invoke.next();
            } else {
                next = ((MethodHandleWithExceptionNode)node).next();
            }
            Invokable inv = (Invokable)((Object)node);
            this.writeObjectId(inv.getContextType());
            this.writeOrderId(((StateSplit)((Object)inv)).stateAfter(), nodeOrder);
            this.writeOrderId(next, nodeOrder);
            if (!(inv instanceof WithExceptionNode)) continue;
            WithExceptionNode withException = (WithExceptionNode)((Object)inv);
            ExceptionObjectNode exceptionEdge = (ExceptionObjectNode)withException.exceptionEdge();
            this.writeOrderId(withException.exceptionEdge(), nodeOrder);
            this.writeOrderId(exceptionEdge.stateAfter(), nodeOrder);
            this.writeOrderId(exceptionEdge.next(), nodeOrder);
        }
        int metadataStart = TypeConversion.asS4(this.writer.getBytesWritten());
        this.writer.putUV(nodeOrder.maxFixedNodeOrderId);
        this.writeObjectId((Object)graph.getGuardsStage());
        this.writeObjectId(graph.getGraphState().getStageFlags());
        this.writeObjectId(this.inliningLogCodec.encode(graph, nodeOrder.orderIds::get));
        this.writeObjectId(this.optimizationLogCodec.encode(graph, nodeOrder.orderIds::get));
        this.writer.putUV(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            this.writer.putUV((long)metadataStart - nodeStartOffsets[i]);
        }
        assert (this.verifyEncoding(graph, new EncodedGraph(this.getEncoding(), metadataStart, this.getObjects(), this.getNodeClasses(), graph)));
        return metadataStart;
    }

    public byte[] getEncoding() {
        return this.writer.toArray(new byte[TypeConversion.asS4(this.writer.getBytesWritten())]);
    }

    protected void writeProperties(Node node, Fields fields) {
        this.writeObjectId(node.getNodeSourcePosition());
        for (int idx = 0; idx < fields.getCount(); ++idx) {
            if (fields.getType(idx).isPrimitive()) {
                long primitive = fields.getRawPrimitive(node, idx);
                this.writer.putSV(primitive);
                continue;
            }
            Object property = fields.get(node, idx);
            this.writeObjectId(property);
        }
    }

    protected void writeEdges(Node node, Edges edges, NodeOrder nodeOrder) {
        int idx;
        if (node instanceof PhiNode) {
            return;
        }
        for (idx = 0; idx < edges.getDirectCount(); ++idx) {
            if (GraphDecoder.skipDirectEdge(node, edges, idx)) continue;
            Node edge = Edges.getNode(node, edges.getOffsets(), idx);
            this.writeOrderId(edge, nodeOrder);
        }
        if (!(node instanceof AbstractMergeNode) || edges.type() != Edges.Type.Inputs) {
            for (idx = edges.getDirectCount(); idx < edges.getCount(); ++idx) {
                NodeList<Node> edgeList = Edges.getNodeList(node, edges.getOffsets(), idx);
                if (edgeList == null) {
                    this.writer.putSV(-1L);
                    continue;
                }
                this.writer.putSV(edgeList.size());
                for (Node edge : edgeList) {
                    this.writeOrderId(edge, nodeOrder);
                }
            }
        }
    }

    protected void writeOrderId(Node node, NodeOrder nodeOrder) {
        int id;
        int n = id = node == null ? 0 : nodeOrder.orderIds.get(node);
        if (nodeOrder.nextOrderId <= 128) {
            this.writer.putU1(id);
        } else if (nodeOrder.nextOrderId <= 32768) {
            this.writer.putU2(id);
        } else {
            this.writer.putS4(id);
        }
    }

    protected void writeObjectId(Object object) {
        this.writer.putUV(this.objects.getIndex(object));
    }

    public boolean verifyEncoding(StructuredGraph originalGraph, EncodedGraph encodedGraph) {
        DebugContext debugContext = this.debug != null ? this.debug : originalGraph.getDebug();
        StructuredGraph decodedGraph = new StructuredGraph.Builder(originalGraph.getOptions(), debugContext, originalGraph.allowAssumptions()).method(originalGraph.method()).profileProvider(originalGraph.getProfileProvider()).setIsSubstitution(originalGraph.isSubstitution()).trackNodeSourcePosition(originalGraph.trackNodeSourcePosition()).recordInlinedMethods(originalGraph.isRecordingInlinedMethods()).build();
        GraphDecoder decoder = new GraphDecoder(this.architecture, decodedGraph);
        decoder.decode(encodedGraph);
        decodedGraph.verify();
        try {
            GraphComparison.verifyGraphsEqual(originalGraph, decodedGraph);
        }
        catch (Throwable ex) {
            try (DebugContext.Scope scope = debugContext.scope("GraphEncoder");){
                debugContext.dump(3, originalGraph, "Original Graph");
                debugContext.dump(3, decodedGraph, "Decoded Graph");
            }
            throw ex;
        }
        return this.optimizationLogCodec.verify(originalGraph, decodedGraph) && this.inliningLogCodec.verify(originalGraph, decodedGraph);
    }

    static class NodeOrder {
        protected final NodeMap<Integer> orderIds;
        protected int nextOrderId;
        protected int maxFixedNodeOrderId;

        NodeOrder(StructuredGraph graph) {
            this.orderIds = new NodeMap(graph);
            this.nextOrderId = 1;
            ArrayDeque<AbstractBeginNode> nodeQueue = new ArrayDeque<AbstractBeginNode>();
            FixedNode current = graph.start();
            do {
                this.add(current);
                if (current instanceof AbstractBeginNode) {
                    this.add(((AbstractBeginNode)current).next());
                }
                if (current instanceof FixedWithNextNode) {
                    current = ((FixedWithNextNode)current).next;
                    continue;
                }
                if (current instanceof ControlSplitNode) {
                    for (Node successor : current.successors()) {
                        if (successor == null) continue;
                        nodeQueue.addFirst((AbstractBeginNode)successor);
                    }
                } else if (current instanceof EndNode) {
                    AbstractMergeNode merge = ((AbstractEndNode)current).merge();
                    boolean allForwardEndsVisited = true;
                    for (int i = 0; i < merge.forwardEndCount(); ++i) {
                        if (this.orderIds.get(merge.forwardEndAt(i)) != null) continue;
                        allForwardEndsVisited = false;
                        break;
                    }
                    if (allForwardEndsVisited) {
                        nodeQueue.add(merge);
                    }
                }
                current = (FixedNode)nodeQueue.pollFirst();
            } while (current != null);
            this.maxFixedNodeOrderId = this.nextOrderId - 1;
            int parameterCount = graph.method().getSignature().getParameterCount(!graph.method().isStatic());
            for (ParameterNode node : graph.getNodes(ParameterNode.TYPE)) {
                assert (this.orderIds.get(node) == null) : "Parameter node must not be ordered yet";
                assert (node.index() < parameterCount) : "Parameter index out of range";
                this.orderIds.set(node, this.nextOrderId + node.index());
            }
            this.nextOrderId += parameterCount;
            for (Node node : graph.getNodes()) {
                assert ((node instanceof FixedNode || node instanceof ParameterNode) == (this.orderIds.get(node) != null)) : "all fixed nodes and ParameterNodes must be ordered: " + node;
                this.add(node);
            }
        }

        private void add(Node node) {
            if (this.orderIds.get(node) == null) {
                this.orderIds.set(node, this.nextOrderId);
                ++this.nextOrderId;
            }
        }
    }
}

