/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Objects;
import jdk.vm.ci.meta.SpeculationLog;

public final class GraphState {
    private static final EnumSet<StageFlag> HIGH_TIER_MANDATORY_STAGES = EnumSet.of(StageFlag.HIGH_TIER_LOWERING);
    private static final EnumSet<StageFlag> MID_TIER_MANDATORY_STAGES = EnumSet.of(StageFlag.VALUE_PROXY_REMOVAL, new StageFlag[]{StageFlag.SAFEPOINTS_INSERTION, StageFlag.GUARD_LOWERING, StageFlag.MID_TIER_LOWERING, StageFlag.FSA, StageFlag.BARRIER_ADDITION});
    private static final EnumSet<StageFlag> LOW_TIER_MANDATORY_STAGES = EnumSet.of(StageFlag.LOW_TIER_LOWERING, StageFlag.EXPAND_LOGIC, StageFlag.ADDRESS_LOWERING);
    private static final EnumSet<StageFlag> ENTERPRISE_MID_TIER_MANDATORY_STAGES = EnumSet.of(StageFlag.VALUE_PROXY_REMOVAL, new StageFlag[]{StageFlag.SAFEPOINTS_INSERTION, StageFlag.GUARD_LOWERING, StageFlag.MID_TIER_LOWERING, StageFlag.FSA, StageFlag.BARRIER_ADDITION, StageFlag.NODE_VECTORIZATION});
    public static final EnumSet<StageFlag> INITIAL_REQUIRED_STAGES = EnumSet.of(StageFlag.CANONICALIZATION);
    private StageFlag currentStage;
    private boolean disabledFrameStateVerification;
    private FrameStateVerification frameStateVerification;
    private EnumSet<StageFlag> futureRequiredStages;
    private GuardsStage guardsStage;
    private EnumSet<StageFlag> stageFlags;
    private final SpeculationLog speculationLog;

    public GraphState(StageFlag currentStage, boolean disabledFrameStateVerification, boolean isSubstitution, EnumSet<StageFlag> futureRequiredStages, GuardsStage guardsStage, SpeculationLog speculationLog, EnumSet<StageFlag> stageFlags) {
        this(currentStage, disabledFrameStateVerification || isSubstitution, isSubstitution ? FrameStateVerification.NONE : FrameStateVerification.ALL, futureRequiredStages, guardsStage, speculationLog, stageFlags);
    }

    public GraphState(StageFlag currentStage, boolean disabledFrameStateVerification, FrameStateVerification frameStateVerification, EnumSet<StageFlag> futureRequiredStages, GuardsStage guardsStage, SpeculationLog speculationLog, EnumSet<StageFlag> stageFlags) {
        this.currentStage = currentStage;
        this.disabledFrameStateVerification = disabledFrameStateVerification;
        this.frameStateVerification = frameStateVerification;
        this.futureRequiredStages = futureRequiredStages == null ? EnumSet.noneOf(StageFlag.class) : futureRequiredStages;
        this.guardsStage = guardsStage == null ? GuardsStage.FLOATING_GUARDS : guardsStage;
        this.speculationLog = speculationLog;
        this.stageFlags = stageFlags == null ? EnumSet.noneOf(StageFlag.class) : stageFlags;
    }

    public static GraphState defaultGraphState() {
        return new GraphState(null, false, false, null, null, null, null);
    }

    public GraphState copy() {
        return new GraphState(this.currentStage, this.disabledFrameStateVerification, this.frameStateVerification, EnumSet.copyOf(this.futureRequiredStages), this.guardsStage, this.speculationLog, EnumSet.copyOf(this.stageFlags));
    }

    public GraphState copyWith(boolean isSubstitution, SpeculationLog speculationLogForCopy) {
        return new GraphState(this.currentStage, this.disabledFrameStateVerification, isSubstitution, EnumSet.copyOf(this.futureRequiredStages), this.guardsStage, speculationLogForCopy, EnumSet.copyOf(this.stageFlags));
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        Formatter formatter = new Formatter();
        formatter.format("%sGraphState:%n", prefix);
        formatter.format("%s\tGuards stage: %s%n", prefix, this.guardsStage.toString());
        formatter.format("%s\tStage flags:%n", prefix);
        for (StageFlag flag : this.stageFlags) {
            formatter.format("%s\t\t%s%n", prefix, flag.toString());
        }
        formatter.format("%s\tFrame state verification: %s%n", prefix, this.frameStateVerification.toString());
        formatter.format("%s\tFuture required stages: %s%n", prefix, this.futureRequiredStages.toString());
        return formatter.toString();
    }

    public String updateFromPreviousToString(GraphState previous) {
        if (this.equals(previous)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(GraphState.valueStringAsDiff(previous.guardsStage, this.guardsStage, "Guards stage: ", ", "));
        builder.append(GraphState.newFlagsToString(previous.stageFlags, this.stageFlags, "+", "Stage flags: "));
        builder.append(GraphState.valueStringAsDiff(previous.frameStateVerification, this.frameStateVerification, "Frame state verification: ", ", "));
        builder.append(GraphState.newFlagsToString(previous.futureRequiredStages, this.futureRequiredStages, "+", "Future required stages: "));
        builder.append(GraphState.newFlagsToString(this.futureRequiredStages, previous.futureRequiredStages, "-", ""));
        builder.setLength(builder.length() - 2);
        builder.append('}');
        return builder.toString();
    }

    private static <T> String valueStringAsDiff(T oldValue, T newValue, String prefix, String suffix) {
        if (oldValue == newValue) {
            return "";
        }
        return String.format("%s%s -> %s%s", prefix, oldValue, newValue, suffix);
    }

    private static String newFlagsToString(EnumSet<StageFlag> oldSet, EnumSet<StageFlag> newSet, String flagPrefix, String prefix) {
        Formatter formatter = new Formatter();
        Object newFlags = newSet.clone();
        ((AbstractSet)newFlags).removeAll(oldSet);
        if (!((AbstractCollection)newFlags).isEmpty()) {
            formatter.format(prefix, new Object[0]);
            Iterator iterator = ((AbstractCollection)newFlags).iterator();
            while (iterator.hasNext()) {
                StageFlag flag = (StageFlag)((Object)iterator.next());
                formatter.format("%s%s, ", flagPrefix, flag.toString());
            }
        }
        return formatter.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentStage, this.disabledFrameStateVerification, this.frameStateVerification, this.futureRequiredStages, this.guardsStage, this.speculationLog, this.stageFlags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphState)) {
            return false;
        }
        GraphState graphState = (GraphState)obj;
        return this.currentStage == graphState.currentStage && this.disabledFrameStateVerification == graphState.disabledFrameStateVerification && this.frameStateVerification == graphState.frameStateVerification && this.futureRequiredStages.equals(graphState.futureRequiredStages) && this.guardsStage == graphState.guardsStage && Objects.equals(this.speculationLog, graphState.speculationLog) && this.stageFlags.equals(graphState.stageFlags);
    }

    public SpeculationLog getSpeculationLog() {
        return this.speculationLog;
    }

    public boolean isFrameStateVerificationDisabled() {
        return this.disabledFrameStateVerification;
    }

    public FrameStateVerification getFrameStateVerification() {
        return this.frameStateVerification;
    }

    public boolean canWeakenFrameStateVerification(FrameStateVerification stage) {
        if (this.isFrameStateVerificationDisabled()) {
            assert (this.frameStateVerification == FrameStateVerification.NONE) : "Frame state verification is disabled, should be NONE but is " + this.frameStateVerification;
            return true;
        }
        return this.frameStateVerification.ordinal() <= stage.ordinal();
    }

    public void weakenFrameStateVerification(FrameStateVerification newFrameStateVerification) {
        if (this.isFrameStateVerificationDisabled()) {
            assert (this.frameStateVerification == FrameStateVerification.NONE) : "Frame state verification is disabled, should be NONE but is " + this.frameStateVerification;
            return;
        }
        assert (this.canWeakenFrameStateVerification(newFrameStateVerification)) : "Old verification " + this.frameStateVerification + " must imply new verification " + newFrameStateVerification + ", i.e., verification can only be relaxed over the course of compilation";
        this.frameStateVerification = newFrameStateVerification;
    }

    public void forceDisableFrameStateVerification() {
        this.weakenFrameStateVerification(FrameStateVerification.NONE);
        this.disabledFrameStateVerification = true;
    }

    public GuardsStage getGuardsStage() {
        return this.guardsStage;
    }

    public void setGuardsStage(GuardsStage guardsStage) {
        assert (guardsStage.ordinal() >= this.guardsStage.ordinal());
        this.guardsStage = guardsStage;
    }

    public boolean isExplicitExceptionsNoDeopt() {
        return this.guardsStage == GuardsStage.FIXED_DEOPTS && this.isAfterStage(StageFlag.GUARD_LOWERING);
    }

    public void configureExplicitExceptionsNoDeopt() {
        assert (!this.isExplicitExceptionsNoDeopt());
        assert (this.stageFlags.isEmpty()) : "Must not have set a stage flag before";
        assert (this.guardsStage == GuardsStage.FLOATING_GUARDS) : "Default guards stage is floating guards";
        this.setGuardsStage(GuardsStage.FIXED_DEOPTS);
        this.setAfterStage(StageFlag.GUARD_LOWERING);
    }

    public void configureExplicitExceptionsNoDeoptIfNecessary() {
        if (!this.isExplicitExceptionsNoDeopt()) {
            this.configureExplicitExceptionsNoDeopt();
        }
    }

    public void setAfterFSA() {
        this.setGuardsStage(GuardsStage.AFTER_FSA);
        this.setAfterStage(StageFlag.FSA);
    }

    public boolean isBeforeStage(StageFlag stage) {
        return !this.isDuringStage(stage) && !this.isAfterStage(stage);
    }

    public boolean isDuringStage(StageFlag stage) {
        return this.currentStage == stage;
    }

    public boolean isAfterStage(StageFlag stage) {
        return this.stageFlags.contains((Object)stage);
    }

    public boolean isAfterStages(EnumSet<StageFlag> stages) {
        return this.stageFlags.containsAll(stages);
    }

    public void setDuringStage(StageFlag stage) {
        assert (this.isBeforeStage(stage)) : "Cannot set during stage " + stage + " since the graph is not before that stage";
        this.currentStage = stage;
    }

    public void setAfterStage(StageFlag stage) {
        assert (!this.isAfterStage(stage)) : "Cannot set after stage " + stage + " since the graph is already in that state";
        this.stageFlags.add(stage);
        this.currentStage = null;
    }

    public EnumSet<StageFlag> getStageFlags() {
        return this.stageFlags;
    }

    public boolean hasAllMandatoryStages(MandatoryStages mandatoryStages) {
        return this.stageFlags.containsAll(mandatoryStages.highTier) && this.stageFlags.containsAll(mandatoryStages.midTier) && this.stageFlags.containsAll(mandatoryStages.lowTier);
    }

    public int countMissingStages(EnumSet<StageFlag> targetStages) {
        EnumSet<StageFlag> target = EnumSet.copyOf(targetStages);
        target.removeAll(this.stageFlags);
        return target.size();
    }

    public void addFutureStageRequirement(StageFlag stage) {
        this.futureRequiredStages.add(stage);
    }

    public void removeRequirementToStage(StageFlag stage) {
        this.futureRequiredStages.remove((Object)stage);
    }

    public boolean requiresFutureStage(StageFlag stage) {
        return this.futureRequiredStages.contains((Object)stage);
    }

    public boolean requiresFutureStages() {
        return !this.futureRequiredStages.isEmpty();
    }

    public EnumSet<StageFlag> getFutureRequiredStages() {
        return this.futureRequiredStages;
    }

    public static enum FrameStateVerification {
        ALL(EnumSet.allOf(FrameStateVerificationFeature.class)),
        ALL_EXCEPT_LOOP_EXIT(EnumSet.complementOf(EnumSet.of(FrameStateVerificationFeature.LOOP_EXITS))),
        ALL_EXCEPT_LOOPS(EnumSet.complementOf(EnumSet.of(FrameStateVerificationFeature.LOOP_BEGINS, FrameStateVerificationFeature.LOOP_EXITS))),
        NONE(EnumSet.noneOf(FrameStateVerificationFeature.class));

        private EnumSet<FrameStateVerificationFeature> features;

        private FrameStateVerification(EnumSet<FrameStateVerificationFeature> features) {
            this.features = features;
        }

        boolean implies(FrameStateVerificationFeature feature) {
            return this.features.contains((Object)feature);
        }
    }

    public static enum StageFlag {
        CANONICALIZATION,
        FINAL_PARTIAL_ESCAPE,
        HIGH_TIER_LOWERING,
        FLOATING_READS,
        GUARD_MOVEMENT,
        GUARD_LOWERING,
        VALUE_PROXY_REMOVAL,
        SAFEPOINTS_INSERTION,
        MID_TIER_LOWERING,
        OPTIMISTIC_ALIASING,
        FSA,
        NODE_VECTORIZATION,
        VECTOR_MATERIALIZATION,
        OPTIMISTIC_GUARDS,
        BARRIER_ADDITION,
        BARRIER_ELIMINATION,
        LOW_TIER_LOWERING,
        VECTOR_LOWERING,
        EXPAND_LOGIC,
        FIXED_READS,
        ADDRESS_LOWERING,
        FINAL_CANONICALIZATION,
        TARGET_VECTOR_LOWERING;

    }

    public static enum GuardsStage {
        FLOATING_GUARDS,
        FIXED_DEOPTS,
        AFTER_FSA;


        public boolean allowsFloatingGuards() {
            return this == FLOATING_GUARDS;
        }

        public boolean allowsGuardInsertion() {
            return this.ordinal() <= FIXED_DEOPTS.ordinal();
        }

        public boolean areFrameStatesAtDeopts() {
            return this == AFTER_FSA;
        }

        public boolean areFrameStatesAtSideEffects() {
            return !this.areFrameStatesAtDeopts();
        }

        public boolean areDeoptsFixed() {
            return this.ordinal() >= FIXED_DEOPTS.ordinal();
        }

        public boolean requiresValueProxies() {
            return this != AFTER_FSA;
        }

        public boolean reachedGuardsStage(GuardsStage stage) {
            return this.ordinal() >= stage.ordinal();
        }
    }

    public static enum MandatoryStages {
        ECONOMY(HIGH_TIER_MANDATORY_STAGES, MID_TIER_MANDATORY_STAGES, LOW_TIER_MANDATORY_STAGES),
        COMMUNITY(HIGH_TIER_MANDATORY_STAGES, MID_TIER_MANDATORY_STAGES, LOW_TIER_MANDATORY_STAGES),
        ENTERPRISE(HIGH_TIER_MANDATORY_STAGES, ENTERPRISE_MID_TIER_MANDATORY_STAGES, LOW_TIER_MANDATORY_STAGES);

        private final EnumSet<StageFlag> highTier;
        private final EnumSet<StageFlag> midTier;
        private final EnumSet<StageFlag> lowTier;

        private MandatoryStages(EnumSet<StageFlag> highTier, EnumSet<StageFlag> midTier, EnumSet<StageFlag> lowTier) {
            this.highTier = highTier;
            this.midTier = midTier;
            this.lowTier = lowTier;
        }

        public static MandatoryStages getFromName(String name) {
            switch (name.toLowerCase()) {
                case "economy": {
                    return ECONOMY;
                }
                case "community": {
                    return COMMUNITY;
                }
                case "enterprise": {
                    return ENTERPRISE;
                }
            }
            return COMMUNITY;
        }

        public EnumSet<StageFlag> getHighTier() {
            return this.highTier;
        }

        public EnumSet<StageFlag> getMidTier() {
            return this.midTier;
        }

        public EnumSet<StageFlag> getLowTier() {
            return this.lowTier;
        }
    }

    public static enum FrameStateVerificationFeature {
        STATE_SPLITS,
        MERGES,
        LOOP_BEGINS,
        LOOP_EXITS;

    }
}

