/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.GuardProxyNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(nameTemplate="GuardPhi({i#values})", allowedUsageTypes={InputType.Guard})
public final class GuardPhiNode
extends PhiNode
implements GuardingNode {
    public static final NodeClass<GuardPhiNode> TYPE = NodeClass.create(GuardPhiNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    NodeInputList<ValueNode> values;

    public GuardPhiNode(AbstractMergeNode merge) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.values = new NodeInputList(this);
    }

    public GuardPhiNode(AbstractMergeNode merge, ValueNode ... values) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    @Override
    public InputType valueInputType() {
        return InputType.Guard;
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    public PhiNode duplicateOn(AbstractMergeNode newMerge) {
        return this.graph().addWithoutUnique(new GuardPhiNode(newMerge));
    }

    @Override
    public GuardPhiNode duplicateWithValues(AbstractMergeNode newMerge, ValueNode ... newValues) {
        return new GuardPhiNode(newMerge, newValues);
    }

    @Override
    public ProxyNode createProxyFor(LoopExitNode lex) {
        return this.graph().addWithoutUnique(new GuardProxyNode(this, lex));
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.isLoopPhi()) {
            boolean allBackValuesNull = true;
            for (int i = 1; i < this.valueCount(); ++i) {
                ValueNode value = this.valueAt(i);
                if (value == null) continue;
                allBackValuesNull = false;
                break;
            }
            if (allBackValuesNull) {
                return this.valueAt(0);
            }
        }
        return super.canonical(tool);
    }
}

