/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.PathUtilities;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.NodeSuccessorList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.OptimizationLog;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.util.json.JSONFormatter;

public class OptimizationLogImpl
implements OptimizationLog {
    public static final String METHOD_NAME_PROPERTY = "methodName";
    public static final String OPTIMIZATION_NAME_PROPERTY = "optimizationName";
    public static final String EVENT_NAME_PROPERTY = "eventName";
    public static final String POSITION_PROPERTY = "position";
    public static final String PHASE_NAME_PROPERTY = "phaseName";
    public static final String OPTIMIZATIONS_PROPERTY = "optimizations";
    public static final String CALLSITE_BCI_PROPERTY = "callsiteBci";
    public static final String INLINED_PROPERTY = "inlined";
    public static final String INDIRECT_PROPERTY = "indirect";
    public static final String ALIVE_PROPERTY = "alive";
    public static final String REASON_PROPERTY = "reason";
    public static final String INVOKES_PROPERTY = "invokes";
    public static final String ROOT_PHASE_NAME = "RootPhase";
    public static final String COMPILATION_ID_PROPERTY = "compilationId";
    public static final String INLINING_TREE_PROPERTY = "inliningTree";
    public static final String OPTIMIZATION_TREE_PROPERTY = "optimizationTree";
    public static final String OPTIMIZATION_LOG_DIRECTORY = "optimization_log";
    public static final String MATURE_PROPERTY = "mature";
    public static final char LINE_SEPARATOR = '\n';
    public static final String TYPE_NAME_PROPERTY = "typeName";
    public static final String PROBABILITY_PROPERTY = "probability";
    public static final String PROFILED_TYPES_PROPERTY = "profiledTypes";
    public static final String RECEIVER_TYPE_PROFILE_PROPERTY = "receiverTypeProfile";
    public static final String CONCRETE_METHOD_NAME_PROPERTY = "concreteMethodName";
    private final StructuredGraph graph;
    private static volatile boolean optionsVerified = false;
    private final String compilationId;
    private final boolean optimizationLogEnabled;
    private OptimizationLog.PartialEscapeLog partialEscapeLog = null;
    private OptimizationPhaseNode currentPhase;
    private Graph optimizationTree;

    public OptimizationLogImpl(StructuredGraph graph) {
        this.graph = graph;
        this.optimizationLogEnabled = OptimizationLog.isOptimizationLogEnabled(graph.getOptions());
        if (this.optimizationLogEnabled) {
            this.compilationId = this.parseCompilationID();
            this.currentPhase = new OptimizationPhaseNode(ROOT_PHASE_NAME);
            this.optimizationTree = new Graph("OptimizationTree", graph.getOptions(), graph.getDebug(), false);
            this.optimizationTree.add(this.currentPhase);
            OptimizationLogImpl.verifyOptions(graph.getOptions());
        } else {
            this.compilationId = null;
            this.currentPhase = null;
            this.optimizationTree = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyOptions(OptionValues optionValues) {
        if (optionsVerified) {
            return;
        }
        boolean trackNodeSourcePosition = GraalOptions.TrackNodeSourcePosition.getValue(optionValues);
        if (!trackNodeSourcePosition) {
            Class<OptimizationLogImpl> clazz = OptimizationLogImpl.class;
            synchronized (OptimizationLogImpl.class) {
                if (!optionsVerified) {
                    TTY.println("Warning: %s without %s cannot assign bci to performed optimizations", DebugOptions.OptimizationLog.getName(), GraalOptions.TrackNodeSourcePosition.getName());
                    optionsVerified = true;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            optionsVerified = true;
        }
    }

    @Override
    public boolean isOptimizationLogEnabled() {
        return this.optimizationLogEnabled;
    }

    @Override
    public <V> OptimizationLog.OptimizationEntry withLazyProperty(String key, Supplier<V> valueSupplier) {
        return new OptimizationEntryImpl(this).withLazyProperty(key, valueSupplier);
    }

    @Override
    public OptimizationLog.OptimizationEntry withProperty(String key, Object value) {
        return new OptimizationEntryImpl(this).withProperty(key, value);
    }

    @Override
    public void report(int logLevel, Class<?> optimizationClass, String eventName, Node node) {
        new OptimizationEntryImpl(this).report(logLevel, optimizationClass, eventName, node);
    }

    public Graph getOptimizationTree() {
        return this.optimizationTree;
    }

    @Override
    public DebugCloseable enterPhase(CharSequence name) {
        if (this.optimizationLogEnabled) {
            OptimizationPhaseNode previousPhase = this.currentPhase;
            OptimizationPhaseNode subphase = new OptimizationPhaseNode(name);
            this.currentPhase.addChild(subphase);
            this.currentPhase = subphase;
            return () -> {
                this.currentPhase = previousPhase;
            };
        }
        return null;
    }

    @Override
    public void inline(OptimizationLog calleeOptimizationLog, boolean updatePosition, NodeSourcePosition invokePosition) {
        if (!this.optimizationLogEnabled || !calleeOptimizationLog.isOptimizationLogEnabled()) {
            return;
        }
        assert (calleeOptimizationLog instanceof OptimizationLogImpl) : "an enabled log is an instance of OptimizationLogImpl";
        OptimizationLogImpl calleeLogImpl = (OptimizationLogImpl)calleeOptimizationLog;
        Graph calleeTree = calleeLogImpl.optimizationTree;
        EconomicMap<Node, Node> duplicates = this.optimizationTree.addDuplicates(calleeTree.getNodes(), calleeTree, calleeTree.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)((EconomicMap)null));
        if (updatePosition) {
            for (Node duplicate : duplicates.getValues()) {
                if (!(duplicate instanceof OptimizationNode)) continue;
                OptimizationNode optimization = (OptimizationNode)duplicate;
                if (invokePosition != null && optimization.position != null) {
                    optimization.position = optimization.position.addCaller(invokePosition);
                    continue;
                }
                optimization.position = invokePosition;
            }
        }
        this.currentPhase.children.add((Node)duplicates.get((Object)calleeLogImpl.findRootPhase()));
    }

    @Override
    public void replaceLog(OptimizationLog replacementLog) {
        if (!this.optimizationLogEnabled) {
            return;
        }
        this.optimizationTree = new Graph(this.optimizationTree.name, this.optimizationTree.getOptions(), this.optimizationTree.getDebug(), this.optimizationTree.trackNodeSourcePosition());
        if (!replacementLog.isOptimizationLogEnabled()) {
            this.currentPhase = new OptimizationPhaseNode(ROOT_PHASE_NAME);
            this.optimizationTree.add(this.currentPhase);
            return;
        }
        assert (replacementLog instanceof OptimizationLogImpl) : "an enabled log is an instance of OptimizationLogImpl";
        OptimizationLogImpl replacementLogImpl = (OptimizationLogImpl)replacementLog;
        Graph replacementTree = replacementLogImpl.optimizationTree;
        EconomicMap<Node, Node> duplicates = this.optimizationTree.addDuplicates(replacementTree.getNodes(), replacementTree, replacementTree.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)((EconomicMap)null));
        this.currentPhase = (OptimizationPhaseNode)duplicates.get((Object)replacementLogImpl.findRootPhase());
    }

    @Override
    public DebugCloseable enterPartialEscapeAnalysis() {
        assert (this.partialEscapeLog == null);
        if (!this.optimizationLogEnabled) {
            return DebugCloseable.VOID_CLOSEABLE;
        }
        this.partialEscapeLog = new OptimizationLog.PartialEscapeLog();
        return () -> {
            assert (this.partialEscapeLog != null);
            MapCursor cursor = this.partialEscapeLog.getVirtualNodes().getEntries();
            while (cursor.advance()) {
                this.withProperty("materializations", cursor.getValue()).report(OptimizationLog.PartialEscapeLog.class, "AllocationVirtualization", (Node)cursor.getKey());
            }
            this.partialEscapeLog = null;
        };
    }

    @Override
    public OptimizationLog.PartialEscapeLog getPartialEscapeLog() {
        assert (this.partialEscapeLog != null);
        return this.partialEscapeLog;
    }

    public OptimizationPhaseNode getCurrentPhase() {
        return this.currentPhase;
    }

    @Override
    public void emit(Function<ResolvedJavaMethod, String> methodNameFormatter) {
        EconomicSet targets = (EconomicSet)DebugOptions.OptimizationLog.getValue(this.graph.getOptions());
        if (targets == null || targets.isEmpty()) {
            return;
        }
        if (targets.contains((Object)DebugOptions.OptimizationLogTarget.Dump)) {
            this.graph.getDebug().dump(0, this.optimizationTree, "Optimization tree");
        }
        boolean printToStdout = targets.contains((Object)DebugOptions.OptimizationLogTarget.Stdout);
        boolean printToFile = targets.contains((Object)DebugOptions.OptimizationLogTarget.Directory);
        if (!printToStdout && !printToFile) {
            return;
        }
        String json = JSONFormatter.formatJSON(this.asJSONMap(methodNameFormatter));
        if (printToStdout) {
            TTY.out().println(json);
        }
        if (printToFile) {
            try {
                String pathOptionValue = DebugOptions.OptimizationLogPath.getValue(this.graph.getOptions());
                if (pathOptionValue == null) {
                    pathOptionValue = PathUtilities.getPath(DebugOptions.getDumpDirectory(this.graph.getOptions()), OPTIMIZATION_LOG_DIRECTORY);
                }
                PathUtilities.createDirectories(pathOptionValue);
                String fileName = String.valueOf(Thread.currentThread().getId());
                String filePath = PathUtilities.getPath(pathOptionValue, fileName);
                try (OutputStream outputStream = PathUtilities.openOutputStream(filePath, true);
                     PrintStream printStream = new PrintStream(outputStream);){
                    printStream.print(json);
                    printStream.print('\n');
                    printStream.flush();
                }
            }
            catch (IOException exception) {
                throw new GraalError("Failed to print the optimization log to a file: %s", exception.getMessage());
            }
        }
    }

    public OptimizationPhaseNode findRootPhase() {
        OptimizationPhaseNode root = this.currentPhase;
        while (root.predecessor() != null) {
            root = (OptimizationPhaseNode)root.predecessor();
        }
        assert (ROOT_PHASE_NAME.contentEquals(root.getPhaseName()));
        return root;
    }

    private EconomicMap<String, Object> asJSONMap(Function<ResolvedJavaMethod, String> methodNameFormatter) {
        EconomicMap map = EconomicMap.create();
        String compilationMethodName = methodNameFormatter.apply(this.graph.method());
        map.put((Object)METHOD_NAME_PROPERTY, (Object)compilationMethodName);
        map.put((Object)COMPILATION_ID_PROPERTY, (Object)this.compilationId);
        map.put((Object)INLINING_TREE_PROPERTY, this.inliningTreeAsJSONMap(methodNameFormatter));
        map.put((Object)OPTIMIZATION_TREE_PROPERTY, this.currentPhase.asJSONMap(methodNameFormatter));
        return map;
    }

    private String parseCompilationID() {
        String fullCompilationId = this.graph.compilationId().toString(CompilationIdentifier.Verbosity.ID);
        int dash = fullCompilationId.indexOf(45);
        if (dash == -1) {
            return fullCompilationId;
        }
        return fullCompilationId.substring(dash + 1);
    }

    private EconomicMap<String, Object> inliningTreeAsJSONMap(Function<ResolvedJavaMethod, String> methodNameFormatter) {
        assert (this.graph.getInliningLog() != null);
        EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        return this.callsiteAsJSONMap(this.graph.getInliningLog().getRootCallsite(), true, null, methodNameFormatter, (EconomicMap<InliningLog.Callsite, EconomicMap<String, Object>>)replacements);
    }

    private EconomicMap<String, Object> callsiteAsJSONMap(InliningLog.Callsite callsite, boolean isInlined, List<String> reason, Function<ResolvedJavaMethod, String> methodNameFormatter, EconomicMap<InliningLog.Callsite, EconomicMap<String, Object>> replacements) {
        Iterator<InliningLog.Callsite> receiverTypeProfile;
        EconomicMap map = EconomicMap.create();
        replacements.put((Object)callsite, (Object)map);
        map.put((Object)METHOD_NAME_PROPERTY, callsite.getTarget() == null ? null : methodNameFormatter.apply(callsite.getTarget()));
        map.put((Object)CALLSITE_BCI_PROPERTY, (Object)callsite.getBci());
        map.put((Object)INLINED_PROPERTY, (Object)isInlined);
        map.put((Object)REASON_PROPERTY, reason);
        map.put((Object)INDIRECT_PROPERTY, (Object)callsite.isIndirect());
        map.put((Object)ALIVE_PROPERTY, (Object)(callsite.getInvoke() instanceof Node && ((Node)((Object)callsite.getInvoke())).isAlive() ? 1 : 0));
        if (callsite.isIndirect() && (receiverTypeProfile = this.receiverTypeProfileAsJSONMap(callsite, methodNameFormatter)) != null) {
            map.put((Object)RECEIVER_TYPE_PROFILE_PROPERTY, receiverTypeProfile);
        }
        for (InliningLog.Callsite child : callsite.getChildren()) {
            boolean childIsInlined = false;
            ArrayList<String> childReason = null;
            for (InliningLog.Decision childDecision : child.getDecisions()) {
                boolean bl = childIsInlined = childIsInlined || childDecision.isPositive();
                if (childDecision.getReason() == null) continue;
                if (childReason == null) {
                    childReason = new ArrayList<String>();
                }
                childReason.add(childDecision.getReason());
            }
            this.callsiteAsJSONMap(child, childIsInlined, childReason, methodNameFormatter, replacements);
        }
        if (callsite.getOverriddenParent() != null) {
            EconomicMap parentMap = (EconomicMap)replacements.get((Object)callsite.getOverriddenParent());
            assert (parentMap != null);
            ArrayList<EconomicMap> parentInvokesProperty = (ArrayList<EconomicMap>)parentMap.get((Object)INVOKES_PROPERTY);
            if (parentInvokesProperty == null) {
                parentInvokesProperty = new ArrayList<EconomicMap>();
                parentMap.put((Object)INVOKES_PROPERTY, parentInvokesProperty);
            }
            parentInvokesProperty.add(map);
        }
        return map;
    }

    private EconomicMap<String, Object> receiverTypeProfileAsJSONMap(InliningLog.Callsite callsite, Function<ResolvedJavaMethod, String> methodNameFormatter) {
        if (callsite.getParent() == null || callsite.getParent().getTarget() == null) {
            return null;
        }
        ProfilingInfo profilingInfo = this.graph.getProfileProvider().getProfilingInfo(callsite.getParent().getTarget());
        if (profilingInfo == null) {
            return null;
        }
        EconomicMap typeProfileMap = EconomicMap.create();
        typeProfileMap.put((Object)MATURE_PROPERTY, (Object)profilingInfo.isMature());
        if (callsite.getTargetTypeProfile() != null) {
            ArrayList<EconomicMap> profiledTypes = new ArrayList<EconomicMap>();
            for (JavaTypeProfile.ProfiledType profiledType : callsite.getTargetTypeProfile().getTypes()) {
                ResolvedJavaMethod concreteMethod;
                EconomicMap profiledTypeMap = EconomicMap.create();
                profiledTypeMap.put((Object)TYPE_NAME_PROPERTY, (Object)profiledType.getType().toJavaName(true));
                profiledTypeMap.put((Object)PROBABILITY_PROPERTY, (Object)profiledType.getProbability());
                if (callsite.getTarget() != null && (concreteMethod = profiledType.getType().resolveConcreteMethod(callsite.getTarget(), callsite.getParent().getTarget().getDeclaringClass())) != null) {
                    profiledTypeMap.put((Object)CONCRETE_METHOD_NAME_PROPERTY, (Object)methodNameFormatter.apply(concreteMethod));
                }
                profiledTypes.add(profiledTypeMap);
            }
            typeProfileMap.put((Object)PROFILED_TYPES_PROPERTY, profiledTypes);
        }
        return typeProfileMap;
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, shortName="Phase", nameTemplate="{p#phaseName/s}")
    public static class OptimizationPhaseNode
    extends OptimizationLog.OptimizationTreeNode {
        public static final NodeClass<OptimizationPhaseNode> TYPE = NodeClass.create(OptimizationPhaseNode.class);
        private final CharSequence phaseName;
        @Node.Successor
        private NodeSuccessorList<OptimizationLog.OptimizationTreeNode> children;

        protected OptimizationPhaseNode(CharSequence phaseName) {
            super((NodeClass<? extends OptimizationLog.OptimizationTreeNode>)TYPE);
            this.phaseName = phaseName;
            this.children = new NodeSuccessorList((Node)this, 0);
        }

        public CharSequence getPhaseName() {
            return this.phaseName;
        }

        public NodeSuccessorList<OptimizationLog.OptimizationTreeNode> getChildren() {
            return this.children;
        }

        public void addChild(OptimizationLog.OptimizationTreeNode node) {
            this.graph().add(node);
            this.children.add((Object)node);
        }

        @Override
        public EconomicMap<String, Object> asJSONMap(Function<ResolvedJavaMethod, String> methodNameFormatter) {
            EconomicMap map = EconomicMap.create();
            map.put((Object)OptimizationLogImpl.PHASE_NAME_PROPERTY, (Object)this.phaseName);
            ArrayList<EconomicMap<String, Object>> optimizations = null;
            if (this.children != null) {
                optimizations = new ArrayList<EconomicMap<String, Object>>();
                for (OptimizationLog.OptimizationTreeNode entry : this.children) {
                    optimizations.add(entry.asJSONMap(methodNameFormatter));
                }
            }
            map.put((Object)OptimizationLogImpl.OPTIMIZATIONS_PROPERTY, optimizations);
            return map;
        }
    }

    public static class OptimizationEntryImpl
    implements OptimizationLog.OptimizationEntry {
        private EconomicMap<String, Object> properties;
        private final OptimizationLogImpl optimizationLog;

        public OptimizationEntryImpl(OptimizationLogImpl optimizationLog) {
            this.optimizationLog = optimizationLog;
        }

        private static String createOptimizationName(Class<?> optimizationClass) {
            String phaseSuffix;
            String className = optimizationClass.getSimpleName();
            if (className.endsWith(phaseSuffix = "Phase")) {
                return className.substring(0, className.length() - phaseSuffix.length());
            }
            return className;
        }

        @Override
        public <V> OptimizationLog.OptimizationEntry withLazyProperty(String key, Supplier<V> valueSupplier) {
            if (this.properties == null) {
                this.properties = EconomicMap.create((int)1);
            }
            this.properties.put((Object)key, valueSupplier.get());
            return this;
        }

        @Override
        public OptimizationLog.OptimizationEntry withProperty(String key, Object value) {
            if (this.properties == null) {
                this.properties = EconomicMap.create((int)1);
            }
            this.properties.put((Object)key, value);
            return this;
        }

        @Override
        public void report(int logLevel, Class<?> optimizationClass, String eventName, Node node) {
            assert (logLevel >= 4);
            String optimizationName = OptimizationEntryImpl.createOptimizationName(optimizationClass);
            NodeSourcePosition position = node.getNodeSourcePosition();
            DebugContext debug = this.optimizationLog.graph.getDebug();
            if (debug.isCountEnabled() || debug.hasUnscopedCounters()) {
                DebugContext.counter(optimizationName + "_" + eventName).increment(debug);
            }
            if (debug.isLogEnabled(logLevel)) {
                debug.log(logLevel, "Performed %s %s for node %s at bci %s %s", (Object)optimizationName, (Object)eventName, (Object)node, position == null ? "unknown" : Integer.valueOf(position.getBCI()), (Object)(this.properties == null ? "" : JSONFormatter.formatJSON(this.properties)));
            }
            if (debug.isDumpEnabled(logLevel)) {
                debug.dump(logLevel, this.optimizationLog.graph, "%s %s for %s", optimizationName, eventName, node);
            }
            if (this.optimizationLog.optimizationLogEnabled) {
                this.optimizationLog.currentPhase.addChild(new OptimizationNode(this.properties, position, optimizationName, eventName));
            }
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, shortName="Optimization", nameTemplate="{p#event}")
    public static class OptimizationNode
    extends OptimizationLog.OptimizationTreeNode {
        public static final NodeClass<OptimizationNode> TYPE = NodeClass.create(OptimizationNode.class);
        private final EconomicMap<String, Object> properties;
        private NodeSourcePosition position;
        private final String optimizationName;
        private final String eventName;

        public OptimizationNode(EconomicMap<String, Object> properties, NodeSourcePosition position, String optimizationName, String eventName) {
            super((NodeClass<? extends OptimizationLog.OptimizationTreeNode>)TYPE);
            this.properties = properties;
            this.position = position;
            this.optimizationName = optimizationName;
            this.eventName = eventName;
        }

        private static EconomicMap<String, Integer> createPositionProperty(Function<ResolvedJavaMethod, String> methodNameFormatter, NodeSourcePosition position) {
            if (position == null) {
                return null;
            }
            EconomicMap map = EconomicMap.create();
            for (NodeSourcePosition current = position; current != null; current = current.getCaller()) {
                ResolvedJavaMethod method = current.getMethod();
                map.put((Object)methodNameFormatter.apply(method), (Object)current.getBCI());
            }
            return map;
        }

        @Override
        public EconomicMap<String, Object> asJSONMap(Function<ResolvedJavaMethod, String> methodNameFormatter) {
            EconomicMap jsonMap = EconomicMap.create();
            jsonMap.put((Object)OptimizationLogImpl.OPTIMIZATION_NAME_PROPERTY, (Object)this.optimizationName);
            jsonMap.put((Object)OptimizationLogImpl.EVENT_NAME_PROPERTY, (Object)this.eventName);
            jsonMap.put((Object)OptimizationLogImpl.POSITION_PROPERTY, OptimizationNode.createPositionProperty(methodNameFormatter, this.position));
            if (this.properties != null) {
                jsonMap.putAll(this.properties);
            }
            return jsonMap;
        }

        public EconomicMap<String, Object> getProperties() {
            return this.properties;
        }

        public String getOptimizationName() {
            return this.optimizationName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public NodeSourcePosition getPosition() {
            return this.position;
        }
    }
}

