/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Arrays;

public abstract class ProfileData {
    protected final ProfileSource profileSource;
    public static final double EPSILON = 1.0E-9;

    protected ProfileData(ProfileSource profileSource) {
        this.profileSource = profileSource;
    }

    public ProfileSource getProfileSource() {
        return this.profileSource;
    }

    public static boolean isApproximatelyEqual(double probability, double expected) {
        return Math.abs(probability - expected) <= 1.0E-9;
    }

    public static boolean isApproximatelyInRange(double probability, double min, double max) {
        return min - 1.0E-9 <= probability && probability <= max + 1.0E-9;
    }

    public static enum ProfileSource {
        INJECTED,
        PROFILED,
        ADOPTED,
        INFERRED,
        UNKNOWN;


        public ProfileSource combine(ProfileSource other) {
            if (this.ordinal() < other.ordinal()) {
                return this;
            }
            return other;
        }

        public static boolean isTrusted(ProfileSource source) {
            return source == INJECTED || source == PROFILED || source == ADOPTED || source == INFERRED;
        }

        public boolean isInjected() {
            return this == INJECTED;
        }

        public boolean isProfiled() {
            return this == PROFILED;
        }

        public boolean isAdopted() {
            return this == ADOPTED;
        }

        public boolean isInferred() {
            return this == INFERRED;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }
    }

    public static final class SwitchProbabilityData
    extends ProfileData {
        private final double[] keyProbabilities;

        private SwitchProbabilityData(double[] keyProbabilities, ProfileSource profileSource) {
            super(profileSource);
            this.keyProbabilities = keyProbabilities;
        }

        public static SwitchProbabilityData create(double[] keyProbabilities, ProfileSource profileSource) {
            return new SwitchProbabilityData(keyProbabilities, profileSource);
        }

        public double[] getKeyProbabilities() {
            return this.keyProbabilities;
        }

        public SwitchProbabilityData copy(double[] newKeyProbabilities) {
            return new SwitchProbabilityData(newKeyProbabilities, this.profileSource);
        }

        public static SwitchProbabilityData profiled(double[] keyProbabilities) {
            return new SwitchProbabilityData(keyProbabilities, ProfileSource.PROFILED);
        }

        public static SwitchProbabilityData unknown(double[] keyProbabilities) {
            return new SwitchProbabilityData(keyProbabilities, ProfileSource.UNKNOWN);
        }

        public String toString() {
            return this.profileSource + " keyProbabilities: " + Arrays.toString(this.keyProbabilities);
        }
    }

    public static final class LoopFrequencyData
    extends ProfileData {
        private final double loopFrequency;
        public static final LoopFrequencyData DEFAULT = new LoopFrequencyData(1.0, ProfileSource.UNKNOWN);

        private LoopFrequencyData(double loopFrequency, ProfileSource profileSource) {
            super(profileSource);
            assert (loopFrequency >= 1.0);
            this.loopFrequency = loopFrequency;
        }

        public static LoopFrequencyData create(double loopFrequency, ProfileSource profileSource) {
            if (loopFrequency == 1.0 && profileSource == ProfileSource.UNKNOWN) {
                return DEFAULT;
            }
            return new LoopFrequencyData(loopFrequency, profileSource);
        }

        public double getLoopFrequency() {
            return this.loopFrequency;
        }

        public LoopFrequencyData copy(double newFrequency) {
            return LoopFrequencyData.create(newFrequency, this.getProfileSource());
        }

        public LoopFrequencyData decrementFrequency(double decrement) {
            double newFrequency = Math.max(1.0, this.getLoopFrequency() - decrement);
            return this.copy(newFrequency);
        }

        public String toString() {
            return this.profileSource + " loopFrequency: " + this.loopFrequency;
        }
    }

    public static final class BranchProbabilityData
    extends ProfileData {
        private final double designatedSuccessorProbability;
        private static final BranchProbabilityData UNKNOWN_BRANCH_PROFILE = new BranchProbabilityData(0.5, ProfileSource.UNKNOWN);

        private BranchProbabilityData(double designatedSuccessorProbability, ProfileSource profileSource) {
            super(profileSource);
            this.designatedSuccessorProbability = designatedSuccessorProbability;
        }

        public static BranchProbabilityData create(double designatedSuccessorProbability, ProfileSource profileSource) {
            if (designatedSuccessorProbability == 0.5 && profileSource == ProfileSource.UNKNOWN) {
                return UNKNOWN_BRANCH_PROFILE;
            }
            return new BranchProbabilityData(designatedSuccessorProbability, profileSource);
        }

        public double getDesignatedSuccessorProbability() {
            return this.designatedSuccessorProbability;
        }

        public double getNegatedProbability() {
            return 1.0 - this.designatedSuccessorProbability;
        }

        public BranchProbabilityData copy(double newProbability) {
            if (newProbability == this.designatedSuccessorProbability) {
                return this;
            }
            return BranchProbabilityData.create(newProbability, this.profileSource);
        }

        public BranchProbabilityData negated() {
            return this.copy(this.getNegatedProbability());
        }

        public static BranchProbabilityData injected(double probability) {
            return BranchProbabilityData.create(probability, ProfileSource.INJECTED);
        }

        public static BranchProbabilityData injected(double probability, boolean negated) {
            return negated ? BranchProbabilityData.injected(1.0 - probability) : BranchProbabilityData.injected(probability);
        }

        public static BranchProbabilityData profiled(double probability) {
            return BranchProbabilityData.create(probability, ProfileSource.PROFILED);
        }

        public static BranchProbabilityData adopted(double probability) {
            return BranchProbabilityData.create(probability, ProfileSource.ADOPTED);
        }

        public static BranchProbabilityData inferred(double probability) {
            return BranchProbabilityData.create(probability, ProfileSource.INFERRED);
        }

        public static BranchProbabilityData unknown() {
            return UNKNOWN_BRANCH_PROFILE;
        }

        public static BranchProbabilityData combineShortCircuitOr(BranchProbabilityData a, BranchProbabilityData b) {
            double p1 = a.getDesignatedSuccessorProbability();
            double p2 = b.getDesignatedSuccessorProbability();
            double combinedProbability = p1 + (1.0 - p1) * p2;
            ProfileSource combinedSource = a.getProfileSource().combine(b.getProfileSource());
            return BranchProbabilityData.create(combinedProbability, combinedSource);
        }

        public BranchProbabilityData combineAndWithNegated(BranchProbabilityData other) {
            double p = this.getDesignatedSuccessorProbability() * other.getNegatedProbability();
            return BranchProbabilityData.create(p, this.getProfileSource().combine(other.profileSource));
        }

        public String toString() {
            return this.profileSource + " designatedSuccessorProbability: " + this.designatedSuccessorProbability;
        }
    }
}

