/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="+")
public class AddNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Add>
implements NarrowableArithmeticNode,
Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<AddNode> TYPE = NodeClass.create(AddNode.class);

    public AddNode(ValueNode x, ValueNode y) {
        this(TYPE, x, y);
    }

    protected AddNode(NodeClass<? extends AddNode> c, ValueNode x, ValueNode y) {
        super(c, AddNode.getArithmeticOpTable(x).getAdd(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Add> op = ArithmeticOpTable.forStamp(x.stamp(view)).getAdd();
        ConstantNode tryConstantFold = AddNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        if (x.isConstant() && !y.isConstant()) {
            return AddNode.canonical(null, op, y, x, view, false);
        }
        return AddNode.canonical(null, op, x, y, view, false);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Add> getOp(ArithmeticOpTable table) {
        return table.getAdd();
    }

    private static ValueNode canonical(AddNode addNode, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Add> op, ValueNode forX, ValueNode forY, NodeView view, boolean allUsagesAvailable) {
        NotNode notX;
        NotNode notY;
        Stamp stamp;
        AddNode self = addNode;
        boolean associative = op.isAssociative();
        if (associative) {
            SubNode sub;
            if (forX instanceof SubNode && (sub = (SubNode)forX).getY() == forY) {
                return sub.getX();
            }
            if (forY instanceof SubNode && (sub = (SubNode)forY).getY() == forX) {
                return sub.getX();
            }
        }
        if (associative && op.isCommutative() && allUsagesAvailable && (stamp = forX.stamp(view)) instanceof IntegerStamp) {
            Object add;
            AddNode add2;
            IntegerStamp integerStamp = (IntegerStamp)stamp;
            AddNode inputAdd = null;
            if (forX instanceof AddNode && ((add2 = (AddNode)forX).getX() == forY || add2.getY() == forY)) {
                inputAdd = add2;
            } else if (forY instanceof AddNode && (((BinaryNode)(add = (AddNode)forY)).getX() == forX || ((BinaryNode)add).getY() == forX)) {
                inputAdd = add;
            }
            if (inputAdd != null) {
                boolean isRoot = true;
                for (Node usage : self.usages()) {
                    AddNode add3;
                    if (!(usage instanceof AddNode) || (add3 = (AddNode)usage).getX() != forX && add3.getX() != forY && add3.getY() != forX && add3.getY() != forY) continue;
                    isRoot = false;
                    break;
                }
                if (isRoot) {
                    ValueNode addend = inputAdd == forX ? forY : forX;
                    AddNode currentAdd = inputAdd;
                    int count = 1;
                    ValueNode other = null;
                    while ((currentAdd.getX() == addend || currentAdd.getY() == addend) && currentAdd.hasExactlyOneUsage()) {
                        AddNode add4;
                        ++count;
                        ValueNode valueNode = other = currentAdd.getX() == addend ? currentAdd.getY() : currentAdd.getX();
                        if (!(other instanceof AddNode)) break;
                        currentAdd = add4 = (AddNode)other;
                    }
                    if (other != null) {
                        return BinaryArithmeticNode.add(other, BinaryArithmeticNode.mul(ConstantNode.forIntegerStamp(integerStamp, count), addend, view), view);
                    }
                }
            }
        }
        if (forY.isConstant()) {
            ValueNode reassociated;
            Constant c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            if (associative && self != null && (reassociated = AddNode.reassociateMatchedValues(self, ValueNode.isConstantPredicate(), forX, forY, view)) != self) {
                return reassociated;
            }
            if (c instanceof JavaConstant && (forX instanceof SignExtendNode || forX instanceof ZeroExtendNode)) {
                IntegerStamp narrowConstantStamp;
                IntegerStamp beforeExtendStamp;
                int bits;
                AddNode addBeforeExtend;
                IntegerConvertNode integerConvertNode = (IntegerConvertNode)forX;
                ValueNode valueNode = integerConvertNode.getValue();
                long constant = ((JavaConstant)c).asLong();
                if (valueNode instanceof AddNode && (addBeforeExtend = (AddNode)valueNode).getY().isConstant() && constant >= CodeUtil.minValue((int)(bits = (beforeExtendStamp = (IntegerStamp)addBeforeExtend.stamp(view)).getBits())) && constant <= CodeUtil.maxValue((int)bits) && !IntegerStamp.addCanOverflow(narrowConstantStamp = IntegerStamp.create(bits, constant, constant), beforeExtendStamp)) {
                    ConstantNode constantNode = ConstantNode.forIntegerStamp(narrowConstantStamp, constant);
                    if (forX instanceof SignExtendNode) {
                        return SignExtendNode.create(AddNode.create(addBeforeExtend, constantNode, view), integerConvertNode.getResultBits(), view);
                    }
                    assert (forX instanceof ZeroExtendNode);
                    boolean crossesZeroPoint = true;
                    if (constant > 0L) {
                        if (beforeExtendStamp.lowerBound() >= 0L || beforeExtendStamp.upperBound() < -constant) {
                            crossesZeroPoint = false;
                        }
                    } else if (beforeExtendStamp.lowerBound() >= -constant || beforeExtendStamp.upperBound() < 0L) {
                        crossesZeroPoint = false;
                    }
                    if (!crossesZeroPoint) {
                        return ZeroExtendNode.create(AddNode.create(addBeforeExtend, constantNode, view), integerConvertNode.getResultBits(), view);
                    }
                }
            }
        }
        if (forX instanceof NegateNode) {
            return BinaryArithmeticNode.sub(forY, ((NegateNode)forX).getValue(), view);
        }
        if (forY instanceof NegateNode) {
            return BinaryArithmeticNode.sub(forX, ((NegateNode)forY).getValue(), view);
        }
        if (forX instanceof NotNode && (notY = (NotNode)forX).getValue() == forY) {
            return ConstantNode.forIntegerStamp(forX.stamp(view), -1L);
        }
        if (forY instanceof NotNode && forX == (notX = (NotNode)forY).getValue()) {
            return ConstantNode.forIntegerStamp(forX.stamp(view), -1L);
        }
        if (self == null) {
            self = (AddNode)new AddNode(forX, forY).maybeCommuteInputs();
        }
        return self;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            ValueNode improvement = this.canonical(tool, forY, forX);
            if (improvement != this) {
                return improvement;
            }
            return new AddNode(forY, forX);
        }
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Add> op = this.getOp(forX, forY);
        NodeView view = NodeView.from(tool);
        return AddNode.canonical(this, op, forX, forY, view, tool.allUsagesAvailable());
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value op1 = nodeValueMap.operand(this.getX());
        assert (op1 != null) : this.getX() + ", this=" + this;
        Value op2 = nodeValueMap.operand(this.getY());
        if (this.shouldSwapInputs(nodeValueMap)) {
            Value tmp = op1;
            op1 = op2;
            op2 = tmp;
        }
        nodeValueMap.setResult(this, gen.emitAdd(op1, op2, false));
    }

    protected boolean isExact() {
        return false;
    }
}

