/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import java.util.Set;
import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.ArithmeticStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodePredicate;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ArithmeticOperation;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MaxNode;
import org.graalvm.compiler.nodes.calc.MinNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedMaxNode;
import org.graalvm.compiler.nodes.calc.UnsignedMinNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public abstract class BinaryArithmeticNode<OP>
extends BinaryNode
implements ArithmeticOperation,
ArithmeticLIRLowerable,
Canonicalizable.Binary<ValueNode> {
    public static final NodeClass<BinaryArithmeticNode> TYPE = NodeClass.create(BinaryArithmeticNode.class);

    protected BinaryArithmeticNode(NodeClass<? extends BinaryArithmeticNode<OP>> c, ArithmeticOpTable.BinaryOp<OP> opForStampComputation, ValueNode x, ValueNode y) {
        super(c, opForStampComputation.foldStamp(x.stamp(NodeView.DEFAULT), y.stamp(NodeView.DEFAULT)), x, y);
    }

    protected BinaryArithmeticNode(NodeClass<? extends BinaryArithmeticNode<OP>> c, Stamp stamp, ValueNode x, ValueNode y) {
        super(c, stamp, x, y);
    }

    public static ArithmeticOpTable getArithmeticOpTable(ValueNode forValue) {
        return ArithmeticOpTable.forStamp(forValue.stamp(NodeView.DEFAULT));
    }

    protected abstract ArithmeticOpTable.BinaryOp<OP> getOp(ArithmeticOpTable var1);

    protected final ArithmeticOpTable.BinaryOp<OP> getOp(ValueNode forX, ValueNode forY) {
        ArithmeticOpTable table = BinaryArithmeticNode.getArithmeticOpTable(forX);
        assert (table.equals(BinaryArithmeticNode.getArithmeticOpTable(forY)));
        return this.getOp(table);
    }

    @Override
    public final ArithmeticOpTable.BinaryOp<OP> getArithmeticOp() {
        return this.getOp(this.getX(), this.getY());
    }

    public boolean isAssociative() {
        return ((ArithmeticOpTable.BinaryOp)this.getArithmeticOp()).isAssociative();
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ConstantNode result = BinaryArithmeticNode.tryConstantFold(this.getOp(forX, forY), forX, forY, this.stamp(view), view);
        if (result != null) {
            return result;
        }
        if (forX instanceof ConditionalNode && forY.isConstant() && forX.hasExactlyOneUsage()) {
            ConstantNode falseConstant;
            ConditionalNode conditionalNode = (ConditionalNode)forX;
            ArithmeticOpTable.Op arithmeticOp = this.getArithmeticOp();
            ConstantNode trueConstant = BinaryArithmeticNode.tryConstantFold(arithmeticOp, conditionalNode.trueValue(), forY, this.stamp(view), view);
            if (trueConstant != null && (falseConstant = BinaryArithmeticNode.tryConstantFold(arithmeticOp, conditionalNode.falseValue(), forY, this.stamp(view), view)) != null) {
                return ConditionalNode.create(conditionalNode.condition, trueConstant, falseConstant, view);
            }
        }
        return this;
    }

    public static <OP> ConstantNode tryConstantFold(ArithmeticOpTable.BinaryOp<OP> op, ValueNode forX, ValueNode forY, Stamp stamp, NodeView view) {
        Constant ret;
        if (forX.isConstant() && forY.isConstant() && (ret = op.foldConstant(forX.asConstant(), forY.asConstant())) != null) {
            return ConstantNode.forPrimitive(stamp, ret);
        }
        return null;
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        assert (stampX.isCompatible(this.x.stamp(NodeView.DEFAULT)) && stampY.isCompatible(this.y.stamp(NodeView.DEFAULT)));
        return ((ArithmeticOpTable.BinaryOp)this.getArithmeticOp()).foldStamp(stampX, stampY);
    }

    public static ValueNode binaryIntegerOp(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view, ArithmeticOpTable.BinaryOp<?> op) {
        return graph.addOrUniqueWithInputs(BinaryArithmeticNode.binaryIntegerOp(v1, v2, view, op));
    }

    public static ValueNode binaryIntegerOp(ValueNode v1, ValueNode v2, NodeView view, ArithmeticOpTable.BinaryOp<?> op) {
        if (IntegerStamp.OPS.getAdd().equals(op)) {
            return BinaryArithmeticNode.add(v1, v2, view);
        }
        if (IntegerStamp.OPS.getSub().equals(op)) {
            return BinaryArithmeticNode.sub(v1, v2, view);
        }
        if (IntegerStamp.OPS.getMul().equals(op)) {
            return BinaryArithmeticNode.mul(v1, v2, view);
        }
        if (IntegerStamp.OPS.getRem().equals(op)) {
            return BinaryArithmeticNode.rem(v1, v2, view);
        }
        if (IntegerStamp.OPS.getAnd().equals(op)) {
            return BinaryArithmeticNode.and(v1, v2, view);
        }
        if (IntegerStamp.OPS.getOr().equals(op)) {
            return BinaryArithmeticNode.or(v1, v2, view);
        }
        if (IntegerStamp.OPS.getXor().equals(op)) {
            return BinaryArithmeticNode.xor(v1, v2, view);
        }
        if (IntegerStamp.OPS.getMax().equals(op)) {
            return BinaryArithmeticNode.max(v1, v2, view);
        }
        if (IntegerStamp.OPS.getMin().equals(op)) {
            return BinaryArithmeticNode.min(v1, v2, view);
        }
        if (IntegerStamp.OPS.getUMax().equals(op)) {
            return BinaryArithmeticNode.umax(v1, v2, view);
        }
        if (IntegerStamp.OPS.getUMin().equals(op)) {
            return BinaryArithmeticNode.umin(v1, v2, view);
        }
        if (Set.of(IntegerStamp.OPS.getBinaryOps()).contains(op)) {
            GraalError.unimplemented(String.format("creating %s via BinaryArithmeticNode#binaryIntegerOp is not implemented yet", op));
        } else {
            GraalError.shouldNotReachHere(String.format("%s is not a binary operation!", op));
        }
        return null;
    }

    public static ValueNode binaryFloatOp(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view, ArithmeticOpTable.BinaryOp<?> op) {
        return graph.addOrUniqueWithInputs(BinaryArithmeticNode.binaryFloatOp(v1, v2, view, op));
    }

    public static ValueNode binaryFloatOp(ValueNode v1, ValueNode v2, NodeView view, ArithmeticOpTable.BinaryOp<?> op) {
        if (FloatStamp.OPS.getAdd().equals(op)) {
            return BinaryArithmeticNode.add(v1, v2, view);
        }
        if (FloatStamp.OPS.getSub().equals(op)) {
            return BinaryArithmeticNode.sub(v1, v2, view);
        }
        if (FloatStamp.OPS.getMul().equals(op)) {
            return BinaryArithmeticNode.mul(v1, v2, view);
        }
        if (FloatStamp.OPS.getAnd().equals(op)) {
            return BinaryArithmeticNode.and(v1, v2, view);
        }
        if (FloatStamp.OPS.getOr().equals(op)) {
            return BinaryArithmeticNode.or(v1, v2, view);
        }
        if (FloatStamp.OPS.getXor().equals(op)) {
            return BinaryArithmeticNode.xor(v1, v2, view);
        }
        if (FloatStamp.OPS.getMax().equals(op)) {
            return BinaryArithmeticNode.max(v1, v2, view);
        }
        if (FloatStamp.OPS.getMin().equals(op)) {
            return BinaryArithmeticNode.min(v1, v2, view);
        }
        if (Set.of(FloatStamp.OPS.getBinaryOps()).contains(op)) {
            GraalError.unimplemented(String.format("creating %s via BinaryArithmeticNode#binaryFloatOp is not implemented yet", op));
        } else {
            GraalError.shouldNotReachHere(String.format("%s is not a binary operation!", op));
        }
        return null;
    }

    public static ValueNode add(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(AddNode.create(v1, v2, view));
    }

    public static ValueNode add(ValueNode v1, ValueNode v2, NodeView view) {
        return AddNode.create(v1, v2, view);
    }

    public static ValueNode add(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.add(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode sub(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(SubNode.create(v1, v2, view));
    }

    public static ValueNode sub(ValueNode v1, ValueNode v2, NodeView view) {
        return SubNode.create(v1, v2, view);
    }

    public static ValueNode sub(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.sub(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode mul(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(MulNode.create(v1, v2, view));
    }

    public static ValueNode mul(ValueNode v1, ValueNode v2, NodeView view) {
        return MulNode.create(v1, v2, view);
    }

    public static ValueNode mul(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.mul(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode rem(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(RemNode.create(v1, v2, view));
    }

    public static ValueNode rem(ValueNode v1, ValueNode v2, NodeView view) {
        return RemNode.create(v1, v2, view);
    }

    public static ValueNode rem(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.rem(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode and(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(AndNode.create(v1, v2, view));
    }

    public static ValueNode and(ValueNode v1, ValueNode v2, NodeView view) {
        return AndNode.create(v1, v2, view);
    }

    public static ValueNode and(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.and(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode or(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(OrNode.create(v1, v2, view));
    }

    public static ValueNode or(ValueNode v1, ValueNode v2, NodeView view) {
        return OrNode.create(v1, v2, view);
    }

    public static ValueNode or(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.or(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode xor(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(XorNode.create(v1, v2, view));
    }

    public static ValueNode xor(ValueNode v1, ValueNode v2, NodeView view) {
        return XorNode.create(v1, v2, view);
    }

    public static ValueNode xor(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.xor(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode max(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(MaxNode.create(v1, v2, view));
    }

    public static ValueNode max(ValueNode v1, ValueNode v2, NodeView view) {
        return MaxNode.create(v1, v2, view);
    }

    public static ValueNode max(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.max(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode min(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(MinNode.create(v1, v2, view));
    }

    public static ValueNode min(ValueNode v1, ValueNode v2, NodeView view) {
        return MinNode.create(v1, v2, view);
    }

    public static ValueNode min(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.min(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode umax(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(UnsignedMaxNode.create(v1, v2, view));
    }

    public static ValueNode umax(ValueNode v1, ValueNode v2, NodeView view) {
        return UnsignedMaxNode.create(v1, v2, view);
    }

    public static ValueNode umax(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.umax(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode umin(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(UnsignedMinNode.create(v1, v2, view));
    }

    public static ValueNode umin(ValueNode v1, ValueNode v2, NodeView view) {
        return UnsignedMinNode.create(v1, v2, view);
    }

    public static ValueNode umin(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.umin(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode shl(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(LeftShiftNode.create(v1, v2, view));
    }

    public static ValueNode shl(ValueNode v1, ValueNode v2, NodeView view) {
        return LeftShiftNode.create(v1, v2, view);
    }

    public static ValueNode shl(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.shl(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode shr(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(RightShiftNode.create(v1, v2, view));
    }

    public static ValueNode shr(ValueNode v1, ValueNode v2, NodeView view) {
        return RightShiftNode.create(v1, v2, view);
    }

    public static ValueNode shr(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.shr(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode ushr(StructuredGraph graph, ValueNode v1, ValueNode v2, NodeView view) {
        return graph.addOrUniqueWithInputs(UnsignedRightShiftNode.create(v1, v2, view));
    }

    public static ValueNode ushr(ValueNode v1, ValueNode v2, NodeView view) {
        return UnsignedRightShiftNode.create(v1, v2, view);
    }

    public static ValueNode ushr(ValueNode v1, ValueNode v2) {
        return BinaryArithmeticNode.ushr(v1, v2, NodeView.DEFAULT);
    }

    public static ValueNode branchlessMin(ValueNode v1, ValueNode v2, NodeView view) {
        if (v1.isDefaultConstant() && !v2.isDefaultConstant()) {
            return BinaryArithmeticNode.branchlessMin(v2, v1, view);
        }
        int bits = ((IntegerStamp)v1.stamp(view)).getBits();
        assert (((IntegerStamp)v2.stamp(view)).getBits() == bits);
        ValueNode t1 = BinaryArithmeticNode.sub(v1, v2, view);
        ValueNode t2 = RightShiftNode.create(t1, bits - 1, view);
        ValueNode t3 = AndNode.create(t1, t2, view);
        return BinaryArithmeticNode.add(v2, t3, view);
    }

    public static ValueNode branchlessMax(ValueNode v1, ValueNode v2, NodeView view) {
        if (v1.isDefaultConstant() && !v2.isDefaultConstant()) {
            return BinaryArithmeticNode.branchlessMax(v2, v1, view);
        }
        int bits = ((IntegerStamp)v1.stamp(view)).getBits();
        assert (((IntegerStamp)v2.stamp(view)).getBits() == bits);
        if (v2.isDefaultConstant()) {
            return AndNode.create(v1, NotNode.create(RightShiftNode.create(v1, bits - 1, view)), view);
        }
        ValueNode t1 = BinaryArithmeticNode.sub(v1, v2, view);
        ValueNode t2 = RightShiftNode.create(t1, bits - 1, view);
        ValueNode t3 = AndNode.create(t1, t2, view);
        return BinaryArithmeticNode.sub(v1, t3, view);
    }

    private static ReassociateMatch findReassociate(BinaryNode binary, NodePredicate criterion) {
        boolean resultX = criterion.apply(binary.getX());
        boolean resultY = criterion.apply(binary.getY());
        if (resultX && !resultY) {
            return ReassociateMatch.x;
        }
        if (!resultX && resultY) {
            return ReassociateMatch.y;
        }
        return null;
    }

    private static ReassociateMatch findReassociate(BinaryArithmeticNode<?> parent, ValueNode child, NodePredicate criterion) {
        if (!BinaryArithmeticNode.isReassociative(parent, child)) {
            return null;
        }
        if (child.hasExactlyOneUsage() && child.usages().first().equals(parent)) {
            return BinaryArithmeticNode.findReassociate((BinaryNode)child, criterion);
        }
        return null;
    }

    private static boolean isReassociative(BinaryArithmeticNode<?> parent, ValueNode child) {
        if (!parent.mayReassociate()) {
            return false;
        }
        if (BinaryArithmeticNode.isNonExactAddOrSub(parent)) {
            return BinaryArithmeticNode.isNonExactAddOrSub(child);
        }
        return child.getClass() == parent.getClass();
    }

    public boolean mayReassociate() {
        return BinaryArithmeticNode.mayReassociate(this.getArithmeticOp(), this.stamp(NodeView.DEFAULT));
    }

    public static boolean mayReassociate(ArithmeticOpTable.BinaryOp<?> op, Stamp stamp) {
        return op.isAssociative() && op.isCommutative() || stamp.isIntegerStamp() && op.equals(((ArithmeticStamp)stamp).getOps().getSub());
    }

    public static ValueNode reassociateUnmatchedValues(BinaryArithmeticNode<?> node, NodePredicate criterion, NodeView view) {
        ValueNode forX = node.getX();
        ValueNode forY = node.getY();
        ArithmeticOpTable.BinaryOp<?> op = node.getOp(forX, forY);
        GraalError.guarantee(node.mayReassociate(), "%s: binary op %s does not satisfy precondition of reassociateUnmatchedValues", node, op);
        if (criterion.apply(forX) || criterion.apply(forY)) {
            return node;
        }
        ReassociateMatch match = BinaryArithmeticNode.findReassociate(node, forX, criterion);
        BinaryNode matchBinary = null;
        ValueNode otherValue1 = null;
        if (match != null) {
            matchBinary = (BinaryNode)forX;
            otherValue1 = forY;
        } else {
            match = BinaryArithmeticNode.findReassociate(node, forY, criterion);
            if (match != null) {
                matchBinary = (BinaryNode)forY;
                otherValue1 = forX;
            }
        }
        if (match == null) {
            return node;
        }
        assert (matchBinary != null && otherValue1 != null);
        ValueNode matchValue = match.getValue(matchBinary);
        ValueNode otherValue2 = match.getOtherValue(matchBinary);
        if (BinaryArithmeticNode.isNonExactAddOrSub(node)) {
            boolean addSub = BinaryArithmeticNode.isNonExactAdd(node) && BinaryArithmeticNode.isNonExactSub(matchBinary);
            boolean subAdd = BinaryArithmeticNode.isNonExactSub(node) && BinaryArithmeticNode.isNonExactAdd(matchBinary);
            boolean subSub = BinaryArithmeticNode.isNonExactSub(node) && BinaryArithmeticNode.isNonExactSub(matchBinary);
            boolean sub = false;
            boolean invertSub = false;
            if (addSub) {
                sub = match == ReassociateMatch.y;
            } else if (subAdd) {
                sub = matchBinary == forY;
            } else if (subSub) {
                sub = matchBinary == forX && match == ReassociateMatch.y || matchBinary == forY && match == ReassociateMatch.x;
                boolean bl = invertSub = matchBinary == forX && match == ReassociateMatch.x;
            }
            if (node instanceof SubNode && matchBinary == forX) {
                ValueNode temp = otherValue1;
                otherValue1 = otherValue2;
                otherValue2 = temp;
            }
            ValueNode associated = subAdd || addSub && match == ReassociateMatch.x || subSub && match == ReassociateMatch.y ? BinaryArithmeticNode.sub(otherValue1, otherValue2, view) : BinaryArithmeticNode.add(otherValue1, otherValue2, view);
            if (invertSub) {
                return BinaryArithmeticNode.sub(matchValue, associated, view);
            }
            if (sub) {
                return BinaryArithmeticNode.sub(associated, matchValue, view);
            }
            return BinaryArithmeticNode.add(associated, matchValue, view);
        }
        if (BinaryArithmeticNode.isNonExactMul(node)) {
            return BinaryArithmeticNode.mul(matchValue, BinaryArithmeticNode.mul(otherValue1, otherValue2, view), view);
        }
        if (node instanceof AndNode) {
            return AndNode.create(matchValue, AndNode.create(otherValue1, otherValue2, view), view);
        }
        if (node instanceof OrNode) {
            return OrNode.create(matchValue, OrNode.create(otherValue1, otherValue2, view), view);
        }
        if (node instanceof XorNode) {
            return XorNode.create(matchValue, XorNode.create(otherValue1, otherValue2, view), view);
        }
        if (node instanceof MinNode) {
            return MinNode.create(matchValue, MinNode.create(otherValue1, otherValue2, view), view);
        }
        if (node instanceof MaxNode) {
            return MaxNode.create(matchValue, MaxNode.create(otherValue1, otherValue2, view), view);
        }
        throw GraalError.shouldNotReachHere("unhandled node in reassociation with constants: " + node);
    }

    public static ValueNode reassociateMatchedValues(BinaryArithmeticNode<?> node, NodePredicate criterion, ValueNode forX, ValueNode forY, NodeView view) {
        BinaryNode other;
        ReassociateMatch match2;
        ArithmeticOpTable.BinaryOp<?> op = node.getOp(forX, forY);
        GraalError.guarantee(node.mayReassociate(), "%s: binary op %s does not satisfy precondition of reassociateMatchedValues", node, op);
        ReassociateMatch match1 = BinaryArithmeticNode.findReassociate(node, criterion);
        if (match1 == null) {
            return node;
        }
        if (BinaryArithmeticNode.isExactMathOperation(node)) {
            return node;
        }
        if (node instanceof GuardedNode && ((GuardedNode)((Object)node)).getGuard() != null) {
            return node;
        }
        ValueNode otherValue = match1.getOtherValue(node);
        boolean addSub = false;
        boolean subAdd = false;
        if (otherValue.getClass() != node.getClass()) {
            if (BinaryArithmeticNode.isNonExactAdd(node) && BinaryArithmeticNode.isNonExactSub(otherValue)) {
                addSub = true;
            } else if (BinaryArithmeticNode.isNonExactSub(node) && BinaryArithmeticNode.isNonExactAdd(otherValue)) {
                subAdd = true;
            } else {
                return node;
            }
        }
        if ((match2 = BinaryArithmeticNode.findReassociate(other = (BinaryNode)otherValue, criterion)) == null) {
            return node;
        }
        if (BinaryArithmeticNode.isExactMathOperation(other)) {
            return node;
        }
        boolean invertA = false;
        boolean aSub = false;
        boolean invertM1 = false;
        boolean invertM2 = false;
        if (addSub) {
            invertM2 = match2 == ReassociateMatch.y;
            invertA = !invertM2;
        } else if (subAdd) {
            invertM2 = match1 == ReassociateMatch.x;
            invertA = invertM2;
            invertM1 = !invertM2;
        } else if (BinaryArithmeticNode.isNonExactSub(node) && BinaryArithmeticNode.isNonExactSub(other)) {
            invertA = match1 == ReassociateMatch.x ^ match2 == ReassociateMatch.x;
            aSub = match1 == ReassociateMatch.y && match2 == ReassociateMatch.y;
            invertM1 = match1 == ReassociateMatch.y && match2 == ReassociateMatch.x;
            boolean bl = invertM2 = match1 == ReassociateMatch.x && match2 == ReassociateMatch.x;
        }
        assert (!(invertM1 && invertM2 || invertA && aSub));
        ValueNode m1 = match1.getValue(node);
        ValueNode m2 = match2.getValue(other);
        ValueNode a = match2.getOtherValue(other);
        if (BinaryArithmeticNode.isNonExactAddOrSub(node)) {
            ValueNode associated = invertM1 ? BinaryArithmeticNode.sub(m2, m1, view) : (invertM2 ? BinaryArithmeticNode.sub(m1, m2, view) : BinaryArithmeticNode.add(m1, m2, view));
            if (invertA) {
                return BinaryArithmeticNode.sub(associated, a, view);
            }
            if (aSub) {
                return BinaryArithmeticNode.sub(a, associated, view);
            }
            return BinaryArithmeticNode.add(a, associated, view);
        }
        if (BinaryArithmeticNode.isNonExactMul(node)) {
            return BinaryArithmeticNode.mul(a, AddNode.mul(m1, m2, view), view);
        }
        if (node instanceof AndNode) {
            return AndNode.create(a, AndNode.create(m1, m2, view), view);
        }
        if (node instanceof OrNode) {
            return OrNode.create(a, OrNode.create(m1, m2, view), view);
        }
        if (node instanceof XorNode) {
            return XorNode.create(a, XorNode.create(m1, m2, view), view);
        }
        if (node instanceof MaxNode) {
            return MaxNode.create(a, MaxNode.create(m1, m2, view), view);
        }
        if (node instanceof MinNode) {
            return MinNode.create(a, MinNode.create(m1, m2, view), view);
        }
        throw GraalError.shouldNotReachHere("unhandled node in reassociation with matched values: " + node);
    }

    private static boolean isNonExactMul(Node n) {
        if (n instanceof MulNode) {
            return !((MulNode)n).isExact();
        }
        return false;
    }

    private static boolean isNonExactAdd(Node n) {
        if (n instanceof AddNode) {
            return !((AddNode)n).isExact();
        }
        return false;
    }

    private static boolean isNonExactSub(Node n) {
        if (n instanceof SubNode) {
            return !((SubNode)n).isExact();
        }
        return false;
    }

    private static boolean isNonExactAddOrSub(Node n) {
        return BinaryArithmeticNode.isNonExactAdd(n) || BinaryArithmeticNode.isNonExactSub(n);
    }

    private static boolean isExactMathOperation(Node n) {
        if (n instanceof AddNode) {
            return ((AddNode)n).isExact();
        }
        if (n instanceof SubNode) {
            return ((SubNode)n).isExact();
        }
        if (n instanceof MulNode) {
            return ((MulNode)n).isExact();
        }
        return false;
    }

    public BinaryNode maybeCommuteInputs() {
        assert (this instanceof Canonicalizable.BinaryCommutative);
        if (!this.y.isConstant() && (this.x.isConstant() || this.x.getId() > this.y.getId())) {
            BinaryNode duplicate;
            ValueNode tmp = this.x;
            this.x = this.y;
            this.y = tmp;
            if (this.graph() != null && (duplicate = (BinaryNode)this.graph().findDuplicate(this)) != null) {
                return duplicate;
            }
        }
        return this;
    }

    protected boolean shouldSwapInputs(NodeValueMap nodeValueMap) {
        boolean xHasOtherUsages = this.getX().hasUsagesOtherThan(this, nodeValueMap);
        boolean yHasOtherUsages = this.getY().hasUsagesOtherThan(this, nodeValueMap);
        if (!this.getY().isConstant() && !yHasOtherUsages) {
            if (xHasOtherUsages == yHasOtherUsages) {
                return this.getY() instanceof ValuePhiNode && this.getY().inputs().contains(this);
            }
            return true;
        }
        return false;
    }

    private static enum ReassociateMatch {
        x,
        y;


        public ValueNode getValue(BinaryNode binary) {
            switch (this) {
                case x: {
                    return binary.getX();
                }
                case y: {
                    return binary.getY();
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue((Object)this);
        }

        public ValueNode getOtherValue(BinaryNode binary) {
            switch (this) {
                case x: {
                    return binary.getY();
                }
                case y: {
                    return binary.getX();
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue((Object)this);
        }
    }
}

