/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.StampInverter;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class NegateNode
extends UnaryArithmeticNode<ArithmeticOpTable.UnaryOp.Neg>
implements NarrowableArithmeticNode,
StampInverter {
    public static final NodeClass<NegateNode> TYPE = NodeClass.create(NegateNode.class);

    public NegateNode(ValueNode value) {
        this(TYPE, value);
    }

    protected NegateNode(NodeClass<? extends NegateNode> c, ValueNode value) {
        super(c, BinaryArithmeticNode.getArithmeticOpTable(value).getNeg(), value);
    }

    public static ValueNode create(ValueNode value, NodeView view) {
        ValueNode synonym = NegateNode.findSynonym(value, view);
        if (synonym != null) {
            return synonym;
        }
        return new NegateNode(value);
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.UnaryOp.Neg> getOp(ArithmeticOpTable table) {
        return table.getNeg();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode synonym = NegateNode.findSynonym(forValue, this.getOp(forValue));
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    protected static ValueNode findSynonym(ValueNode forValue, NodeView view) {
        ArithmeticOpTable.UnaryOp<ArithmeticOpTable.UnaryOp.Neg> negOp = ArithmeticOpTable.forStamp(forValue.stamp(view)).getNeg();
        ValueNode synonym = UnaryArithmeticNode.findSynonym(forValue, negOp);
        if (synonym != null) {
            return synonym;
        }
        if (forValue instanceof NegateNode) {
            return ((NegateNode)forValue).getValue();
        }
        if (forValue instanceof SubNode && !(forValue.stamp(view) instanceof FloatStamp)) {
            SubNode sub = (SubNode)forValue;
            return SubNode.create(sub.getY(), sub.getX(), view);
        }
        if (forValue instanceof RightShiftNode) {
            int shiftAmount;
            RightShiftNode shift = (RightShiftNode)forValue;
            Stamp stamp = forValue.stamp(view);
            if (shift.getY().isConstant() && stamp instanceof IntegerStamp && (shiftAmount = shift.getY().asJavaConstant().asInt()) == ((IntegerStamp)stamp).getBits() - 1) {
                return UnsignedRightShiftNode.create(shift.getX(), shift.getY(), view);
            }
        }
        return null;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitNegate(nodeValueMap.operand(this.getValue()), false));
    }

    @Override
    public Stamp invertStamp(Stamp outStamp) {
        return ((ArithmeticOpTable.UnaryOp)this.getArithmeticOp()).foldStamp(outStamp);
    }
}

