/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.gc;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo
public abstract class WriteBarrier
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<WriteBarrier> TYPE = NodeClass.create(WriteBarrier.class);
    @Node.Input(value=InputType.Association)
    AddressNode address;

    protected WriteBarrier(NodeClass<? extends WriteBarrier> c, AddressNode address) {
        super((NodeClass<? extends FixedWithNextNode>)c, StampFactory.forVoid());
        this.address = address;
    }

    @Override
    public void lower(LoweringTool tool) {
        assert (this.graph().getGuardsStage().areFrameStatesAtDeopts());
        tool.getLowerer().lower(this, tool);
    }

    public AddressNode getAddress() {
        return this.address;
    }

    public abstract Kind getKind();

    public static enum Kind {
        PRE_BARRIER,
        POST_BARRIER;

    }
}

