/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.gc;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.memory.AddressableMemoryAccess;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

public class ZBarrierSet
implements BarrierSet {
    private final ResolvedJavaField referentField;

    public ZBarrierSet(ResolvedJavaField referentField) {
        this.referentField = referentField;
    }

    @Override
    public BarrierType readBarrierType(LocationIdentity location, ValueNode address, Stamp loadStamp) {
        if (location.equals(NamedLocationIdentity.OFF_HEAP_LOCATION)) {
            assert (!loadStamp.isObjectStamp()) : location;
            return BarrierType.NONE;
        }
        if (loadStamp.isObjectStamp()) {
            AddressNode addr;
            if (address.stamp(NodeView.DEFAULT).isObjectStamp()) {
                return BarrierType.READ;
            }
            if (address instanceof AddressNode && (addr = (AddressNode)address).getBase().stamp(NodeView.DEFAULT).isObjectStamp()) {
                return BarrierType.READ;
            }
            throw GraalError.shouldNotReachHere("Unexpected location type " + loadStamp);
        }
        boolean mustBeObject = false;
        if (location instanceof FieldLocationIdentity) {
            FieldLocationIdentity fieldLocationIdentity = (FieldLocationIdentity)location;
            boolean bl = mustBeObject = fieldLocationIdentity.getField().getJavaKind() == JavaKind.Object;
        }
        assert (!mustBeObject) : address;
        return BarrierType.NONE;
    }

    @Override
    public BarrierType writeBarrierType(RawStoreNode store) {
        return BarrierType.NONE;
    }

    @Override
    public BarrierType fieldReadBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        if (storageKind == JavaKind.Object && field.equals(this.referentField)) {
            return BarrierType.REFERENCE_GET;
        }
        if (storageKind.isObject()) {
            return BarrierType.READ;
        }
        return BarrierType.NONE;
    }

    @Override
    public BarrierType fieldWriteBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        return BarrierType.NONE;
    }

    @Override
    public BarrierType arrayWriteBarrierType(JavaKind storageKind) {
        return BarrierType.NONE;
    }

    @Override
    public BarrierType guessReadWriteBarrier(ValueNode object, ValueNode value) {
        if (value.stamp(NodeView.DEFAULT).isObjectStamp()) {
            return BarrierType.READ;
        }
        return BarrierType.NONE;
    }

    @Override
    public boolean hasWriteBarrier() {
        return false;
    }

    @Override
    public boolean hasReadBarrier() {
        return true;
    }

    @Override
    public void addBarriers(FixedAccessNode n) {
    }

    @Override
    public boolean mayNeedPreWriteBarrier(JavaKind storageKind) {
        return false;
    }

    @Override
    public void verifyBarriers(StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            AddressableMemoryAccess access;
            if (node instanceof WriteNode) {
                WriteNode write = (WriteNode)node;
                GraalError.guarantee(write.getBarrierType() == BarrierType.NONE, "There are no write barriers with ZGC: %s", (Object)node);
                continue;
            }
            if (node instanceof ReadNode || node instanceof FloatingReadNode || node instanceof AbstractCompareAndSwapNode || node instanceof LoweredAtomicReadAndWriteNode) {
                LIRLowerableAccess read = (LIRLowerableAccess)((Object)node);
                Stamp stamp = read.getAccessStamp(NodeView.DEFAULT);
                if (!stamp.isObjectStamp()) {
                    GraalError.guarantee(read.getBarrierType() == BarrierType.NONE, "no barriers for primitive reads: %s", (Object)read);
                    continue;
                }
                BarrierType expectedBarrier = this.barrierForLocation(read.getBarrierType(), read.getLocationIdentity(), JavaKind.Object);
                if (expectedBarrier != null) {
                    GraalError.guarantee(expectedBarrier == read.getBarrierType(), "expected %s but found %s in %s", (Object)expectedBarrier, (Object)read.getBarrierType(), (Object)read);
                    continue;
                }
                ValueNode base = read.getAddress().getBase();
                if (!base.stamp(NodeView.DEFAULT).isObjectStamp()) {
                    GraalError.guarantee(read.getBarrierType() == BarrierType.NONE, "no barrier for non-heap read: %s", (Object)read);
                    continue;
                }
                GraalError.guarantee(read.getBarrierType() == BarrierType.READ, "missing barriers for heap read: %s", (Object)read);
                continue;
            }
            if (!(node instanceof AddressableMemoryAccess) || (access = (AddressableMemoryAccess)((Object)node)).getBarrierType() == BarrierType.NONE) continue;
            throw new GraalError("Unexpected memory access with barrier : " + node);
        }
    }

    protected BarrierType barrierForLocation(BarrierType currentBarrier, LocationIdentity location, JavaKind storageKind) {
        if (location instanceof FieldLocationIdentity) {
            FieldLocationIdentity fieldLocationIdentity = (FieldLocationIdentity)location;
            BarrierType barrierType = this.fieldReadBarrierType(fieldLocationIdentity.getField(), storageKind);
            if (barrierType != currentBarrier && barrierType == BarrierType.REFERENCE_GET && (currentBarrier == BarrierType.WEAK_REFERS_TO || currentBarrier == BarrierType.PHANTOM_REFERS_TO)) {
                return currentBarrier;
            }
            return barrierType;
        }
        if (location.equals(NamedLocationIdentity.getArrayLocation(JavaKind.Object))) {
            return BarrierType.READ;
        }
        return null;
    }
}

