/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_2)
public final class AtomicReadAndAddNode
extends AbstractMemoryCheckpoint
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<AtomicReadAndAddNode> TYPE = NodeClass.create(AtomicReadAndAddNode.class);
    @Node.Input
    ValueNode object;
    @Node.Input
    ValueNode offset;
    @Node.Input
    ValueNode delta;
    private JavaKind valueKind;
    protected final LocationIdentity locationIdentity;

    public AtomicReadAndAddNode(ValueNode object, ValueNode offset, ValueNode delta, JavaKind valueKind, LocationIdentity locationIdentity) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forKind(valueKind));
        this.object = object;
        this.offset = offset;
        this.delta = delta;
        this.valueKind = valueKind;
        this.locationIdentity = locationIdentity;
    }

    public ValueNode object() {
        return this.object;
    }

    public ValueNode offset() {
        return this.offset;
    }

    public ValueNode delta() {
        return this.delta;
    }

    public JavaKind getValueKind() {
        return this.valueKind;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.locationIdentity;
    }
}

