/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.util.UnsignedLong;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.MathUtil;
import org.graalvm.compiler.nodes.util.IntegerHelper;
import org.graalvm.compiler.nodes.util.SignedIntegerHelper;
import org.graalvm.compiler.nodes.util.UnsignedIntegerHelper;

public class CountedLoopInfo {
    protected final LoopEx loop;
    protected InductionVariable limitCheckedIV;
    protected ValueNode end;
    protected boolean isLimitIncluded;
    protected AbstractBeginNode body;
    protected IfNode ifNode;
    protected final boolean unsigned;

    protected CountedLoopInfo(LoopEx loop, InductionVariable limitCheckedIV, IfNode ifNode, ValueNode end, boolean isLimitIncluded, AbstractBeginNode body, boolean unsigned) {
        assert (limitCheckedIV.direction() != null);
        this.loop = loop;
        this.limitCheckedIV = limitCheckedIV;
        this.end = end;
        this.isLimitIncluded = isLimitIncluded;
        this.body = body;
        this.ifNode = ifNode;
        this.unsigned = unsigned;
    }

    public InductionVariable getLimitCheckedIV() {
        return this.limitCheckedIV;
    }

    public InductionVariable getBodyIV() {
        assert (!this.isInverted() && this.getLimitCheckedIV() == this.limitCheckedIV) : "Only inverted loops must have different body ivs.";
        return this.limitCheckedIV;
    }

    public ValueNode getLimit() {
        return this.end;
    }

    public ValueNode getTripCountLimit() {
        assert (!this.isInverted() && this.getLimit() == this.end) : "Only inverted loops must have a different trip count limit";
        return this.end;
    }

    private void assertNoOverflow() {
        GraalError.guarantee(this.loopCanNeverOverflow(), "Counter must never overflow when reasoning about trip counts of a loop");
    }

    public ValueNode maxTripCountNode() {
        this.assertNoOverflow();
        return this.maxTripCountNode(false);
    }

    public boolean isUnsignedCheck() {
        return this.unsigned;
    }

    public ValueNode maxTripCountNode(boolean assumeLoopEntered) {
        this.assertNoOverflow();
        return this.maxTripCountNode(assumeLoopEntered, this.getCounterIntegerHelper());
    }

    protected ValueNode maxTripCountNode(boolean assumeLoopEntered, IntegerHelper integerHelper) {
        this.assertNoOverflow();
        return this.maxTripCountNode(assumeLoopEntered, integerHelper, this.getBodyIV().initNode(), this.getTripCountLimit());
    }

    public ValueNode maxTripCountNode(boolean assumeLoopEntered, IntegerHelper integerHelper, ValueNode initNode, ValueNode tripCountLimit) {
        ValueNode min;
        ValueNode max;
        ValueNode absStride;
        this.assertNoOverflow();
        StructuredGraph graph = this.getBodyIV().valueNode().graph();
        Stamp stamp = this.getBodyIV().valueNode().stamp(NodeView.DEFAULT);
        InductionVariable.Direction direction = this.getBodyIV().direction();
        if (direction == InductionVariable.Direction.Up) {
            absStride = this.getBodyIV().strideNode();
            max = tripCountLimit;
            min = initNode;
        } else {
            assert (direction == InductionVariable.Direction.Down) : "direction must be down if its not up - else loop should not be counted " + direction;
            absStride = NegateNode.create(this.getBodyIV().strideNode(), NodeView.DEFAULT);
            max = initNode;
            min = tripCountLimit;
        }
        ValueNode range = BinaryArithmeticNode.sub(max, min);
        ConstantNode one = ConstantNode.forIntegerStamp(stamp, 1L, graph);
        if (this.isLimitIncluded) {
            range = BinaryArithmeticNode.add(range, one);
        }
        ValueNode denominator = BinaryArithmeticNode.add(graph, range, BinaryArithmeticNode.sub(absStride, one), NodeView.DEFAULT);
        boolean divisorNonZero = true;
        ValueNode div = MathUtil.unsignedDivBefore(graph, true, this.loop.entryPoint(), denominator, absStride, null);
        if (assumeLoopEntered) {
            return graph.addOrUniqueWithInputs(div);
        }
        ConstantNode zero = ConstantNode.forIntegerStamp(stamp, 0L, graph);
        LogicNode noEntryCheck = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(max, min, NodeView.DEFAULT));
        ValueNode pi = this.findOrCreatePositivePi(noEntryCheck, div, graph, this.loop.loopsData().getCFG());
        if (pi != null) {
            return pi;
        }
        return graph.addOrUniqueWithInputs(ConditionalNode.create(noEntryCheck, zero, div, NodeView.DEFAULT));
    }

    private ValueNode findOrCreatePositivePi(LogicNode noEntryCheck, ValueNode div, StructuredGraph graph, ControlFlowGraph cfg) {
        Stamp positiveIntStamp = StampFactory.positiveInt();
        if (!positiveIntStamp.isCompatible(div.stamp(NodeView.DEFAULT))) {
            return null;
        }
        if (cfg.getNodeToBlock().isNew(this.loop.loopBegin())) {
            return null;
        }
        HIRBlock loopBlock = cfg.blockFor(this.loop.loopBegin());
        for (Node checkUsage : noEntryCheck.usages()) {
            if (!(checkUsage instanceof IfNode)) continue;
            IfNode ifCheck = (IfNode)checkUsage;
            if (cfg.getNodeToBlock().isNew(ifCheck.falseSuccessor()) || !cfg.blockFor(ifCheck.falseSuccessor()).dominates(loopBlock)) continue;
            return graph.addOrUniqueWithInputs(PiNode.create(div, positiveIntStamp.improveWith(div.stamp(NodeView.DEFAULT)), ifCheck.falseSuccessor()));
        }
        return null;
    }

    public boolean loopMightBeEntered() {
        LogicNode entryCheck;
        ValueNode min;
        ValueNode max;
        Stamp stamp = this.getBodyIV().valueNode().stamp(NodeView.DEFAULT);
        if (this.getBodyIV().direction() == InductionVariable.Direction.Up) {
            max = this.getTripCountLimit();
            min = this.getBodyIV().initNode();
        } else {
            assert (this.getBodyIV().direction() == InductionVariable.Direction.Down);
            max = this.getBodyIV().initNode();
            min = this.getTripCountLimit();
        }
        if (this.isLimitIncluded) {
            StructuredGraph graph = this.getBodyIV().valueNode().graph();
            max = BinaryArithmeticNode.add(max, ConstantNode.forIntegerStamp(stamp, 1L, graph), NodeView.DEFAULT);
        }
        return !(entryCheck = this.getCounterIntegerHelper().createCompareNode(min, max, NodeView.DEFAULT)).isContradiction();
    }

    public boolean isConstantMaxTripCount() {
        return this.getTripCountLimit() instanceof ConstantNode && this.getBodyIV().isConstantInit() && this.getBodyIV().isConstantStride();
    }

    public UnsignedLong constantMaxTripCount() {
        assert (this.isConstantMaxTripCount());
        return new UnsignedLong(this.rawConstantMaxTripCount());
    }

    private long rawConstantMaxTripCount() {
        long absStride;
        long range;
        assert (this.getBodyIV().direction() != null);
        long endValue = this.getTripCountLimit().asJavaConstant().asLong();
        long initValue = this.getBodyIV().constantInit();
        IntegerHelper helper = this.getCounterIntegerHelper(64);
        if (this.getBodyIV().direction() == InductionVariable.Direction.Up) {
            if (helper.compare(endValue, initValue) < 0) {
                return 0L;
            }
            range = endValue - this.getBodyIV().constantInit();
            absStride = this.getBodyIV().constantStride();
        } else {
            assert (this.getBodyIV().direction() == InductionVariable.Direction.Down);
            if (helper.compare(initValue, endValue) < 0) {
                return 0L;
            }
            range = this.getBodyIV().constantInit() - endValue;
            absStride = -this.getBodyIV().constantStride();
        }
        if (this.isLimitIncluded) {
            ++range;
        }
        long denominator = range + absStride - 1L;
        return Long.divideUnsigned(denominator, absStride);
    }

    public IntegerHelper getCounterIntegerHelper() {
        IntegerStamp stamp = (IntegerStamp)this.getBodyIV().valueNode().stamp(NodeView.DEFAULT);
        return this.getCounterIntegerHelper(stamp.getBits());
    }

    public IntegerHelper getCounterIntegerHelper(int bits) {
        IntegerHelper helper = this.isUnsignedCheck() ? new UnsignedIntegerHelper(bits) : new SignedIntegerHelper(bits);
        return helper;
    }

    public boolean isExactTripCount() {
        return this.loop.loop().getNaturalExits().size() == 1;
    }

    public ValueNode exactTripCountNode() {
        this.assertNoOverflow();
        assert (this.isExactTripCount());
        return this.maxTripCountNode();
    }

    public boolean isConstantExactTripCount() {
        assert (this.isExactTripCount());
        return this.isConstantMaxTripCount();
    }

    public UnsignedLong constantExactTripCount() {
        this.assertNoOverflow();
        assert (this.isExactTripCount());
        return this.constantMaxTripCount();
    }

    public String toString() {
        return (this.isInverted() ? "Inverted " : "") + "iv=" + this.getLimitCheckedIV() + " until " + this.getTripCountLimit() + (this.isLimitIncluded ? (this.getBodyIV().direction() == InductionVariable.Direction.Up ? "+1" : "-1") : "") + " bodyIV=" + this.getBodyIV();
    }

    public IfNode getLimitTest() {
        return this.ifNode;
    }

    public ValueNode getBodyIVStart() {
        return this.getBodyIV().initNode();
    }

    public boolean isLimitIncluded() {
        return this.isLimitIncluded;
    }

    public AbstractBeginNode getBody() {
        return this.body;
    }

    public AbstractBeginNode getCountedExit() {
        if (this.getLimitTest().trueSuccessor() == this.getBody()) {
            return this.getLimitTest().falseSuccessor();
        }
        assert (this.getLimitTest().falseSuccessor() == this.getBody());
        return this.getLimitTest().trueSuccessor();
    }

    public InductionVariable.Direction getDirection() {
        return this.getLimitCheckedIV().direction();
    }

    public GuardingNode getOverFlowGuard() {
        return this.loop.loopBegin().getOverflowGuard();
    }

    public boolean loopCanNeverOverflow() {
        return this.counterNeverOverflows() || this.getOverFlowGuard() != null;
    }

    public boolean counterNeverOverflows() {
        if (this.loop.loopBegin().canNeverOverflow()) {
            return true;
        }
        if (!this.isLimitIncluded && this.getBodyIV().isConstantStride() && Math.abs(this.getBodyIV().constantStride()) == 1L) {
            return true;
        }
        if (this.loop.loopBegin().isProtectedNonOverflowingUnsigned()) {
            return true;
        }
        IntegerStamp endStamp = (IntegerStamp)this.getTripCountLimit().stamp(NodeView.DEFAULT);
        ValueNode strideNode = this.getBodyIV().strideNode();
        IntegerStamp strideStamp = (IntegerStamp)strideNode.stamp(NodeView.DEFAULT);
        IntegerHelper integerHelper = this.getCounterIntegerHelper();
        if (this.getDirection() == InductionVariable.Direction.Up) {
            long max = integerHelper.maxValue();
            return integerHelper.compare(endStamp.upperBound(), max - (strideStamp.upperBound() - 1L) - (long)(this.isLimitIncluded ? 1 : 0)) <= 0;
        }
        if (this.getDirection() == InductionVariable.Direction.Down) {
            long min = integerHelper.minValue();
            return integerHelper.compare(min + (1L - strideStamp.lowerBound()) + (long)(this.isLimitIncluded ? 1 : 0), endStamp.lowerBound()) <= 0;
        }
        return false;
    }

    public GuardingNode createOverFlowGuard() {
        GuardingNode overflowGuard = this.getOverFlowGuard();
        if (overflowGuard != null || this.counterNeverOverflows()) {
            return overflowGuard;
        }
        try (DebugCloseable position = this.loop.loopBegin().withNodeSourcePosition();){
            StructuredGraph graph = this.getBodyIV().valueNode().graph();
            LogicNode cond = this.createOverflowGuardCondition();
            SpeculationLog speculationLog = graph.getSpeculationLog();
            SpeculationLog.Speculation speculation = SpeculationLog.NO_SPECULATION;
            if (speculationLog != null) {
                SpeculationLog.SpeculationReason speculationReason = LoopBeginNode.LOOP_OVERFLOW_DEOPT.createSpeculationReason(graph.method(), this.getBodyIV().loop.loopBegin().stateAfter().bci);
                if (speculationLog.maySpeculate(speculationReason)) {
                    speculation = speculationLog.speculate(speculationReason);
                    LoopBeginNode.overflowSpeculationTaken.increment(graph.getDebug());
                } else {
                    GraalError.shouldNotReachHere("Must not create overflow guard for loop " + this.loop.loopBegin() + " where the speculation guard already failed, this can create deopt loops");
                }
            }
            assert (graph.getGuardsStage().allowsFloatingGuards());
            overflowGuard = graph.unique(new GuardNode(cond, AbstractBeginNode.prevBegin(this.loop.entryPoint()), DeoptimizationReason.LoopLimitCheck, DeoptimizationAction.InvalidateRecompile, true, speculation, null));
            this.loop.loopBegin().setOverflowGuard(overflowGuard);
            GuardingNode guardingNode = overflowGuard;
            return guardingNode;
        }
    }

    public LogicNode createOverflowGuardCondition() {
        LogicNode cond;
        StructuredGraph graph = this.getBodyIV().valueNode().graph();
        if (this.counterNeverOverflows()) {
            return LogicConstantNode.contradiction(graph);
        }
        IntegerStamp stamp = (IntegerStamp)this.getBodyIV().valueNode().stamp(NodeView.DEFAULT);
        IntegerHelper integerHelper = this.getCounterIntegerHelper();
        ConstantNode one = ConstantNode.forIntegerStamp(stamp, 1L, graph);
        if (this.getBodyIV().direction() == InductionVariable.Direction.Up) {
            ValueNode v1 = BinaryArithmeticNode.sub(ConstantNode.forIntegerStamp(stamp, integerHelper.maxValue()), BinaryArithmeticNode.sub(this.getBodyIV().strideNode(), one));
            if (this.isLimitIncluded) {
                v1 = BinaryArithmeticNode.sub(v1, one);
            }
            cond = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(v1, this.getTripCountLimit(), NodeView.DEFAULT));
        } else {
            assert (this.getBodyIV().direction() == InductionVariable.Direction.Down);
            ValueNode v1 = BinaryArithmeticNode.add(ConstantNode.forIntegerStamp(stamp, integerHelper.minValue()), BinaryArithmeticNode.sub(one, this.getBodyIV().strideNode()));
            if (this.isLimitIncluded) {
                v1 = BinaryArithmeticNode.add(v1, one);
            }
            cond = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(this.getTripCountLimit(), v1, NodeView.DEFAULT));
        }
        return cond;
    }

    public IntegerStamp getStamp() {
        return (IntegerStamp)this.getBodyIV().valueNode().stamp(NodeView.DEFAULT);
    }

    public boolean isInverted() {
        return false;
    }
}

