/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.Optional;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class LoopSafepointInsertionPhase
extends BasePhase<MidTierContext> {
    @Override
    public boolean checkContract() {
        return false;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.SAFEPOINTS_INSERTION, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        if (GraalOptions.GenLoopSafepoints.getValue(graph.getOptions()).booleanValue()) {
            for (LoopBeginNode loopBeginNode : graph.getNodes(LoopBeginNode.TYPE)) {
                for (LoopEndNode loopEndNode : loopBeginNode.loopEnds().snapshot()) {
                    if (!loopEndNode.canSafepoint()) continue;
                    DebugCloseable s = loopEndNode.withNodeSourcePosition();
                    try {
                        SafepointNode safepointNode = graph.add(new SafepointNode(loopBeginNode));
                        graph.addBeforeFixed(loopEndNode, safepointNode);
                    }
                    finally {
                        if (s == null) continue;
                        s.close();
                    }
                }
            }
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.SAFEPOINTS_INSERTION);
    }
}

