/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpHandler;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.graphio.GraphElements;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.graphio.GraphStructure;
import org.graalvm.graphio.GraphTypes;

public class BciBlockMappingDumpHandler
implements DebugDumpHandler {
    private static final BlockMappingElements ELEMENTS = new BlockMappingElements();
    private static final BlockMappingTypes TYPES = new BlockMappingTypes();
    private BlockMappingStructure structure;
    private int nextId;
    private static final BlockEdges NO_EDGES = new BlockEdges(null);

    @Override
    public void dump(Object object, DebugContext debug, boolean forced, String format, Object ... arguments) {
        OptionValues options = debug.getOptions();
        if (object instanceof BciBlockMapping && DebugOptions.PrintGraph.getValue(options) != DebugOptions.PrintGraphTarget.Disable) {
            try {
                if (this.structure == null) {
                    this.structure = new BlockMappingStructure();
                }
                int id = this.nextId++;
                GraphOutput.Builder<BciBlockMapping, BciBlockMapping.BciBlock, ResolvedJavaMethod> builder = GraphOutput.newBuilder(this.structure).elements(ELEMENTS).types(TYPES);
                GraphOutput<BciBlockMapping, ResolvedJavaMethod> output = debug.buildOutput(builder);
                HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
                properties.put("hasJsrBytecodes", ((BciBlockMapping)object).hasJsrBytecodes);
                output.print((BciBlockMapping)object, properties, id, format, arguments);
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to dump block mapping", e);
            }
        }
    }

    static class BlockMappingStructure
    implements GraphStructure<BciBlockMapping, BciBlockMapping.BciBlock, BciBlockClass, BlockEdges> {
        private Map<BciBlockMapping.BciBlock, Integer> artificialIds;
        private int nextArtifcialId = 1000000;

        BlockMappingStructure() {
        }

        @Override
        public BciBlockMapping graph(BciBlockMapping currentGraph, Object obj) {
            return obj instanceof BciBlockMapping ? (BciBlockMapping)obj : null;
        }

        @Override
        public Collection<BciBlockMapping.BciBlock> nodes(BciBlockMapping graph) {
            return BlockMappingStructure.collectBlocks(graph);
        }

        private static Collection<BciBlockMapping.BciBlock> collectBlocks(BciBlockMapping graph) {
            if (graph.getStartBlock() == null) {
                return Collections.emptySet();
            }
            HashSet<BciBlockMapping.BciBlock> blocks = new HashSet<BciBlockMapping.BciBlock>();
            ArrayDeque<BciBlockMapping.BciBlock> workStack = new ArrayDeque<BciBlockMapping.BciBlock>();
            workStack.push(graph.getStartBlock());
            while (!workStack.isEmpty()) {
                BciBlockMapping.BciBlock retSuccessor;
                BciBlockMapping.BciBlock block = (BciBlockMapping.BciBlock)workStack.pop();
                if (blocks.contains(block)) continue;
                blocks.add(block);
                for (BciBlockMapping.BciBlock successor : block.getSuccessors()) {
                    workStack.push(successor);
                }
                BciBlockMapping.BciBlock jsrSuccessor = block.getJsrSuccessor();
                if (jsrSuccessor != null) {
                    workStack.push(jsrSuccessor);
                }
                if ((retSuccessor = block.getRetSuccessor()) == null) continue;
                workStack.push(retSuccessor);
            }
            return blocks;
        }

        @Override
        public int nodesCount(BciBlockMapping graph) {
            return this.nodes(graph).size();
        }

        @Override
        public int nodeId(BciBlockMapping.BciBlock node) {
            Integer artificial;
            if (this.artificialIds != null && (artificial = this.artificialIds.get(node)) != null) {
                return artificial;
            }
            int id = node.getId();
            if (id < 0) {
                if (this.artificialIds == null) {
                    this.artificialIds = new HashMap<BciBlockMapping.BciBlock, Integer>();
                }
                id = this.artificialIds.computeIfAbsent(node, b -> this.nextArtifcialId++);
            }
            return id;
        }

        @Override
        public boolean nodeHasPredecessor(BciBlockMapping.BciBlock node) {
            return node.getPredecessorCount() > 0;
        }

        @Override
        public void nodeProperties(BciBlockMapping graph, BciBlockMapping.BciBlock node, Map<String, ? super Object> properties) {
            node.getDebugProperties(properties);
        }

        @Override
        public BciBlockMapping.BciBlock node(Object obj) {
            return obj instanceof BciBlockMapping.BciBlock ? (BciBlockMapping.BciBlock)obj : null;
        }

        @Override
        public BciBlockClass nodeClass(Object obj) {
            return obj instanceof BciBlockClass ? (BciBlockClass)obj : null;
        }

        @Override
        public BciBlockClass classForNode(BciBlockMapping.BciBlock node) {
            return new BciBlockClass(node);
        }

        @Override
        public String nameTemplate(BciBlockClass nodeClass) {
            return "[{p#startBci}..{p#endBci}] ({p#assignedId})";
        }

        @Override
        public Object nodeClassType(BciBlockClass nodeClass) {
            return nodeClass.block.getClass();
        }

        @Override
        public BlockEdges portInputs(BciBlockClass nodeClass) {
            return NO_EDGES;
        }

        @Override
        public BlockEdges portOutputs(BciBlockClass nodeClass) {
            return new BlockEdges(nodeClass.block);
        }

        @Override
        public int portSize(BlockEdges port) {
            if (port.block == null) {
                return 0;
            }
            return 1 + (port.block.getJsrSuccessor() != null ? 1 : 0) + (port.block.getRetSuccessor() != null ? 1 : 0);
        }

        @Override
        public boolean edgeDirect(BlockEdges port, int index) {
            return index > 0;
        }

        @Override
        public String edgeName(BlockEdges port, int index) {
            if (index == 0) {
                return "successors";
            }
            if (index == 1 && port.block.getJsrSuccessor() != null) {
                return "jsr successor";
            }
            GraalError.guarantee(index <= 2, Integer.toString(index));
            return "ret successor";
        }

        @Override
        public Object edgeType(BlockEdges port, int index) {
            if (index == 0) {
                return EdgeType.Successor;
            }
            if (index == 1 && port.block.getJsrSuccessor() != null) {
                return EdgeType.JsrSuccessor;
            }
            GraalError.guarantee(index <= 2, Integer.toString(index));
            return EdgeType.RetSuccessor;
        }

        @Override
        public Collection<? extends BciBlockMapping.BciBlock> edgeNodes(BciBlockMapping graph, BciBlockMapping.BciBlock node, BlockEdges port, int index) {
            if (index == 0) {
                return node.getSuccessors();
            }
            if (index == 1 && port.block.getJsrSuccessor() != null) {
                return Collections.singletonList(node.getJsrSuccessor());
            }
            GraalError.guarantee(index <= 2, Integer.toString(index));
            return Collections.singletonList(node.getRetSuccessor());
        }
    }

    static class BlockMappingElements
    implements GraphElements<ResolvedJavaMethod, Object, Signature, Object> {
        BlockMappingElements() {
        }

        @Override
        public ResolvedJavaMethod method(Object object) {
            if (object instanceof Bytecode) {
                return ((Bytecode)object).getMethod();
            }
            if (object instanceof ResolvedJavaMethod) {
                return (ResolvedJavaMethod)object;
            }
            return null;
        }

        @Override
        public byte[] methodCode(ResolvedJavaMethod method) {
            return method.getCode();
        }

        @Override
        public int methodModifiers(ResolvedJavaMethod method) {
            return method.getModifiers();
        }

        @Override
        public Signature methodSignature(ResolvedJavaMethod method) {
            return method.getSignature();
        }

        @Override
        public String methodName(ResolvedJavaMethod method) {
            return method.getName();
        }

        @Override
        public Object methodDeclaringClass(ResolvedJavaMethod method) {
            return method.getDeclaringClass();
        }

        @Override
        public Object field(Object object) {
            return null;
        }

        @Override
        public Signature signature(Object object) {
            if (object instanceof Signature) {
                return (Signature)object;
            }
            return null;
        }

        @Override
        public Object nodeSourcePosition(Object object) {
            return null;
        }

        @Override
        public StackTraceElement methodStackTraceElement(ResolvedJavaMethod method, int bci, Object pos) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public int nodeSourcePositionBCI(Object pos) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public Object nodeSourcePositionCaller(Object pos) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public ResolvedJavaMethod nodeSourcePositionMethod(Object pos) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public int signatureParameterCount(Signature signature) {
            return signature.getParameterCount(false);
        }

        @Override
        public String signatureParameterTypeName(Signature signature, int index) {
            return signature.getParameterType(index, null).getName();
        }

        @Override
        public String signatureReturnTypeName(Signature signature) {
            return signature.getReturnType(null).getName();
        }

        @Override
        public Object fieldDeclaringClass(Object field) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public String fieldName(Object field) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public String fieldTypeName(Object field) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public int fieldModifiers(Object field) {
            throw GraalError.unimplementedOverride();
        }
    }

    static class BlockMappingTypes
    implements GraphTypes {
        BlockMappingTypes() {
        }

        @Override
        public Class<?> enumClass(Object enumValue) {
            if (enumValue instanceof Enum) {
                return enumValue.getClass();
            }
            return null;
        }

        @Override
        public int enumOrdinal(Object obj) {
            if (obj instanceof Enum) {
                return ((Enum)obj).ordinal();
            }
            return -1;
        }

        @Override
        public String[] enumTypeValues(Object clazz) {
            Class enumClass;
            Enum[] constants;
            if (clazz instanceof Class && (constants = (Enum[])(enumClass = (Class)clazz).getEnumConstants()) != null) {
                String[] names = new String[constants.length];
                for (int i = 0; i < constants.length; ++i) {
                    names[i] = constants[i].name();
                }
                return names;
            }
            return null;
        }

        @Override
        public String typeName(Object clazz) {
            if (clazz instanceof Class) {
                return ((Class)clazz).getName();
            }
            if (clazz instanceof JavaType) {
                return ((JavaType)clazz).toJavaName();
            }
            return null;
        }
    }

    static class BlockEdges {
        final BciBlockMapping.BciBlock block;

        BlockEdges(BciBlockMapping.BciBlock block) {
            this.block = block;
        }
    }

    static enum EdgeType {
        Successor,
        JsrSuccessor,
        RetSuccessor;

    }

    static class BciBlockClass {
        final BciBlockMapping.BciBlock block;

        BciBlockClass(BciBlockMapping.BciBlock block) {
            this.block = block;
        }
    }
}

