/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.nodes.FallbackInvokeWithExceptionNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.MacroWithExceptionNode;

@NodeInfo(nameTemplate="SnippetSubstitution#{p#snippet/s}", cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public class SnippetSubstitutionNode
extends MacroWithExceptionNode
implements Lowerable {
    public static final NodeClass<SnippetSubstitutionNode> TYPE = NodeClass.create(SnippetSubstitutionNode.class);
    protected Object[] constantArguments;
    protected final SnippetTemplate.SnippetInfo snippet;
    protected final SnippetTemplate.AbstractTemplates templates;

    public <T extends SnippetTemplate.AbstractTemplates> SnippetSubstitutionNode(T templates, SnippetTemplate.SnippetInfo snippet, MacroNode.MacroParams params) {
        super(TYPE, params);
        this.snippet = snippet;
        this.templates = templates;
    }

    public void setConstantArguments(Object[] arguments) {
        this.constantArguments = arguments;
    }

    @Override
    public void lower(LoweringTool tool) {
        int arg;
        SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.snippet, this.graph().getGuardsStage(), tool.getLoweringStage());
        for (arg = 0; arg < this.arguments.size(); ++arg) {
            args.add(this.snippet.getParameterName(arg), this.arguments.get(arg));
        }
        if (this.constantArguments != null) {
            for (Object argument : this.constantArguments) {
                args.addConst(this.snippet.getParameterName(arg), argument);
                ++arg;
            }
        }
        SnippetTemplate template = this.templates.template(tool, this, args);
        UnmodifiableEconomicMap<Node, Node> duplicates = template.instantiate(tool.getMetaAccess(), this, SnippetTemplate.DEFAULT_REPLACER, args, true);
        for (Node original : duplicates.getKeys()) {
            Node replacement;
            if (!(original instanceof FallbackInvokeWithExceptionNode) || !((replacement = (Node)duplicates.get((Object)original)) instanceof Lowerable)) continue;
            tool.getLowerer().lower(replacement, tool);
        }
    }
}

