/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.SpinWaitNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AbsNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerMulHighNode;
import org.graalvm.compiler.nodes.calc.IntegerNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.RoundNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SignumNode;
import org.graalvm.compiler.nodes.calc.SqrtNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedDivNode;
import org.graalvm.compiler.nodes.calc.UnsignedRemNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.debug.BindToRegisterNode;
import org.graalvm.compiler.nodes.debug.BlackholeNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchorNode;
import org.graalvm.compiler.nodes.debug.NeverStripMineNode;
import org.graalvm.compiler.nodes.debug.NeverWriteSinkNode;
import org.graalvm.compiler.nodes.debug.SideEffectNode;
import org.graalvm.compiler.nodes.debug.SpillRegistersNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.CacheWritebackNode;
import org.graalvm.compiler.nodes.extended.CacheWritebackSyncNode;
import org.graalvm.compiler.nodes.extended.ClassIsArrayNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.extended.ObjectIsArrayNode;
import org.graalvm.compiler.nodes.extended.OpaqueValueNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.extended.SwitchCaseProbabilityNode;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.extended.UnsafeMemoryLoadNode;
import org.graalvm.compiler.nodes.extended.UnsafeMemoryStoreNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndAddNode;
import org.graalvm.compiler.nodes.java.AtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.java.ClassIsAssignableFromNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.ReachabilityFenceNode;
import org.graalvm.compiler.nodes.java.RegisterFinalizerNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.address.IndexAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.ConstantFoldUtil;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.EnsureVirtualizedNode;
import org.graalvm.compiler.replacements.BigIntegerSnippets;
import org.graalvm.compiler.replacements.BoxingSnippets;
import org.graalvm.compiler.replacements.InvocationPluginHelper;
import org.graalvm.compiler.replacements.SnippetSubstitutionInvocationPlugin;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.StringHelperIntrinsics;
import org.graalvm.compiler.replacements.nodes.AESNode;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.BigIntegerMulAddNode;
import org.graalvm.compiler.replacements.nodes.BigIntegerSquareToLenNode;
import org.graalvm.compiler.replacements.nodes.CipherBlockChainingAESNode;
import org.graalvm.compiler.replacements.nodes.CountPositivesNode;
import org.graalvm.compiler.replacements.nodes.CounterModeAESNode;
import org.graalvm.compiler.replacements.nodes.EncodeArrayNode;
import org.graalvm.compiler.replacements.nodes.GHASHProcessBlocksNode;
import org.graalvm.compiler.replacements.nodes.LogNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.MessageDigestNode;
import org.graalvm.compiler.replacements.nodes.ProfileBooleanNode;
import org.graalvm.compiler.replacements.nodes.ReverseBytesNode;
import org.graalvm.compiler.replacements.nodes.VirtualizableInvokeMacroNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerAddExactSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerMulExactSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerNegExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerNegExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerNegExactSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerSubExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerSubExactOverflowNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerSubExactSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.UnsignedMulHighNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;
import org.graalvm.word.LocationIdentity;

public class StandardGraphBuilderPlugins {
    public static final Field STRING_VALUE_FIELD;
    private static final Field STRING_CODER_FIELD;
    private static final SpeculationReasonGroup DIRECTIVE_SPECULATIONS;

    public static void registerInvocationPlugins(SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, Replacements replacements, boolean useExactMathPlugins, boolean explicitUnsafeNullChecks, boolean supportsStubBasedPlugins, LoweringProvider lowerer) {
        StandardGraphBuilderPlugins.registerObjectPlugins(plugins);
        StandardGraphBuilderPlugins.registerClassPlugins(plugins);
        StandardGraphBuilderPlugins.registerMathPlugins(plugins, useExactMathPlugins, replacements, lowerer);
        StandardGraphBuilderPlugins.registerStrictMathPlugins(plugins);
        StandardGraphBuilderPlugins.registerUnsignedMathPlugins(plugins);
        StandardGraphBuilderPlugins.registerStringPlugins(plugins, replacements, snippetReflection, supportsStubBasedPlugins);
        StandardGraphBuilderPlugins.registerCharacterPlugins(plugins);
        StandardGraphBuilderPlugins.registerCharacterDataLatin1Plugins(plugins);
        StandardGraphBuilderPlugins.registerShortPlugins(plugins);
        StandardGraphBuilderPlugins.registerIntegerLongPlugins(plugins, JavaKind.Int);
        StandardGraphBuilderPlugins.registerIntegerLongPlugins(plugins, JavaKind.Long);
        StandardGraphBuilderPlugins.registerFloatPlugins(plugins);
        StandardGraphBuilderPlugins.registerDoublePlugins(plugins);
        StandardGraphBuilderPlugins.registerArrayPlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerUnsafePlugins(plugins, replacements, explicitUnsafeNullChecks);
        StandardGraphBuilderPlugins.registerEdgesPlugins(plugins);
        StandardGraphBuilderPlugins.registerGraalDirectivesPlugins(plugins, snippetReflection);
        StandardGraphBuilderPlugins.registerBoxingPlugins(plugins);
        StandardGraphBuilderPlugins.registerJMHBlackholePlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerJFRThrowablePlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerMethodHandleImplPlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerPreconditionsPlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerJcovCollectPlugins(plugins, replacements);
        StandardGraphBuilderPlugins.registerThreadPlugins(plugins, replacements);
        if (supportsStubBasedPlugins) {
            StandardGraphBuilderPlugins.registerArraysPlugins(plugins, replacements);
            StandardGraphBuilderPlugins.registerAESPlugins(plugins, replacements, lowerer.getTarget().arch);
            StandardGraphBuilderPlugins.registerGHASHPlugin(plugins, replacements, lowerer.getTarget().arch);
            StandardGraphBuilderPlugins.registerBigIntegerPlugins(plugins, replacements);
            StandardGraphBuilderPlugins.registerMessageDigestPlugins(plugins, replacements, lowerer.getTarget().arch);
            StandardGraphBuilderPlugins.registerStringCodingPlugins(plugins, replacements);
        }
    }

    public static void registerConstantFieldLoadPlugin(GraphBuilderConfiguration.Plugins plugins) {
        plugins.appendNodePlugin(new NodePlugin(){

            @Override
            public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
                JavaConstant asJavaConstant;
                return object.isConstant() && this.tryReadField(b, field, asJavaConstant = object.asJavaConstant());
            }

            @Override
            public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
                return this.tryReadField(b, field, null);
            }

            public boolean tryReadField(GraphBuilderContext b, ResolvedJavaField field, JavaConstant object) {
                return this.tryConstantFold(b, field, object);
            }

            private boolean tryConstantFold(GraphBuilderContext b, ResolvedJavaField field, JavaConstant object) {
                ConstantNode result = ConstantFoldUtil.tryConstantFold(b.getConstantFieldProvider(), b.getConstantReflection(), b.getMetaAccess(), field, object, b.getOptions(), b.getGraph().currentNodeSourcePosition());
                if (result != null) {
                    result = b.getGraph().unique(result);
                    b.push(field.getJavaKind(), result);
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements, final SnippetReflectionProvider snippetReflection, boolean supportsStubBasedPlugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)String.class), replacements);
        r.register(new InvocationPlugin("hashCode", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                String s;
                if (receiver.isConstant() && (s = snippetReflection.asObject(String.class, (JavaConstant)receiver.get().asConstant())) != null) {
                    b.addPush(JavaKind.Int, b.add(ConstantNode.forInt(s.hashCode())));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin("intern", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                String s;
                if (receiver.isConstant() && (s = snippetReflection.asObject(String.class, (JavaConstant)receiver.get().asConstant())) != null) {
                    JavaConstant interned = snippetReflection.forObject(s.intern());
                    b.addPush(JavaKind.Object, b.add(ConstantNode.forConstant(interned, b.getMetaAccess(), b.getGraph())));
                    return true;
                }
                return false;
            }
        });
        if (supportsStubBasedPlugins) {
            r.register(new StringEqualsInvocationPlugin());
        }
        InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
        utf16r.setAllowOverwrite(true);
        utf16r.register(new InvocationPlugin("getChar", new Type[]{byte[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.addPush(JavaKind.Char, new JavaReadNode(JavaKind.Char, new IndexAddressNode(arg1, new LeftShiftNode(arg2, ConstantNode.forInt(1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                return true;
            }
        });
        utf16r.register(new InvocationPlugin("putChar", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3) {
                b.add(new JavaWriteNode(JavaKind.Char, new IndexAddressNode(arg1, new LeftShiftNode(arg2, ConstantNode.forInt(1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), arg3, BarrierType.NONE, false));
                return true;
            }
        });
        InvocationPlugins.Registration sr = new InvocationPlugins.Registration(plugins, (Type)((Object)StringHelperIntrinsics.class));
        sr.register(new InvocationPlugin.InlineOnlyInvocationPlugin("getByte", new Type[]{byte[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.addPush(JavaKind.Byte, new JavaReadNode(JavaKind.Byte, new IndexAddressNode(arg1, arg2, JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Byte), BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                return true;
            }
        });
    }

    private static void registerArraysPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Arrays.class), replacements);
        r.register(new ArrayEqualsInvocationPlugin(JavaKind.Boolean, new Type[]{boolean[].class, boolean[].class}));
        r.register(new ArrayEqualsInvocationPlugin(JavaKind.Byte, new Type[]{byte[].class, byte[].class}));
        r.register(new ArrayEqualsInvocationPlugin(JavaKind.Short, new Type[]{short[].class, short[].class}));
        r.register(new ArrayEqualsInvocationPlugin(JavaKind.Char, new Type[]{char[].class, char[].class}));
        r.register(new ArrayEqualsInvocationPlugin(JavaKind.Int, new Type[]{int[].class, int[].class}));
        r.register(new ArrayEqualsInvocationPlugin(JavaKind.Long, new Type[]{long[].class, long[].class}));
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.register(new InvocationPlugin("newInstance", new Type[]{Class.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode componentType, ValueNode length) {
                ValueNode componentTypeNonNull = b.nullCheckedValue(componentType);
                ValueNode lengthPositive = b.maybeEmitExplicitNegativeArraySizeCheck(length);
                b.addPush(JavaKind.Object, new DynamicNewArrayNode(componentTypeNonNull, lengthPositive, true));
                return true;
            }
        });
        r.register(new InvocationPlugin("getLength", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode object) {
                ValueNode array;
                ValueNode objectNonNull = b.nullCheckedValue(object);
                LogicNode isArray = b.add(ObjectIsArrayNode.create(objectNonNull));
                GuardingNode isArrayGuard = b.needsExplicitException() ? b.emitBytecodeExceptionCheck(isArray, true, BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, new ValueNode[0]) : (GuardingNode)b.add(new FixedGuardNode(isArray, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.InvalidateRecompile, false));
                if (isArrayGuard != null) {
                    AbstractObjectStamp alwaysArrayStamp = ((AbstractObjectStamp)objectNonNull.stamp(NodeView.DEFAULT)).asAlwaysArray();
                    array = b.add(new PiNode(objectNonNull, (Stamp)alwaysArrayStamp, isArrayGuard.asNode()));
                } else {
                    array = objectNonNull;
                }
                b.addPush(JavaKind.Int, new ArrayLengthNode(array));
                return true;
            }
        });
    }

    private static Class<?> getJavaClass(JavaKind kind) {
        return kind == JavaKind.Object ? Object.class : kind.toJavaClass();
    }

    private static String[] getKindNames(boolean isSunMiscUnsafe, JavaKind kind) {
        if (kind == JavaKind.Object && !isSunMiscUnsafe) {
            return new String[]{"Object", "Reference"};
        }
        return new String[]{kind.name()};
    }

    private static String memoryOrderModeToMethodSuffix(MemoryOrderMode memoryOrder) {
        switch (memoryOrder) {
            case VOLATILE: {
                return "";
            }
            case ACQUIRE: {
                return "Acquire";
            }
            case RELEASE: {
                return "Release";
            }
            case PLAIN: {
                return "Plain";
            }
        }
        throw new IllegalArgumentException(memoryOrder.name());
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, Replacements replacements, boolean explicitUnsafeNullChecks) {
        InvocationPlugins.Registration sunMiscUnsafe = new InvocationPlugins.Registration(plugins, "sun.misc.Unsafe");
        StandardGraphBuilderPlugins.registerUnsafePlugins0(sunMiscUnsafe, true, explicitUnsafeNullChecks);
        JavaKind[] supportedJavaKinds = new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object};
        StandardGraphBuilderPlugins.registerUnsafeGetAndOpPlugins(sunMiscUnsafe, true, explicitUnsafeNullChecks, supportedJavaKinds);
        StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(sunMiscUnsafe, true, explicitUnsafeNullChecks, "compareAndSwap", supportedJavaKinds, MemoryOrderMode.VOLATILE);
        InvocationPlugins.Registration jdkInternalMiscUnsafe = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
        StandardGraphBuilderPlugins.registerUnsafePlugins0(jdkInternalMiscUnsafe, false, explicitUnsafeNullChecks);
        StandardGraphBuilderPlugins.registerUnsafeUnalignedPlugins(jdkInternalMiscUnsafe, explicitUnsafeNullChecks);
        supportedJavaKinds = new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Object};
        StandardGraphBuilderPlugins.registerUnsafeGetAndOpPlugins(jdkInternalMiscUnsafe, false, explicitUnsafeNullChecks, supportedJavaKinds);
        StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(jdkInternalMiscUnsafe, false, explicitUnsafeNullChecks, "weakCompareAndSet", supportedJavaKinds, MemoryOrderMode.VOLATILE, MemoryOrderMode.ACQUIRE, MemoryOrderMode.RELEASE, MemoryOrderMode.PLAIN);
        StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(jdkInternalMiscUnsafe, false, explicitUnsafeNullChecks, "compareAndExchange", supportedJavaKinds, MemoryOrderMode.ACQUIRE, MemoryOrderMode.RELEASE);
        supportedJavaKinds = new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double, JavaKind.Object};
        StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(jdkInternalMiscUnsafe, false, explicitUnsafeNullChecks, "compareAndSet", supportedJavaKinds, MemoryOrderMode.VOLATILE);
        StandardGraphBuilderPlugins.registerUnsafeAtomicsPlugins(jdkInternalMiscUnsafe, false, explicitUnsafeNullChecks, "compareAndExchange", supportedJavaKinds, MemoryOrderMode.VOLATILE);
        jdkInternalMiscUnsafe.register(new AllocateUninitializedArrayPlugin("allocateUninitializedArray0", false));
    }

    private static void registerUnsafeAtomicsPlugins(InvocationPlugins.Registration r, boolean isSunMiscUnsafe, boolean explicitUnsafeNullChecks, String casPrefix, JavaKind[] supportedJavaKinds, MemoryOrderMode ... memoryOrders) {
        for (JavaKind kind : supportedJavaKinds) {
            Class<?> javaClass = StandardGraphBuilderPlugins.getJavaClass(kind);
            for (String kindName : StandardGraphBuilderPlugins.getKindNames(isSunMiscUnsafe, kind)) {
                boolean isLogic = true;
                if (casPrefix.startsWith("compareAndExchange")) {
                    isLogic = false;
                }
                for (MemoryOrderMode memoryOrder : memoryOrders) {
                    String name = casPrefix + kindName + StandardGraphBuilderPlugins.memoryOrderModeToMethodSuffix(memoryOrder);
                    r.register(new UnsafeCompareAndSwapPlugin(kind, memoryOrder, isLogic, explicitUnsafeNullChecks, name, new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass, javaClass}));
                }
            }
        }
    }

    private static void registerUnsafeUnalignedPlugins(InvocationPlugins.Registration r, boolean explicitUnsafeNullChecks) {
        for (JavaKind kind : new JavaKind[]{JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long}) {
            Class javaClass = kind.toJavaClass();
            r.register(new UnsafeGetPlugin(kind, explicitUnsafeNullChecks, "get" + kind.name() + "Unaligned", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE}));
            r.register(new UnsafePutPlugin(kind, explicitUnsafeNullChecks, "put" + kind.name() + "Unaligned", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}));
        }
    }

    private static void registerUnsafeGetAndOpPlugins(InvocationPlugins.Registration r, boolean isSunMiscUnsafe, boolean explicitUnsafeNullChecks, JavaKind[] unsafeJavaKinds) {
        for (final JavaKind kind : unsafeJavaKinds) {
            Class javaClass = kind == JavaKind.Object ? Object.class : kind.toJavaClass();
            for (String kindName : StandardGraphBuilderPlugins.getKindNames(isSunMiscUnsafe, kind)) {
                r.register(new UnsafeAccessPlugin(kind, kind, explicitUnsafeNullChecks, "getAndSet" + kindName, new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode value) {
                        unsafe.get();
                        this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndWriteNode(obj, offset, value, kind, loc));
                        return true;
                    }
                });
                if (kind == JavaKind.Boolean || !kind.isNumericInteger()) continue;
                r.register(new UnsafeAccessPlugin(kind, kind, explicitUnsafeNullChecks, "getAndAdd" + kindName, new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode delta) {
                        unsafe.get();
                        this.createUnsafeAccess(object, b, (obj, loc) -> new AtomicReadAndAddNode(obj, offset, delta, kind, loc));
                        return true;
                    }
                });
            }
        }
    }

    private static void registerUnsafePlugins0(InvocationPlugins.Registration r, boolean sunMiscUnsafe, boolean explicitUnsafeNullChecks) {
        for (JavaKind kind : JavaKind.values()) {
            if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
            Class javaClass = kind == JavaKind.Object ? Object.class : kind.toJavaClass();
            for (String kindName : StandardGraphBuilderPlugins.getKindNames(sunMiscUnsafe, kind)) {
                String getName = "get" + kindName;
                String putName = "put" + kindName;
                r.register(new UnsafeGetPlugin(kind, explicitUnsafeNullChecks, getName, new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE}));
                r.register(new UnsafePutPlugin(kind, explicitUnsafeNullChecks, putName, new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}));
                r.register(new UnsafeGetPlugin(kind, MemoryOrderMode.VOLATILE, explicitUnsafeNullChecks, getName + "Volatile", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE}));
                r.register(new UnsafePutPlugin(kind, MemoryOrderMode.VOLATILE, explicitUnsafeNullChecks, putName + "Volatile", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}));
                if (sunMiscUnsafe) {
                    if (kind == JavaKind.Int || kind == JavaKind.Long || kind == JavaKind.Object) {
                        r.register(new UnsafePutPlugin(kind, MemoryOrderMode.RELEASE, explicitUnsafeNullChecks, "putOrdered" + kindName, new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}));
                    }
                } else {
                    r.register(new UnsafePutPlugin(kind, MemoryOrderMode.RELEASE, explicitUnsafeNullChecks, "put" + kindName + "Release", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}));
                    r.register(new UnsafeGetPlugin(kind, MemoryOrderMode.ACQUIRE, explicitUnsafeNullChecks, "get" + kindName + "Acquire", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE}));
                    r.register(new UnsafePutPlugin(kind, MemoryOrderMode.OPAQUE, explicitUnsafeNullChecks, "put" + kindName + "Opaque", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, javaClass}));
                    r.register(new UnsafeGetPlugin(kind, MemoryOrderMode.OPAQUE, explicitUnsafeNullChecks, "get" + kindName + "Opaque", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE}));
                }
                if (kind == JavaKind.Boolean || kind == JavaKind.Object) continue;
                r.register(new UnsafeGetPlugin(kind, explicitUnsafeNullChecks, getName, new Type[]{InvocationPlugin.Receiver.class, Long.TYPE}));
                r.register(new UnsafePutPlugin(kind, explicitUnsafeNullChecks, putName, new Type[]{InvocationPlugin.Receiver.class, Long.TYPE, kind.toJavaClass()}));
            }
        }
        r.register(new UnsafeGetPlugin(JavaKind.Long, explicitUnsafeNullChecks, "getAddress", new Type[]{InvocationPlugin.Receiver.class, Long.TYPE}));
        r.register(new UnsafePutPlugin(JavaKind.Long, explicitUnsafeNullChecks, "putAddress", new Type[]{InvocationPlugin.Receiver.class, Long.TYPE, Long.TYPE}));
        r.register(new UnsafeFencePlugin(MembarNode.FenceKind.LOAD_ACQUIRE, "loadFence"));
        r.register(new UnsafeFencePlugin(MembarNode.FenceKind.STORE_RELEASE, "storeFence"));
        r.register(new UnsafeFencePlugin(MembarNode.FenceKind.FULL, "fullFence"));
        if (!sunMiscUnsafe) {
            r.register(new CacheWritebackPlugin(false, "writeback0", new Type[]{InvocationPlugin.Receiver.class, Long.TYPE}));
            r.register(new CacheWritebackPlugin(true, "writebackPreSync0", new Type[]{InvocationPlugin.Receiver.class}));
            r.register(new CacheWritebackPlugin(false, "writebackPostSync0", new Type[]{InvocationPlugin.Receiver.class}));
            if (JavaVersionUtil.JAVA_SPEC >= 18) {
                r.register(new UnsafeFencePlugin(MembarNode.FenceKind.STORE_STORE, "storeStoreFence"));
            }
        }
        r.register(new InvocationPlugin("arrayBaseOffset", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode arrayClass) {
                return StandardGraphBuilderPlugins.handleArrayBaseOffsetOrIndexScale(b, unsafe, arrayClass, true);
            }
        });
        r.register(new InvocationPlugin("arrayIndexScale", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode arrayClass) {
                return StandardGraphBuilderPlugins.handleArrayBaseOffsetOrIndexScale(b, unsafe, arrayClass, false);
            }
        });
    }

    private static boolean handleArrayBaseOffsetOrIndexScale(GraphBuilderContext b, InvocationPlugin.Receiver unsafe, ValueNode arrayClass, boolean arrayBaseOffset) {
        ResolvedJavaType arrayType;
        JavaConstant arrayClassConstant = arrayClass.asJavaConstant();
        if (arrayClassConstant != null && arrayClassConstant.isNonNull() && (arrayType = b.getConstantReflection().asJavaType((Constant)arrayClassConstant)) != null && arrayType.isArray()) {
            unsafe.get();
            JavaKind elementKind = b.getMetaAccessExtensionProvider().getStorageKind((JavaType)arrayType.getComponentType());
            int result = arrayBaseOffset ? b.getMetaAccess().getArrayBaseOffset(elementKind) : b.getMetaAccess().getArrayIndexScale(elementKind);
            b.addPush(JavaKind.Int, ConstantNode.forInt(result));
            return true;
        }
        return false;
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, final JavaKind kind) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass);
        r.register(new InvocationPlugin("reverseBytes", new Type[]{type}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(kind, b.append((ValueNode)new ReverseBytesNode(value).canonical(null)));
                return true;
            }
        });
        r.register(new InvocationPlugin("divideUnsigned", new Type[]{type, type}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode dividend, ValueNode divisor) {
                GuardingNode zeroCheck = b.maybeEmitExplicitDivisionByZeroCheck(divisor);
                b.push(kind, b.append(UnsignedDivNode.create(dividend, divisor, zeroCheck, NodeView.DEFAULT)));
                return true;
            }
        });
        r.register(new InvocationPlugin("remainderUnsigned", new Type[]{type, type}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode dividend, ValueNode divisor) {
                GuardingNode zeroCheck = b.maybeEmitExplicitDivisionByZeroCheck(divisor);
                b.push(kind, b.append(UnsignedRemNode.create(dividend, divisor, zeroCheck, NodeView.DEFAULT)));
                return true;
            }
        });
        r.register(new InvocationPlugin("compareUnsigned", new Type[]{type, type}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.addPush(JavaKind.Int, IntegerNormalizeCompareNode.create(x, y, true, JavaKind.Int, b.getConstantReflection()));
                return true;
            }
        });
    }

    private static void registerCharacterPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Character.class));
        r.register(new InvocationPlugin("reverseBytes", new Type[]{Character.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                ReverseBytesNode reverse = b.add(new ReverseBytesNode(value));
                RightShiftNode rightShift = b.add(new RightShiftNode(reverse, b.add(ConstantNode.forInt(16))));
                ZeroExtendNode charCast = b.add(new ZeroExtendNode(b.add(new NarrowNode(rightShift, 16)), 32));
                b.push(JavaKind.Char, b.append((ValueNode)charCast.canonical(null)));
                return true;
            }
        });
    }

    private static void registerCharacterDataLatin1Plugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.CharacterDataLatin1");
        r.register(new InvocationPlugin("isDigit", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode ch) {
                b.nullCheckedValue(receiver.get());
                ValueNode sub = b.add(SubNode.create(ch, ConstantNode.forInt(48), NodeView.DEFAULT));
                LogicNode isDigit = b.add(IntegerBelowNode.create(sub, ConstantNode.forInt(10), NodeView.DEFAULT));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(isDigit, NodeView.DEFAULT));
                return true;
            }
        });
    }

    private static void registerShortPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Short.class));
        r.register(new InvocationPlugin("reverseBytes", new Type[]{Short.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                ReverseBytesNode reverse = b.add(new ReverseBytesNode(value));
                RightShiftNode rightShift = b.add(new RightShiftNode(reverse, b.add(ConstantNode.forInt(16))));
                SignExtendNode charCast = b.add(new SignExtendNode(b.add(new NarrowNode(rightShift, 16)), 32));
                b.push(JavaKind.Short, b.append((ValueNode)charCast.canonical(null)));
                return true;
            }
        });
    }

    private static void registerFloatPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Float.class));
        r.register(new InvocationPlugin("floatToRawIntBits", new Type[]{Float.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append(ReinterpretNode.create(JavaKind.Int, value, NodeView.DEFAULT)));
                return true;
            }
        });
        r.register(new InvocationPlugin("floatToIntBits", new Type[]{Float.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                LogicNode notNan = b.append(FloatEqualsNode.create(value, value, NodeView.DEFAULT));
                ValueNode raw = b.append(ReinterpretNode.create(JavaKind.Int, value, NodeView.DEFAULT));
                ValueNode result = b.append(ConditionalNode.create(notNan, raw, ConstantNode.forInt(2143289344), NodeView.DEFAULT));
                b.push(JavaKind.Int, result);
                return true;
            }
        });
        r.register(new InvocationPlugin("intBitsToFloat", new Type[]{Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Float, b.append(ReinterpretNode.create(JavaKind.Float, value, NodeView.DEFAULT)));
                return true;
            }
        });
    }

    private static void registerDoublePlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Double.class));
        r.register(new InvocationPlugin("doubleToRawLongBits", new Type[]{Double.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Long, b.append(ReinterpretNode.create(JavaKind.Long, value, NodeView.DEFAULT)));
                return true;
            }
        });
        r.register(new InvocationPlugin("doubleToLongBits", new Type[]{Double.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                LogicNode notNan = b.append(FloatEqualsNode.create(value, value, NodeView.DEFAULT));
                ValueNode raw = b.append(ReinterpretNode.create(JavaKind.Long, value, NodeView.DEFAULT));
                ValueNode result = b.append(ConditionalNode.create(notNan, raw, ConstantNode.forLong(9221120237041090560L), NodeView.DEFAULT));
                b.push(JavaKind.Long, result);
                return true;
            }
        });
        r.register(new InvocationPlugin("longBitsToDouble", new Type[]{Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append(ReinterpretNode.create(JavaKind.Double, value, NodeView.DEFAULT)));
                return true;
            }
        });
    }

    private static GuardingNode createIntegerExactArithmeticGuardNode(GraphBuilderContext b, ValueNode x, ValueNode y, IntegerExactBinaryOp op) {
        return b.add(new FixedGuardNode(switch (op) {
            case IntegerExactBinaryOp.INTEGER_ADD_EXACT, IntegerExactBinaryOp.INTEGER_INCREMENT_EXACT -> new IntegerAddExactOverflowNode(x, y);
            case IntegerExactBinaryOp.INTEGER_SUBTRACT_EXACT, IntegerExactBinaryOp.INTEGER_DECREMENT_EXACT -> new IntegerSubExactOverflowNode(x, y);
            case IntegerExactBinaryOp.INTEGER_MULTIPLY_EXACT -> new IntegerMulExactOverflowNode(x, y);
            default -> throw GraalError.shouldNotReachHere("Unknown integer exact operation.");
        }, DeoptimizationReason.ArithmeticException, DeoptimizationAction.InvalidateRecompile, true));
    }

    private static ValueNode createIntegerExactArithmeticNode(GraphBuilderContext b, ValueNode x, ValueNode y, IntegerExactBinaryOp op) {
        switch (op) {
            case INTEGER_ADD_EXACT: 
            case INTEGER_INCREMENT_EXACT: {
                return new IntegerAddExactNode(x, y, StandardGraphBuilderPlugins.createIntegerExactArithmeticGuardNode(b, x, y, op));
            }
            case INTEGER_SUBTRACT_EXACT: 
            case INTEGER_DECREMENT_EXACT: {
                return new IntegerSubExactNode(x, y, StandardGraphBuilderPlugins.createIntegerExactArithmeticGuardNode(b, x, y, op));
            }
            case INTEGER_MULTIPLY_EXACT: {
                return new IntegerMulExactNode(x, y, StandardGraphBuilderPlugins.createIntegerExactArithmeticGuardNode(b, x, y, op));
            }
        }
        throw GraalError.shouldNotReachHere("Unknown integer exact operation.");
    }

    private static IntegerExactArithmeticSplitNode createIntegerExactSplit(ValueNode x, ValueNode y, AbstractBeginNode exceptionEdge, IntegerExactBinaryOp op) {
        switch (op) {
            case INTEGER_ADD_EXACT: 
            case INTEGER_INCREMENT_EXACT: {
                return new IntegerAddExactSplitNode(x.stamp(NodeView.DEFAULT).unrestricted(), x, y, null, exceptionEdge);
            }
            case INTEGER_SUBTRACT_EXACT: 
            case INTEGER_DECREMENT_EXACT: {
                return new IntegerSubExactSplitNode(x.stamp(NodeView.DEFAULT).unrestricted(), x, y, null, exceptionEdge);
            }
            case INTEGER_MULTIPLY_EXACT: {
                return new IntegerMulExactSplitNode(x.stamp(NodeView.DEFAULT).unrestricted(), x, y, null, exceptionEdge);
            }
        }
        throw GraalError.shouldNotReachHere("Unknown integer exact operation.");
    }

    private static void createIntegerExactBinaryOperation(GraphBuilderContext b, JavaKind kind, ValueNode x, ValueNode y, IntegerExactBinaryOp op) {
        if (b.needsExplicitException()) {
            BytecodeExceptionNode.BytecodeExceptionKind exceptionKind = kind == JavaKind.Int ? BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW : BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW;
            AbstractBeginNode exceptionEdge = b.genExplicitExceptionEdge(exceptionKind, new ValueNode[0]);
            IntegerExactArithmeticSplitNode split = b.addPush(kind, StandardGraphBuilderPlugins.createIntegerExactSplit(x, y, exceptionEdge, op));
            split.setNext(b.add(new BeginNode()));
        } else {
            b.addPush(kind, StandardGraphBuilderPlugins.createIntegerExactArithmeticNode(b, x, y, op));
        }
    }

    private static void registerMathPlugins(InvocationPlugins plugins, boolean useExactMathPlugins, Replacements replacements, LoweringProvider lowerer) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Math.class), replacements);
        if (useExactMathPlugins) {
            for (final JavaKind kind : new JavaKind[]{JavaKind.Int, JavaKind.Long}) {
                Class type = kind.toJavaClass();
                r.register(new InvocationPlugin("decrementExact", new Type[]{type}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                        ConstantNode y = b.add(ConstantNode.forIntegerKind(kind, 1L));
                        StandardGraphBuilderPlugins.createIntegerExactBinaryOperation(b, kind, x, y, IntegerExactBinaryOp.INTEGER_DECREMENT_EXACT);
                        return true;
                    }
                });
                r.register(new InvocationPlugin("incrementExact", new Type[]{type}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                        ConstantNode y = b.add(ConstantNode.forIntegerKind(kind, 1L));
                        StandardGraphBuilderPlugins.createIntegerExactBinaryOperation(b, kind, x, y, IntegerExactBinaryOp.INTEGER_INCREMENT_EXACT);
                        return true;
                    }
                });
                r.register(new InvocationPlugin("addExact", new Type[]{type, type}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                        StandardGraphBuilderPlugins.createIntegerExactBinaryOperation(b, kind, x, y, IntegerExactBinaryOp.INTEGER_ADD_EXACT);
                        return true;
                    }
                });
                r.register(new InvocationPlugin("subtractExact", new Type[]{type, type}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                        StandardGraphBuilderPlugins.createIntegerExactBinaryOperation(b, kind, x, y, IntegerExactBinaryOp.INTEGER_SUBTRACT_EXACT);
                        return true;
                    }
                });
                r.register(new InvocationPlugin("multiplyExact", new Type[]{type, type}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                        StandardGraphBuilderPlugins.createIntegerExactBinaryOperation(b, kind, x, y, IntegerExactBinaryOp.INTEGER_MULTIPLY_EXACT);
                        return true;
                    }
                });
                r.register(new InvocationPlugin("negateExact", new Type[]{type}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                        if (b.needsExplicitException()) {
                            BytecodeExceptionNode.BytecodeExceptionKind exceptionKind = kind == JavaKind.Int ? BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW : BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW;
                            AbstractBeginNode exceptionEdge = b.genExplicitExceptionEdge(exceptionKind, new ValueNode[0]);
                            IntegerExactArithmeticSplitNode split = b.addPush(kind, new IntegerNegExactSplitNode(value.stamp(NodeView.DEFAULT).unrestricted(), value, null, exceptionEdge));
                            split.setNext(b.add(new BeginNode()));
                        } else {
                            IntegerNegExactOverflowNode overflowCheck = new IntegerNegExactOverflowNode(value);
                            FixedGuardNode guard = b.add(new FixedGuardNode(overflowCheck, DeoptimizationReason.ArithmeticException, DeoptimizationAction.InvalidateRecompile, true));
                            b.addPush(kind, new IntegerNegExactNode(value, guard));
                        }
                        return true;
                    }
                });
            }
        }
        r.register(new InvocationPlugin("multiplyHigh", new Type[]{Long.TYPE, Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Long, b.append(new IntegerMulHighNode(x, y)));
                return true;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{Float.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Float, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{Double.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
        r.register(new MathSqrtPlugin());
        boolean supportsRound = lowerer.supportsRounding();
        StandardGraphBuilderPlugins.registerRound(supportsRound, r, "rint", ArithmeticLIRGeneratorTool.RoundingMode.NEAREST);
        StandardGraphBuilderPlugins.registerRound(supportsRound, r, "ceil", ArithmeticLIRGeneratorTool.RoundingMode.UP);
        StandardGraphBuilderPlugins.registerRound(supportsRound, r, "floor", ArithmeticLIRGeneratorTool.RoundingMode.DOWN);
        r.register(new InvocationPlugin("signum", new Type[]{Float.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode f) {
                b.addPush(JavaKind.Float, new SignumNode(f));
                return true;
            }
        });
        r.register(new InvocationPlugin("signum", new Type[]{Double.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode d) {
                b.addPush(JavaKind.Double, new SignumNode(d));
                return true;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Long, b.append((ValueNode)new AbsNode(value).canonical(null)));
                return true;
            }
        });
        if (JavaVersionUtil.JAVA_SPEC >= 18) {
            r.register(new InvocationPlugin("unsignedMultiplyHigh", new Type[]{Long.TYPE, Long.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.addPush(JavaKind.Long, new UnsignedMulHighNode(x, y));
                    return true;
                }
            });
        }
    }

    private static void registerRound(boolean supportsRound, InvocationPlugins.Registration r, String name, final ArithmeticLIRGeneratorTool.RoundingMode mode) {
        r.registerConditional(supportsRound, new InvocationPlugin(name, new Type[]{Double.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.push(JavaKind.Double, b.append(new RoundNode(arg, mode)));
                return true;
            }
        });
    }

    private static void registerStrictMathPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)StrictMath.class));
        r.register(new MathSqrtPlugin());
    }

    private static void registerUnsignedMathPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)UnsignedMath.class));
        r.register(new UnsignedMathPlugin(Condition.AT, "aboveThan", Integer.TYPE, Integer.TYPE));
        r.register(new UnsignedMathPlugin(Condition.AT, "aboveThan", Long.TYPE, Long.TYPE));
        r.register(new UnsignedMathPlugin(Condition.BT, "belowThan", Integer.TYPE, Integer.TYPE));
        r.register(new UnsignedMathPlugin(Condition.BT, "belowThan", Long.TYPE, Long.TYPE));
        r.register(new UnsignedMathPlugin(Condition.AE, "aboveOrEqual", Integer.TYPE, Integer.TYPE));
        r.register(new UnsignedMathPlugin(Condition.AE, "aboveOrEqual", Long.TYPE, Long.TYPE));
        r.register(new UnsignedMathPlugin(Condition.BE, "belowOrEqual", Integer.TYPE, Integer.TYPE));
        r.register(new UnsignedMathPlugin(Condition.BE, "belowOrEqual", Long.TYPE, Long.TYPE));
    }

    protected static void registerBoxingPlugins(InvocationPlugins plugins) {
        for (JavaKind kind : JavaKind.values()) {
            if (!kind.isPrimitive() || kind == JavaKind.Void) continue;
            plugins.register(kind.toBoxedJavaClass(), new BoxPlugin(kind));
            plugins.register(kind.toBoxedJavaClass(), new UnboxPlugin(kind));
        }
    }

    private static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class));
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("<init>", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (targetMethod.canBeInlined() && targetMethod.getCodeSize() == 1) {
                    ValueNode object = receiver.get();
                    if (RegisterFinalizerNode.mayHaveFinalizer(object, b.getMetaAccess(), b.getAssumptions())) {
                        RegisterFinalizerNode regFin = new RegisterFinalizerNode(object);
                        b.add(regFin);
                        assert (regFin.stateAfter() != null);
                    }
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin("getClass", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                ValueNode folded = GetClassNode.tryFold(b.getAssumptions(), b.getMetaAccess(), b.getConstantReflection(), NodeView.DEFAULT, GraphUtil.originalValue(object, true));
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    ObjectStamp stamp = StampFactory.objectNonNull(TypeReference.createTrusted(b.getAssumptions(), b.getMetaAccess().lookupJavaType(Class.class)));
                    b.addPush(JavaKind.Object, new GetClassNode(stamp, object));
                }
                return true;
            }
        });
    }

    private static void registerClassPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Class.class));
        r.register(new InvocationPlugin("isInstance", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode object) {
                LogicNode condition = b.append(InstanceOfDynamicNode.create(b.getAssumptions(), b.getConstantReflection(), type.get(), object, false));
                b.push(JavaKind.Boolean, b.append(new ConditionalNode(condition).canonical(null)));
                return true;
            }
        });
        r.register(new InvocationPlugin("isAssignableFrom", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode otherType) {
                ClassIsAssignableFromNode condition = b.append(new ClassIsAssignableFromNode(type.get(), b.nullCheckedValue(otherType)));
                b.push(JavaKind.Boolean, b.append(new ConditionalNode(condition).canonical(null)));
                return true;
            }
        });
        r.register(new InvocationPlugin("isArray", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                LogicNode isArray = b.add(ClassIsArrayNode.create(b.getConstantReflection(), receiver.get()));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(isArray, NodeView.DEFAULT));
                return true;
            }
        });
        r.register(new InvocationPlugin("cast", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.genCheckcastDynamic(object, receiver.get());
                return true;
            }
        });
    }

    private static void registerEdgesPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Edges.class));
        for (Class c : new Class[]{Node.class, NodeList.class}) {
            r.register(new InvocationPlugin("get" + c.getSimpleName() + "Unsafe", new Type[]{Node.class, Long.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset) {
                    Stamp stamp = b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp();
                    RawLoadNode value = b.add(new RawLoadNode(stamp, node, offset, LocationIdentity.any(), JavaKind.Object));
                    b.addPush(JavaKind.Object, value);
                    return true;
                }
            });
            r.register(new InvocationPlugin("put" + c.getSimpleName() + "Unsafe", new Type[]{Node.class, Long.TYPE, c}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset, ValueNode value) {
                    b.add(new RawStoreNode(node, offset, value, JavaKind.Object, LocationIdentity.any()));
                    return true;
                }
            });
        }
    }

    private static void registerGraalDirectivesPlugins(InvocationPlugins plugins, final SnippetReflectionProvider snippetReflection) {
        Class<?> javaClass;
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)GraalDirectives.class));
        r.register(new DeoptimizePlugin(snippetReflection, DeoptimizationAction.None, DeoptimizationReason.TransferToInterpreter, false, "deoptimize", new Type[0]));
        r.register(new DeoptimizePlugin(snippetReflection, DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TransferToInterpreter, false, "deoptimizeAndInvalidate", new Type[0]));
        r.register(new DeoptimizePlugin(snippetReflection, null, null, null, "deoptimize", new Type[]{DeoptimizationAction.class, DeoptimizationReason.class, Boolean.TYPE}));
        r.register(new DeoptimizePlugin(snippetReflection, null, null, null, "deoptimize", new Type[]{DeoptimizationAction.class, DeoptimizationReason.class, SpeculationLog.SpeculationReason.class}));
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("inCompiledCode", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("inIntrinsic", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(b.parsingIntrinsic()));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("controlFlowAnchor", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new ControlFlowAnchorNode());
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("neverStripMine", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new NeverStripMineNode());
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("neverWriteSink", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new NeverWriteSinkNode());
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("sideEffect", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new SideEffectNode());
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("sideEffect", new Type[]{Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a) {
                b.addPush(JavaKind.Int, new SideEffectNode(a));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("sideEffect", new Type[]{Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a) {
                b.addPush(JavaKind.Long, new SideEffectNode(a));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("trustedBox", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a) {
                b.addPush(JavaKind.Object, new BoxNode.TrustedBoxedValue(a));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("assumeStableDimension", new Type[]{Object.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode dimension) {
                if (array instanceof ConstantNode && b.getMetaAccess().lookupJavaType(array.asJavaConstant()).isArray() && dimension instanceof ConstantNode && dimension.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                    int stableDim = dimension.asJavaConstant().asInt();
                    ConstantNode c = ConstantNode.forConstant(array.asJavaConstant(), stableDim, false, b.getMetaAccess());
                    b.addPush(JavaKind.Object, c);
                    return true;
                }
                throw GraalError.shouldNotReachHere("Illegal usage of stable array intrinsic assumeStableDimension(array, dimension): This compiler intrinsic can only be used iff array is a constant node (i.e., constant field) and iff dimension is a constant int. It will replace the constant array with a new constant that additionally sets the stabledimensions to the int parameter supplied.");
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("injectBranchProbability", new Type[]{Double.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode probability, ValueNode condition) {
                b.addPush(JavaKind.Boolean, new BranchProbabilityNode(probability, condition));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("injectIterationCount", new Type[]{Double.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode iterations, ValueNode condition) {
                if (iterations.isJavaConstant()) {
                    double iterationsConstant;
                    if (iterations.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                        iterationsConstant = iterations.asJavaConstant().asLong();
                    } else if (iterations.stamp(NodeView.DEFAULT) instanceof FloatStamp) {
                        iterationsConstant = iterations.asJavaConstant().asDouble();
                    } else {
                        return false;
                    }
                    double probability = 1.0 - 1.0 / iterationsConstant;
                    ValueNode probabilityNode = b.add(ConstantNode.forDouble(probability));
                    b.addPush(JavaKind.Boolean, new BranchProbabilityNode(probabilityNode, condition));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("injectSwitchCaseProbability", new Type[]{Double.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode probability) {
                b.add(new SwitchCaseProbabilityNode(probability));
                return true;
            }
        });
        for (final JavaKind kind : JavaKind.values()) {
            if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
            javaClass = StandardGraphBuilderPlugins.getJavaClass(kind);
            r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("blackhole", new Type[]{javaClass}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    b.add(new BlackholeNode(value));
                    return true;
                }
            });
            r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("bindToRegister", new Type[]{javaClass}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    b.add(new BindToRegisterNode(value));
                    return true;
                }
            });
            r.register(new InvocationPlugin.RequiredInvocationPlugin("opaque", new Type[]{javaClass}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    b.addPush(kind, new OpaqueValueNode(value));
                    return true;
                }
            });
        }
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("spillRegisters", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new SpillRegistersNode());
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("guardingNonNull", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.addPush(value.getStackKind(), b.nullCheckedValue(value));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("ensureVirtualized", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, false));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("ensureVirtualizedHere", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, true));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("breakpoint", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new BreakpointNode(new ValueNode[0]));
                return true;
            }
        });
        for (final JavaKind kind : JavaKind.values()) {
            if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
            javaClass = StandardGraphBuilderPlugins.getJavaClass(kind);
            r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("isCompilationConstant", new Type[]{javaClass}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(value.isJavaConstant()));
                    return true;
                }
            });
        }
        r.register(new InvocationPlugin.RequiredInvocationPlugin("log", new Type[]{String.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode format) {
                if (format.isJavaConstant()) {
                    String formatConst = snippetReflection.asObject(String.class, format.asJavaConstant());
                    b.add(new LogNode(formatConst, null, null, null));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("log", new Type[]{String.class, Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode format, ValueNode l1) {
                if (format.isJavaConstant()) {
                    String formatConst = snippetReflection.asObject(String.class, format.asJavaConstant());
                    b.add(new LogNode(formatConst, l1, null, null));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("log", new Type[]{String.class, Long.TYPE, Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode format, ValueNode l1, ValueNode l2) {
                if (format.isJavaConstant()) {
                    String formatConst = snippetReflection.asObject(String.class, format.asJavaConstant());
                    b.add(new LogNode(formatConst, l1, l2, null));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("log", new Type[]{String.class, Long.TYPE, Long.TYPE, Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode format, ValueNode l1, ValueNode l2, ValueNode l3) {
                if (format.isJavaConstant()) {
                    String formatConst = snippetReflection.asObject(String.class, format.asJavaConstant());
                    b.add(new LogNode(formatConst, l1, l2, l3));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerJMHBlackholePlugins(InvocationPlugins plugins, Replacements replacements) {
        String[] names;
        for (String name : names = new String[]{"org.openjdk.jmh.infra.Blackhole", "org.openjdk.jmh.logic.BlackHole"}) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, name, replacements);
            for (JavaKind kind : JavaKind.values()) {
                if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
                Class<?> javaClass = StandardGraphBuilderPlugins.getJavaClass(kind);
                r.register(new InvocationPlugin.OptionalInvocationPlugin("consume", new Type[]{InvocationPlugin.Receiver.class, javaClass}){

                    @Override
                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver blackhole, ValueNode value) {
                        blackhole.get();
                        b.add(new BlackholeNode(value));
                        return true;
                    }

                    @Override
                    public boolean isDecorator() {
                        return true;
                    }
                });
            }
            r.register(new InvocationPlugin.OptionalInvocationPlugin("consume", new Type[]{InvocationPlugin.Receiver.class, Object[].class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver blackhole, ValueNode value) {
                    blackhole.get();
                    b.add(new BlackholeNode(value));
                    return true;
                }

                @Override
                public boolean isDecorator() {
                    return true;
                }
            });
        }
    }

    private static void registerJFRThrowablePlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "oracle.jrockit.jfr.jdkevents.ThrowableTracer", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("traceThrowable", new Type[]{Throwable.class, String.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode throwable, ValueNode message) {
                b.add(new VirtualizableInvokeMacroNode(MacroNode.MacroParams.of(b, targetMethod, throwable, message)));
                return true;
            }
        });
    }

    private static void registerMethodHandleImplPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.MethodHandleImpl", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("profileBoolean", new Type[]{Boolean.TYPE, int[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode result, ValueNode counters) {
                if (b.needsExplicitException()) {
                    return false;
                }
                if (result.isConstant()) {
                    b.push(JavaKind.Boolean, result);
                    return true;
                }
                if (counters.isConstant()) {
                    ValueNode newResult = result;
                    int[] ctrs = ConstantReflectionUtil.loadIntArrayConstant(b.getConstantReflection(), (JavaConstant)counters.asConstant(), 2);
                    if (ctrs != null && ctrs.length == 2) {
                        int trueCount = ctrs[1];
                        int falseCount = ctrs[0];
                        int totalCount = trueCount + falseCount;
                        if (totalCount == 0) {
                            b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TransferToInterpreter));
                        } else if (falseCount == 0 || trueCount == 0) {
                            boolean expected = falseCount == 0;
                            LogicNode condition = b.add(IntegerEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), null, result, b.add(ConstantNode.forBoolean(!expected)), NodeView.DEFAULT));
                            b.append(new FixedGuardNode(condition, DeoptimizationReason.UnreachedCode, DeoptimizationAction.InvalidateReprofile, true));
                            newResult = b.add(ConstantNode.forBoolean(expected));
                        }
                    }
                    b.addPush(JavaKind.Boolean, newResult);
                    return true;
                }
                b.addPush(JavaKind.Boolean, new ProfileBooleanNode(b.getConstantReflection(), MacroNode.MacroParams.of(b, targetMethod, result, counters)));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("isCompileConstant", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode obj) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(obj.isConstant()));
                return true;
            }
        });
    }

    private static void registerPreconditionsPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration preconditions = new InvocationPlugins.Registration(plugins, "jdk.internal.util.Preconditions", replacements);
        preconditions.register(new CheckIndexPlugin(Integer.TYPE));
        preconditions.register(new CheckIndexPlugin(Long.TYPE));
    }

    private static void registerJcovCollectPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.tdk.jcov.runtime.Collect", replacements);
        r.register(new InvocationPlugin("hit", new Type[]{Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                return b.parsingIntrinsic();
            }
        });
    }

    private static void registerAESPlugins(InvocationPlugins plugins, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.AESCrypt", replacements);
        r.registerConditional(AESNode.isSupported(arch), new AESCryptPlugin(AESNode.CryptMode.ENCRYPT));
        r.registerConditional(AESNode.isSupported(arch), new AESCryptPlugin(AESNode.CryptMode.DECRYPT));
    }

    private static void registerGHASHPlugin(InvocationPlugins plugins, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.GHASH", replacements);
        r.registerConditional(GHASHProcessBlocksNode.isSupported(arch), new GHASHPlugin());
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)BigInteger.class), replacements);
        r.register(new SnippetSubstitutionInvocationPlugin<BigIntegerSnippets.Templates>(BigIntegerSnippets.Templates.class, "implMultiplyToLen", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class}){

            @Override
            public SnippetTemplate.SnippetInfo getSnippet(BigIntegerSnippets.Templates templates) {
                return templates.implMultiplyToLen;
            }
        });
        r.register(new InvocationPlugin("implMulAdd", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode outLength = helper.length(out);
                    ValueNode newOffset = b.add(SubNode.create(outLength, offset, NodeView.DEFAULT));
                    b.addPush(JavaKind.Int, new BigIntegerMulAddNode(helper.arrayStart(out, JavaKind.Int), helper.arrayStart(in, JavaKind.Int), newOffset, len, k));
                    boolean bl = true;
                    return bl;
                }
            }
        });
        r.register(new InvocationPlugin("implSquareToLen", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode len, ValueNode z, ValueNode zlen) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    BigIntegerSquareToLenNode squareToLen = b.append(new BigIntegerSquareToLenNode(helper.arrayStart(x, JavaKind.Int), len, helper.arrayStart(z, JavaKind.Int), zlen));
                    b.push(JavaKind.Object, z);
                    b.setStateAfter(squareToLen);
                    boolean bl = true;
                    return bl;
                }
            }
        });
    }

    private static boolean hasEnsureMaterializedForStackWalk() {
        try {
            Thread.class.getDeclaredMethod("ensureMaterializedForStackWalk", Object.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class), replacements);
        r.register(new InvocationPlugin("onSpinWait", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.append(new SpinWaitNode());
                return true;
            }
        });
        if (StandardGraphBuilderPlugins.hasEnsureMaterializedForStackWalk()) {
            r.register(new InvocationPlugin("ensureMaterializedForStackWalk", new Type[]{Object.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                    b.add(new BlackholeNode(object, "ensureMaterializedForStackWalk"));
                    return true;
                }
            });
        }
    }

    private static void registerMessageDigestPlugins(InvocationPlugins plugins, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration rSha1 = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA", replacements);
        rSha1.registerConditional(MessageDigestNode.SHA1Node.isSupported(arch), new MessageDigestPlugin(MessageDigestNode.SHA1Node::new));
        InvocationPlugins.Registration rSha2 = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA2", replacements);
        rSha2.registerConditional(MessageDigestNode.SHA256Node.isSupported(arch), new MessageDigestPlugin(MessageDigestNode.SHA256Node::new));
        InvocationPlugins.Registration rSha5 = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA5", replacements);
        rSha5.registerConditional(MessageDigestNode.SHA512Node.isSupported(arch), new MessageDigestPlugin(MessageDigestNode.SHA512Node::new){

            @Override
            protected JavaKind getStateElementType() {
                return JavaKind.Long;
            }
        });
        InvocationPlugins.Registration rMD5 = new InvocationPlugins.Registration(plugins, "sun.security.provider.MD5", replacements);
        rMD5.register(new MessageDigestPlugin(MessageDigestNode.MD5Node::new));
    }

    private static void registerStringCodingPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.StringCoding", replacements);
        r.register(new InvocationPlugin("implEncodeISOArray", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sa, ValueNode sp, ValueNode da, ValueNode dp, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    int charElementShift = CodeUtil.log2((int)b.getMetaAccess().getArrayIndexScale(JavaKind.Char));
                    ValueNode src = helper.arrayElementPointer(sa, JavaKind.Byte, LeftShiftNode.create(sp, ConstantNode.forInt(charElementShift), NodeView.DEFAULT));
                    ValueNode dst = helper.arrayElementPointer(da, JavaKind.Byte, dp);
                    b.addPush(JavaKind.Int, new EncodeArrayNode(src, dst, len, LIRGeneratorTool.CharsetName.ISO_8859_1, JavaKind.Byte));
                    boolean bl = true;
                    return bl;
                }
            }
        });
        r.register(new InvocationPlugin("implEncodeAsciiArray", new Type[]{char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sa, ValueNode sp, ValueNode da, ValueNode dp, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode src = helper.arrayElementPointer(sa, JavaKind.Char, sp);
                    ValueNode dst = helper.arrayElementPointer(da, JavaKind.Byte, dp);
                    b.addPush(JavaKind.Int, new EncodeArrayNode(src, dst, len, LIRGeneratorTool.CharsetName.ASCII, JavaKind.Char));
                    boolean bl = true;
                    return bl;
                }
            }
        });
        r.register(new InvocationPlugin("countPositives", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode ba, ValueNode off, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    helper.intrinsicRangeCheck(off, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(len, Condition.LT, ConstantNode.forInt(0));
                    ValueNode arrayLength = b.add(new ArrayLengthNode(ba));
                    ValueNode limit = b.add(AddNode.create(off, len, NodeView.DEFAULT));
                    helper.intrinsicRangeCheck(arrayLength, Condition.LT, limit);
                    ValueNode array = helper.arrayElementPointer(ba, JavaKind.Byte, off);
                    b.addPush(JavaKind.Int, new CountPositivesNode(array, len));
                    boolean bl = true;
                    return bl;
                }
            }
        });
        r = new InvocationPlugins.Registration(plugins, "sun.nio.cs.ISO_8859_1$Encoder", replacements);
        r.register(new InvocationPlugin("implEncodeISOArray", new Type[]{char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sa, ValueNode sp, ValueNode da, ValueNode dp, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode src = helper.arrayElementPointer(sa, JavaKind.Char, sp);
                    ValueNode dst = helper.arrayElementPointer(da, JavaKind.Byte, dp);
                    b.addPush(JavaKind.Int, new EncodeArrayNode(src, dst, len, LIRGeneratorTool.CharsetName.ISO_8859_1, JavaKind.Char));
                    boolean bl = true;
                    return bl;
                }
            }
        });
    }

    static {
        Field coder = null;
        try {
            STRING_VALUE_FIELD = String.class.getDeclaredField("value");
            coder = String.class.getDeclaredField("coder");
        }
        catch (NoSuchFieldException e) {
            throw new GraalError(e);
        }
        STRING_CODER_FIELD = coder;
        DIRECTIVE_SPECULATIONS = new SpeculationReasonGroup("GraalDirective", BytecodePosition.class);
    }

    static class StringEqualsInvocationPlugin
    extends InvocationPlugin {
        StringEqualsInvocationPlugin() {
            super("equals", new Type[]{InvocationPlugin.Receiver.class, Object.class});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode other) {
            if (!b.canMergeIntrinsicReturns()) {
                return false;
            }
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ConstantNode trueValue = ConstantNode.forBoolean(true);
                ConstantNode falseValue = ConstantNode.forBoolean(false);
                ConstantNode arrayBaseOffset = ConstantNode.forLong(b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte), b.getGraph());
                ValueNode thisString = receiver.get();
                helper.emitReturnIf(b.add(new ObjectEqualsNode(thisString, other)), trueValue, 0.010000000000000009);
                TypeReference stringType = TypeReference.createTrusted(b.getAssumptions(), b.getMetaAccess().lookupJavaType(String.class));
                AbstractBeginNode stringArg2Guard = helper.emitReturnIfNot(InstanceOfNode.create(stringType, other), b.add(falseValue), 0.010000000000000009);
                ObjectStamp stamp = StampFactory.objectNonNull(stringType);
                ValueNode otherString = b.add(new PiNode(other, (Stamp)stamp, stringArg2Guard.asNode()));
                ResolvedJavaField coderField = b.getMetaAccess().lookupJavaField(STRING_CODER_FIELD);
                ValueNode thisCoder = helper.loadField(thisString, coderField);
                ValueNode thatCoder = helper.loadField(otherString, coderField);
                helper.emitReturnIfNot(b.add(new IntegerEqualsNode(thisCoder, thatCoder)), falseValue, 0.010000000000000009);
                ResolvedJavaField valueField = b.getMetaAccess().lookupJavaField(STRING_VALUE_FIELD);
                ValueNode thisValue = b.nullCheckedValue(helper.loadField(otherString, valueField));
                ValueNode thatValue = b.nullCheckedValue(helper.loadField(thisString, valueField));
                ValueNode thisLength = helper.arraylength(thisValue);
                ValueNode thatLength = helper.arraylength(thatValue);
                helper.emitReturnIfNot(IntegerEqualsNode.create(thisLength, thatLength, NodeView.DEFAULT), falseValue, 0.010000000000000009);
                helper.emitReturnIf(IntegerEqualsNode.create(thisLength, ConstantNode.forInt(0), NodeView.DEFAULT), trueValue, 0.010000000000000009);
                helper.emitFinalReturn(JavaKind.Boolean, b.append(new ArrayEqualsNode(thisValue, arrayBaseOffset, thatValue, arrayBaseOffset, thisLength.isConstant() ? thisLength : thatLength, JavaKind.Byte)));
            }
            return true;
        }
    }

    public static class ArrayEqualsInvocationPlugin
    extends InvocationPlugin {
        private final JavaKind kind;

        public ArrayEqualsInvocationPlugin(JavaKind kind, Type ... argumentTypes) {
            super("equals", argumentTypes);
            this.kind = kind;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
            if (!b.canMergeIntrinsicReturns()) {
                return false;
            }
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ConstantNode arrayBaseOffset = ConstantNode.forLong(b.getMetaAccess().getArrayBaseOffset(this.kind), b.getGraph());
                helper.emitReturnIf(b.add(new ObjectEqualsNode(arg1, arg2)), b.add(ConstantNode.forBoolean(true)), 0.010000000000000009);
                AbstractBeginNode nonNullArg1guard = helper.emitReturnIf(IsNullNode.create(arg1), b.add(ConstantNode.forBoolean(false)), 0.010000000000000009);
                AbstractBeginNode nonNullArg2guard = helper.emitReturnIf(IsNullNode.create(arg2), b.add(ConstantNode.forBoolean(false)), 0.010000000000000009);
                Stamp stamp1 = AbstractPointerStamp.pointerNonNull(arg1.stamp(NodeView.DEFAULT));
                ValueNode nonNullArg1 = b.add(new PiNode(arg1, stamp1, nonNullArg1guard.asNode()));
                ValueNode arg1Length = b.add(new ArrayLengthNode(nonNullArg1));
                Stamp stamp2 = AbstractPointerStamp.pointerNonNull(arg1.stamp(NodeView.DEFAULT));
                ValueNode nonNullArg2 = b.add(new PiNode(arg2, stamp2, nonNullArg2guard.asNode()));
                ValueNode arg2Length = b.add(new ArrayLengthNode(nonNullArg2));
                helper.emitReturnIfNot(IntegerEqualsNode.create(arg1Length, arg2Length, NodeView.DEFAULT), b.add(ConstantNode.forBoolean(false)), 0.99);
                helper.emitFinalReturn(JavaKind.Boolean, b.append(new ArrayEqualsNode(nonNullArg1, arrayBaseOffset, nonNullArg2, arrayBaseOffset, arg1Length, this.kind)));
            }
            return true;
        }
    }

    public static class AllocateUninitializedArrayPlugin
    extends InvocationPlugin {
        private final boolean lengthCheck;

        public AllocateUninitializedArrayPlugin(String name, boolean lengthCheck) {
            super(name, new Type[]{InvocationPlugin.Receiver.class, Class.class, Integer.TYPE});
            this.lengthCheck = lengthCheck;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode componentTypeNode, ValueNode lengthNode) {
            if (!componentTypeNode.isJavaConstant() || componentTypeNode.asJavaConstant().isNull()) {
                return false;
            }
            ResolvedJavaType componentType = b.getConstantReflection().asJavaType((Constant)componentTypeNode.asJavaConstant());
            if (componentType == null || !componentType.isPrimitive() || componentType.getJavaKind() == JavaKind.Void) {
                return false;
            }
            unsafe.get();
            ValueNode checkedLength = lengthNode;
            if (this.lengthCheck) {
                checkedLength = b.maybeEmitExplicitNegativeArraySizeCheck(lengthNode, BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH);
            }
            b.addPush(JavaKind.Object, new NewArrayNode(componentType, checkedLength, false));
            return true;
        }
    }

    public static class UnsafeCompareAndSwapPlugin
    extends UnsafeAccessPlugin {
        private final MemoryOrderMode memoryOrder;
        private final boolean isLogic;

        public UnsafeCompareAndSwapPlugin(JavaKind accessKind, MemoryOrderMode memoryOrder, boolean isLogic, boolean explicitUnsafeNullChecks, String name, Type ... argumentTypes) {
            super(accessKind, isLogic ? JavaKind.Boolean : accessKind, explicitUnsafeNullChecks, name, argumentTypes);
            this.memoryOrder = memoryOrder;
            this.isLogic = isLogic;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode expected, ValueNode newValue) {
            unsafe.get();
            if (this.isLogic) {
                this.createUnsafeAccess(object, b, (obj, loc) -> new UnsafeCompareAndSwapNode(obj, offset, expected, newValue, this.unsafeAccessKind, loc, this.memoryOrder));
            } else {
                this.createUnsafeAccess(object, b, (obj, loc) -> new UnsafeCompareAndExchangeNode(obj, offset, expected, newValue, this.unsafeAccessKind, loc, this.memoryOrder));
            }
            return true;
        }
    }

    public static class UnsafeGetPlugin
    extends UnsafeAccessPlugin {
        private final MemoryOrderMode memoryOrder;

        public UnsafeGetPlugin(JavaKind returnKind, boolean explicitUnsafeNullChecks, String name, Type ... argumentTypes) {
            this(returnKind, MemoryOrderMode.PLAIN, explicitUnsafeNullChecks, name, argumentTypes);
        }

        public UnsafeGetPlugin(JavaKind kind, MemoryOrderMode memoryOrder, boolean explicitUnsafeNullChecks, String name, Type ... argumentTypes) {
            super(kind, kind, explicitUnsafeNullChecks, name, argumentTypes);
            this.memoryOrder = memoryOrder;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode address) {
            unsafe.get();
            b.addPush(this.returnKind, new UnsafeMemoryLoadNode(address, this.unsafeAccessKind, NamedLocationIdentity.OFF_HEAP_LOCATION));
            b.getGraph().markUnsafeAccess();
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset) {
            if (this.memoryOrder == MemoryOrderMode.OPAQUE && StampTool.isPointerAlwaysNull(object)) {
                return this.apply(b, targetMethod, unsafe, offset);
            }
            unsafe.get();
            UnsafeAccessPlugin.UnsafeNodeConstructor unsafeNodeConstructor = (obj, loc) -> new RawLoadNode(obj, offset, this.unsafeAccessKind, loc, this.memoryOrder);
            this.createUnsafeAccess(object, b, unsafeNodeConstructor);
            return true;
        }
    }

    public static class UnsafePutPlugin
    extends UnsafeAccessPlugin {
        private final MemoryOrderMode memoryOrder;

        public UnsafePutPlugin(JavaKind kind, boolean explicitUnsafeNullChecks, String name, Type ... argumentTypes) {
            this(kind, MemoryOrderMode.PLAIN, explicitUnsafeNullChecks, name, argumentTypes);
        }

        private UnsafePutPlugin(JavaKind kind, MemoryOrderMode memoryOrder, boolean explicitUnsafeNullChecks, String name, Type ... argumentTypes) {
            super(kind, JavaKind.Void, explicitUnsafeNullChecks, name, argumentTypes);
            this.memoryOrder = memoryOrder;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode address, ValueNode value) {
            assert (this.memoryOrder == MemoryOrderMode.PLAIN || this.memoryOrder == MemoryOrderMode.OPAQUE) : "Barriers for address based Unsafe put is not supported.";
            unsafe.get();
            ValueNode maskedValue = b.maskSubWordValue(value, this.unsafeAccessKind);
            b.add(new UnsafeMemoryStoreNode(address, maskedValue, this.unsafeAccessKind, NamedLocationIdentity.OFF_HEAP_LOCATION));
            b.getGraph().markUnsafeAccess();
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode object, ValueNode offset, ValueNode value) {
            if (this.memoryOrder == MemoryOrderMode.OPAQUE && StampTool.isPointerAlwaysNull(object)) {
                return this.apply(b, targetMethod, unsafe, offset, value);
            }
            unsafe.get();
            ValueNode maskedValue = b.maskSubWordValue(value, this.unsafeAccessKind);
            this.createUnsafeAccess(object, b, (obj, loc) -> new RawStoreNode(obj, offset, maskedValue, this.unsafeAccessKind, loc, true, this.memoryOrder));
            return true;
        }
    }

    public static class UnsafeFencePlugin
    extends InvocationPlugin {
        private final MembarNode.FenceKind fence;

        public UnsafeFencePlugin(MembarNode.FenceKind fence, String name) {
            super(name, new Type[]{InvocationPlugin.Receiver.class});
            this.fence = fence;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe) {
            unsafe.get();
            b.add(new MembarNode(this.fence));
            return true;
        }
    }

    public static final class CacheWritebackPlugin
    extends InvocationPlugin {
        final boolean isPreSync;

        public CacheWritebackPlugin(boolean isPreSync, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.isPreSync = isPreSync;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode address) {
            unsafe.get();
            b.add(new CacheWritebackNode(address));
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe) {
            unsafe.get();
            b.add(new CacheWritebackSyncNode(this.isPreSync));
            return true;
        }
    }

    public static enum IntegerExactBinaryOp {
        INTEGER_ADD_EXACT,
        INTEGER_INCREMENT_EXACT,
        INTEGER_SUBTRACT_EXACT,
        INTEGER_DECREMENT_EXACT,
        INTEGER_MULTIPLY_EXACT;

    }

    static final class MathSqrtPlugin
    extends InvocationPlugin {
        MathSqrtPlugin() {
            super("sqrt", Double.TYPE);
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
            b.push(JavaKind.Double, b.append(SqrtNode.create(value, NodeView.DEFAULT)));
            return true;
        }
    }

    public static class UnsignedMathPlugin
    extends InvocationPlugin {
        private final Condition condition;

        public UnsignedMathPlugin(Condition condition, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.condition = condition;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
            Condition.CanonicalizedCondition canonical = this.condition.canonicalize();
            StructuredGraph graph = b.getGraph();
            ValueNode lhs = canonical.mustMirror() ? y : x;
            ValueNode rhs = canonical.mustMirror() ? x : y;
            ConstantNode trueValue = ConstantNode.forBoolean(!canonical.mustNegate(), graph);
            ConstantNode falseValue = ConstantNode.forBoolean(canonical.mustNegate(), graph);
            LogicNode compare = CompareNode.createCompareNode(graph, b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), null, canonical.getCanonicalCondition(), lhs, rhs, NodeView.DEFAULT);
            b.addPush(JavaKind.Boolean, new ConditionalNode(compare, trueValue, falseValue));
            return true;
        }
    }

    public static class BoxPlugin
    extends InvocationPlugin {
        private final JavaKind kind;
        static final Map<JavaKind, Class<?>> boxClassToCacheClass = new EnumMap(Map.of(JavaKind.Boolean, Boolean.class, JavaKind.Char, BoxingSnippets.Templates.getCacheClass(JavaKind.Char), JavaKind.Byte, BoxingSnippets.Templates.getCacheClass(JavaKind.Byte), JavaKind.Short, BoxingSnippets.Templates.getCacheClass(JavaKind.Short), JavaKind.Int, BoxingSnippets.Templates.getCacheClass(JavaKind.Int), JavaKind.Long, BoxingSnippets.Templates.getCacheClass(JavaKind.Long)));

        BoxPlugin(JavaKind kind) {
            super("valueOf", kind.toJavaClass());
            this.kind = kind;
        }

        private boolean isCacheTypeInitialized(MetaAccessProvider metaAccess) {
            ResolvedJavaType cacheType;
            Class<?> cacheClass = boxClassToCacheClass.get(this.kind);
            return cacheClass == null || (cacheType = metaAccess.lookupJavaType(cacheClass)).isInitialized();
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
            ResolvedJavaType resultType;
            MetaAccessProvider metaAccess = b.getMetaAccess();
            if (b.parsingIntrinsic()) {
                ResolvedJavaMethod rootMethod = b.getGraph().method();
                if (metaAccess.lookupJavaType(BoxingSnippets.class).isAssignableFrom(rootMethod.getDeclaringClass())) {
                    return false;
                }
            }
            if (!(resultType = metaAccess.lookupJavaType(this.kind.toBoxedJavaClass())).isInitialized() || !this.isCacheTypeInitialized(metaAccess)) {
                return false;
            }
            b.addPush(JavaKind.Object, BoxNode.create(value, resultType, this.kind));
            return true;
        }
    }

    public static class UnboxPlugin
    extends InvocationPlugin {
        private final JavaKind kind;

        UnboxPlugin(JavaKind kind) {
            super(kind.toJavaClass().getSimpleName() + "Value", new Type[]{InvocationPlugin.Receiver.class});
            this.kind = kind;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
            if (b.parsingIntrinsic()) {
                ResolvedJavaMethod rootMethod = b.getGraph().method();
                if (b.getMetaAccess().lookupJavaType(BoxingSnippets.class).isAssignableFrom(rootMethod.getDeclaringClass())) {
                    return false;
                }
            }
            ValueNode valueNode = UnboxNode.create(b.getMetaAccess(), b.getConstantReflection(), receiver.get(), this.kind);
            b.addPush(this.kind, valueNode);
            return true;
        }
    }

    static class DeoptimizePlugin
    extends InvocationPlugin.RequiredInlineOnlyInvocationPlugin {
        private final SnippetReflectionProvider snippetReflection;
        private final DeoptimizationAction action;
        private final DeoptimizationReason reason;
        private final Boolean withSpeculation;

        DeoptimizePlugin(SnippetReflectionProvider snippetReflection, DeoptimizationAction action, DeoptimizationReason reason, Boolean withSpeculation, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.snippetReflection = snippetReflection;
            this.action = action;
            this.reason = reason;
            this.withSpeculation = withSpeculation;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
            DeoptimizePlugin.add(b, this.action, this.reason, this.withSpeculation);
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode actionValue, ValueNode reasonValue, ValueNode speculationValue) {
            DeoptimizationAction deoptAction = this.asConstant(DeoptimizationAction.class, actionValue);
            DeoptimizationReason deoptReason = this.asConstant(DeoptimizationReason.class, reasonValue);
            JavaConstant javaConstant = Objects.requireNonNull(speculationValue.asJavaConstant(), speculationValue + " must be a non-null compile time constant");
            if (javaConstant.getJavaKind().isObject()) {
                SpeculationLog.SpeculationReason speculationReason = this.snippetReflection.asObject(SpeculationLog.SpeculationReason.class, javaConstant);
                DeoptimizePlugin.add(b, deoptAction, deoptReason, speculationReason);
            } else {
                boolean speculation = javaConstant.asInt() != 0;
                DeoptimizePlugin.add(b, deoptAction, deoptReason, speculation);
            }
            return true;
        }

        private <T> T asConstant(Class<T> type, ValueNode value) {
            return Objects.requireNonNull(this.snippetReflection.asObject(type, value.asJavaConstant()), value + " must be a non-null compile time constant");
        }

        static void add(GraphBuilderContext b, DeoptimizationAction action, DeoptimizationReason reason, boolean withSpeculation) {
            SpeculationLog.SpeculationReason speculationReason = null;
            if (withSpeculation) {
                BytecodePosition pos = new BytecodePosition(null, b.getMethod(), b.bci());
                speculationReason = DIRECTIVE_SPECULATIONS.createSpeculationReason(pos);
            }
            DeoptimizePlugin.add(b, action, reason, speculationReason);
        }

        static void add(GraphBuilderContext b, DeoptimizationAction action, DeoptimizationReason reason, SpeculationLog.SpeculationReason speculationReason) {
            SpeculationLog.Speculation speculation = SpeculationLog.NO_SPECULATION;
            if (speculationReason != null) {
                GraalError.guarantee(b.getGraph().getSpeculationLog() != null, "A speculation log is needed to use `deoptimize with speculation`");
                if (b.getGraph().getSpeculationLog().maySpeculate(speculationReason)) {
                    speculation = b.getGraph().getSpeculationLog().speculate(speculationReason);
                }
            }
            b.add(new DeoptimizeNode(action, reason, speculation));
        }
    }

    private static class CheckIndexPlugin
    extends InvocationPlugin.InlineOnlyInvocationPlugin {
        private JavaKind kind;

        CheckIndexPlugin(Type type) {
            super("checkIndex", new Type[]{type, type, BiFunction.class});
            assert (type == Integer.TYPE || type == Long.TYPE);
            this.kind = type == Integer.TYPE ? JavaKind.Int : JavaKind.Long;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode index, ValueNode length, ValueNode oobef) {
            LogicNode rangeCheck;
            if (b.needsExplicitException()) {
                return false;
            }
            ValueNode checkedIndex = index;
            ValueNode checkedLength = length;
            LogicNode lengthNegative = IntegerLessThanNode.create(length, ConstantNode.defaultForKind(this.kind), NodeView.DEFAULT);
            if (!lengthNegative.isContradiction()) {
                FixedGuardNode guard = b.append(new FixedGuardNode(lengthNegative, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateRecompile, true));
                IntegerStamp positiveInt = StampFactory.forInteger(this.kind, 0L, this.kind.getMaxValue(), 0L, this.kind.getMaxValue());
                checkedLength = PiNode.create(length, length.stamp(NodeView.DEFAULT).improveWith(positiveInt), guard);
            }
            if (!(rangeCheck = IntegerBelowNode.create(index, checkedLength, NodeView.DEFAULT)).isTautology()) {
                FixedGuardNode guard = b.append(new FixedGuardNode(rangeCheck, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateRecompile));
                long upperBound = Math.max(0L, ((IntegerStamp)checkedLength.stamp(NodeView.DEFAULT)).upperBound() - 1L);
                checkedIndex = PiNode.create(index, index.stamp(NodeView.DEFAULT).improveWith(StampFactory.forInteger(this.kind, 0L, upperBound)), guard);
            }
            b.addPush(this.kind, checkedIndex);
            return true;
        }
    }

    public static class AESCryptPlugin
    extends AESCryptPluginBase {
        public static final int AES_BLOCK_SIZE_IN_BYTES = 16;

        public AESCryptPlugin(AESNode.CryptMode mode) {
            super(mode, mode.isEncrypt() ? "implEncryptBlock" : "implDecryptBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ValueNode nonNullReceiver = receiver.get();
                ValueNode nonNullIn = b.nullCheckedValue(in);
                ValueNode nonNullOut = b.nullCheckedValue(out);
                ConstantNode zero = ConstantNode.forInt(0);
                helper.intrinsicRangeCheck(inOffset, Condition.LT, zero);
                ValueNode inLength = helper.length(nonNullIn);
                helper.intrinsicRangeCheck(helper.sub(inLength, ConstantNode.forInt(16)), Condition.LT, inOffset);
                helper.intrinsicRangeCheck(outOffset, Condition.LT, zero);
                ValueNode outLength = helper.length(nonNullOut);
                helper.intrinsicRangeCheck(helper.sub(outLength, ConstantNode.forInt(16)), Condition.LT, outOffset);
                ValueNode inAddr = helper.arrayElementPointer(nonNullIn, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(nonNullOut, JavaKind.Byte, outOffset);
                ValueNode kAddr = AESCryptPlugin.readFieldArrayStart(b, helper, targetMethod.getDeclaringClass(), "K", nonNullReceiver, JavaKind.Int);
                b.add(new AESNode(inAddr, outAddr, kAddr, this.mode));
            }
            return true;
        }
    }

    public static class GHASHPlugin
    extends InvocationPlugin {
        public GHASHPlugin() {
            super("processBlocks", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, long[].class, long[].class});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode data, ValueNode inOffset, ValueNode blocks, ValueNode state, ValueNode hashSubkey) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ValueNode dataAddress = helper.arrayElementPointer(data, JavaKind.Byte, inOffset);
                ValueNode stateAddress = helper.arrayStart(state, JavaKind.Long);
                ValueNode hashSubkeyAddress = helper.arrayStart(hashSubkey, JavaKind.Long);
                b.add(new GHASHProcessBlocksNode(stateAddress, hashSubkeyAddress, dataAddress, blocks));
                boolean bl = true;
                return bl;
            }
        }
    }

    public static class MessageDigestPlugin
    extends InvocationPlugin {
        private final MessageDigestSupplier supplier;

        public MessageDigestPlugin(MessageDigestSupplier supplier) {
            super("implCompress0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE});
            this.supplier = supplier;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode buf, ValueNode ofs) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType receiverType = targetMethod.getDeclaringClass();
                ResolvedJavaField stateField = helper.getField(receiverType, "state");
                ValueNode nonNullReceiver = receiver.get();
                ValueNode bufStart = helper.arrayElementPointer(buf, JavaKind.Byte, ofs);
                ValueNode state = helper.loadField(nonNullReceiver, stateField);
                ValueNode stateStart = helper.arrayStart(state, this.getStateElementType());
                b.add(this.supplier.create(bufStart, stateStart));
                boolean bl = true;
                return bl;
            }
        }

        protected JavaKind getStateElementType() {
            return JavaKind.Int;
        }

        public static interface MessageDigestSupplier {
            public MessageDigestNode create(ValueNode var1, ValueNode var2);
        }
    }

    public static abstract class CipherBlockChainingCryptPlugin
    extends AESCryptDelegatePlugin {
        public CipherBlockChainingCryptPlugin(AESNode.CryptMode mode) {
            super(mode, mode.isEncrypt() ? "implEncrypt" : "implDecrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        protected abstract boolean canApply(GraphBuilderContext var1);

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode inLength, ValueNode out, ValueNode outOffset) {
            if (!this.canApply(b)) {
                return false;
            }
            InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);
            try {
                ResolvedJavaType receiverType = targetMethod.getDeclaringClass();
                ResolvedJavaType typeAESCrypt = this.getTypeAESCrypt(b.getMetaAccess(), receiverType);
                ValueNode nonNullReceiver = receiver.get();
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode kAddr = this.readEmbeddedAESCryptKArrayStart(b, helper, receiverType, typeAESCrypt, nonNullReceiver);
                ValueNode rAddr = CipherBlockChainingCryptPlugin.readFieldArrayStart(b, helper, receiverType, "r", nonNullReceiver, JavaKind.Byte);
                CipherBlockChainingAESNode call = new CipherBlockChainingAESNode(inAddr, outAddr, kAddr, rAddr, inLength, this.mode);
                helper.emitFinalReturn(JavaKind.Int, call);
                boolean bl = true;
                helper.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        helper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        }
    }

    public static abstract class CounterModeCryptPlugin
    extends AESCryptDelegatePlugin {
        public CounterModeCryptPlugin() {
            super(AESNode.CryptMode.ENCRYPT, "implCrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        protected abstract boolean canApply(GraphBuilderContext var1);

        protected abstract ValueNode getFieldOffset(GraphBuilderContext var1, ResolvedJavaField var2);

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode out, ValueNode outOffset) {
            if (!this.canApply(b)) {
                return false;
            }
            InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);
            try {
                ResolvedJavaType receiverType = targetMethod.getDeclaringClass();
                ResolvedJavaType typeAESCrypt = this.getTypeAESCrypt(b.getMetaAccess(), receiverType);
                ResolvedJavaField used = helper.getField(receiverType, "used");
                ValueNode usedOffset = this.getFieldOffset(b, used);
                ValueNode nonNullReceiver = receiver.get();
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode kAddr = this.readEmbeddedAESCryptKArrayStart(b, helper, receiverType, typeAESCrypt, nonNullReceiver);
                ValueNode counterAddr = CounterModeCryptPlugin.readFieldArrayStart(b, helper, receiverType, "counter", nonNullReceiver, JavaKind.Byte);
                ValueNode encryptedCounterAddr = CounterModeCryptPlugin.readFieldArrayStart(b, helper, receiverType, "encryptedCounter", nonNullReceiver, JavaKind.Byte);
                ValueNode usedPtr = b.add(new ComputeObjectAddressNode(nonNullReceiver, helper.asWord(usedOffset)));
                CounterModeAESNode counterModeAESNode = new CounterModeAESNode(inAddr, outAddr, kAddr, counterAddr, len, encryptedCounterAddr, usedPtr);
                helper.emitFinalReturn(JavaKind.Int, counterModeAESNode);
                boolean bl = true;
                helper.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        helper.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        }
    }

    public static abstract class AESCryptDelegatePlugin
    extends AESCryptPluginBase {
        public AESCryptDelegatePlugin(AESNode.CryptMode mode, String name, Type ... argumentTypes) {
            super(mode, name, argumentTypes);
        }

        protected abstract ResolvedJavaType getTypeAESCrypt(MetaAccessProvider var1, ResolvedJavaType var2) throws ClassNotFoundException;

        public ValueNode readEmbeddedAESCryptKArrayStart(GraphBuilderContext b, InvocationPluginHelper helper, ResolvedJavaType receiverType, ResolvedJavaType typeAESCrypt, ValueNode receiver) {
            ResolvedJavaField embeddedCipherField = helper.getField(receiverType, "embeddedCipher");
            ValueNode embeddedCipher = b.nullCheckedValue(helper.loadField(receiver, embeddedCipherField));
            LogicNode typeCheck = InstanceOfNode.create(TypeReference.create(b.getAssumptions(), typeAESCrypt), embeddedCipher);
            helper.doFallbackIfNot(typeCheck, 0.25);
            return AESCryptDelegatePlugin.readFieldArrayStart(b, helper, typeAESCrypt, "K", embeddedCipher, JavaKind.Int);
        }
    }

    public static abstract class AESCryptPluginBase
    extends InvocationPlugin {
        protected final AESNode.CryptMode mode;

        public AESCryptPluginBase(AESNode.CryptMode mode, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.mode = mode;
        }

        public static ValueNode readFieldArrayStart(GraphBuilderContext b, InvocationPluginHelper helper, ResolvedJavaType klass, String fieldName, ValueNode receiver, JavaKind arrayKind) {
            ResolvedJavaField field = helper.getField(klass, fieldName);
            ValueNode array = b.nullCheckedValue(helper.loadField(receiver, field));
            return helper.arrayStart(array, arrayKind);
        }
    }

    public static abstract class UnsafeAccessPlugin
    extends InvocationPlugin {
        protected final JavaKind unsafeAccessKind;
        protected final JavaKind returnKind;
        private final boolean explicitUnsafeNullChecks;

        public UnsafeAccessPlugin(JavaKind unsafeAccessKind, JavaKind returnKind, boolean explicitUnsafeNullChecks, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.unsafeAccessKind = unsafeAccessKind;
            this.returnKind = returnKind;
            this.explicitUnsafeNullChecks = explicitUnsafeNullChecks;
        }

        private static FixedWithNextNode createObjectAccessNode(ValueNode value, UnsafeNodeConstructor nodeConstructor) {
            return nodeConstructor.create(value, LocationIdentity.ANY_LOCATION);
        }

        private static FixedWithNextNode createMemoryAccessNode(StructuredGraph graph, UnsafeNodeConstructor nodeConstructor) {
            return nodeConstructor.create(ConstantNode.forLong(0L, graph), NamedLocationIdentity.OFF_HEAP_LOCATION);
        }

        private void setAccessNodeResult(FixedWithNextNode node, GraphBuilderContext b) {
            if (this.returnKind != JavaKind.Void) {
                b.addPush(this.returnKind, node);
            } else {
                b.add(node);
            }
        }

        protected final void createUnsafeAccess(ValueNode value, GraphBuilderContext b, UnsafeNodeConstructor nodeConstructor) {
            StructuredGraph graph = b.getGraph();
            graph.markUnsafeAccess();
            if (this.unsafeAccessKind == JavaKind.Object) {
                ValueNode object = value;
                if (this.explicitUnsafeNullChecks) {
                    object = b.nullCheckedValue(object);
                }
                this.setAccessNodeResult(UnsafeAccessPlugin.createObjectAccessNode(object, nodeConstructor), b);
            } else if (StampTool.isPointerAlwaysNull(value)) {
                this.setAccessNodeResult(UnsafeAccessPlugin.createMemoryAccessNode(graph, nodeConstructor), b);
            } else if (!this.explicitUnsafeNullChecks || StampTool.isPointerNonNull(value)) {
                this.setAccessNodeResult(UnsafeAccessPlugin.createObjectAccessNode(value, nodeConstructor), b);
            } else {
                PiNode nonNullObject = graph.addWithoutUnique(new PiNode(value, StampFactory.objectNonNull()));
                FixedWithNextNode objectAccess = graph.add(UnsafeAccessPlugin.createObjectAccessNode(nonNullObject, nodeConstructor));
                FixedWithNextNode memoryAccess = graph.add(UnsafeAccessPlugin.createMemoryAccessNode(graph, nodeConstructor));
                ValueNode[] accessNodes = new FixedWithNextNode[]{objectAccess, memoryAccess};
                LogicNode condition = graph.addOrUniqueWithInputs(IsNullNode.create(value));
                ProfileData.BranchProbabilityData probability = ProfileData.BranchProbabilityData.injected(0.5, true);
                IfNode ifNode = b.add(new IfNode(condition, memoryAccess, objectAccess, probability));
                nonNullObject.setGuard(ifNode.falseSuccessor());
                MergeNode merge = b.append(new MergeNode());
                for (FixedWithNextNode fixedWithNextNode : accessNodes) {
                    EndNode endNode = graph.add(new EndNode());
                    fixedWithNextNode.setNext(endNode);
                    if (fixedWithNextNode instanceof StateSplit) {
                        if (this.returnKind != JavaKind.Void) {
                            b.push(this.returnKind, fixedWithNextNode);
                        }
                        b.setStateAfter((StateSplit)((Object)fixedWithNextNode));
                        if (this.returnKind != JavaKind.Void) {
                            ValueNode popped = b.pop(this.returnKind);
                            assert (popped == fixedWithNextNode);
                        }
                    }
                    merge.addForwardEnd(endNode);
                }
                if (this.returnKind != JavaKind.Void) {
                    ValuePhiNode phi = new ValuePhiNode(objectAccess.stamp(NodeView.DEFAULT), merge, accessNodes);
                    b.push(this.returnKind, graph.addOrUnique(phi));
                }
                b.setStateAfter(merge);
            }
        }

        @FunctionalInterface
        public static interface UnsafeNodeConstructor {
            public FixedWithNextNode create(ValueNode var1, LocationIdentity var2);
        }
    }

    public static abstract class ReachabilityFencePlugin
    extends InvocationPlugin {
        protected ReachabilityFencePlugin() {
            super("reachabilityFence", new Type[]{Object.class});
        }

        @Override
        public final boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode value) {
            if (this.useExplicitReachabilityFence(b)) {
                b.add(ReachabilityFenceNode.create(value));
            }
            return true;
        }

        protected abstract boolean useExplicitReachabilityFence(GraphBuilderContext var1);
    }
}

