/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.ForeignCalls;
import org.graalvm.word.Pointer;

public final class ArrayCompareToForeignCalls {
    private static final ForeignCallDescriptor STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY = ArrayCompareToForeignCalls.foreignCallDescriptor("byteArrayCompareToByteArray");
    private static final ForeignCallDescriptor STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY = ArrayCompareToForeignCalls.foreignCallDescriptor("byteArrayCompareToCharArray");
    private static final ForeignCallDescriptor STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY = ArrayCompareToForeignCalls.foreignCallDescriptor("charArrayCompareToByteArray");
    private static final ForeignCallDescriptor STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY = ArrayCompareToForeignCalls.foreignCallDescriptor("charArrayCompareToCharArray");
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY, STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY, STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY, STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY};

    private static ForeignCallDescriptor foreignCallDescriptor(String name) {
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Integer.TYPE, Pointer.class, Integer.TYPE, Pointer.class, Integer.TYPE);
    }

    public static ForeignCallDescriptor getStub(ArrayCompareToNode arrayCompareToNode) {
        Stride strideA = arrayCompareToNode.getStrideA();
        Stride strideB = arrayCompareToNode.getStrideB();
        if (strideA == Stride.S1) {
            if (strideB == Stride.S1) {
                return STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY;
            }
            if (strideB == Stride.S2) {
                return STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY;
            }
        } else if (strideA == Stride.S2) {
            if (strideB == Stride.S1) {
                return STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY;
            }
            if (strideB == Stride.S2) {
                return STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY;
            }
        }
        throw GraalError.shouldNotReachHere(strideA + " " + strideB);
    }
}

