/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class ArrayIndexOfNode
extends PureFunctionStubIntrinsicNode
implements Canonicalizable {
    public static final NodeClass<ArrayIndexOfNode> TYPE = NodeClass.create(ArrayIndexOfNode.class);
    private final Stride stride;
    private final LIRGeneratorTool.ArrayIndexOfVariant variant;
    @Node.Input
    private ValueNode arrayPointer;
    @Node.Input
    private ValueNode arrayOffset;
    @Node.Input
    private ValueNode arrayLength;
    @Node.Input
    private ValueNode fromIndex;
    @Node.Input
    private NodeInputList<ValueNode> searchValues;

    public ArrayIndexOfNode(@Node.ConstantNodeParameter Stride stride, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant variant, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stride, variant, null, LocationIdentity.any(), arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(@Node.ConstantNodeParameter Stride stride, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant variant, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stride, variant, runtimeCheckedCPUFeatures, LocationIdentity.any(), arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter Stride stride, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant variant, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stride, variant, null, NamedLocationIdentity.getArrayLocation(arrayKind), arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, stride, variant, runtimeCheckedCPUFeatures, locationIdentity, arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(NodeClass<? extends ArrayIndexOfNode> c, Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        super(c, StampFactory.forKind(JavaKind.Int), runtimeCheckedCPUFeatures, locationIdentity);
        GraalError.guarantee(stride.value <= 4, "unsupported stride");
        GraalError.guarantee(variant != LIRGeneratorTool.ArrayIndexOfVariant.MatchAny || searchValues.length > 0 && searchValues.length <= 4, "indexOfAny requires 1 - 4 search values");
        GraalError.guarantee(variant != LIRGeneratorTool.ArrayIndexOfVariant.MatchRange || searchValues.length == 2 || searchValues.length == 4, "indexOfRange requires exactly two or four search values");
        GraalError.guarantee(variant != LIRGeneratorTool.ArrayIndexOfVariant.WithMask || searchValues.length == 2, "indexOf with mask requires exactly two search values");
        GraalError.guarantee(variant != LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive || searchValues.length == 2, "findTwoConsecutive without mask requires exactly two search values");
        GraalError.guarantee(variant != LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask || searchValues.length == 4, "findTwoConsecutive with mask requires exactly four search values");
        this.stride = stride;
        this.variant = variant;
        this.arrayPointer = arrayPointer;
        this.arrayOffset = arrayOffset;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValues = new NodeInputList((Node)this, (Node[])searchValues);
    }

    public static ArrayIndexOfNode createIndexOfSingle(GraphBuilderContext b, JavaKind arrayKind, Stride stride, ValueNode array, ValueNode arrayLength, ValueNode fromIndex, ValueNode searchValue) {
        ConstantNode baseOffset = ConstantNode.forLong(b.getMetaAccess().getArrayBaseOffset(arrayKind), b.getGraph());
        return new ArrayIndexOfNode(TYPE, stride, LIRGeneratorTool.ArrayIndexOfVariant.MatchAny, null, ArrayIndexOfNode.defaultLocationIdentity(arrayKind), array, (ValueNode)baseOffset, arrayLength, fromIndex, searchValue);
    }

    private static LocationIdentity defaultLocationIdentity(JavaKind arrayKind) {
        return arrayKind == JavaKind.Void ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(arrayKind);
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64(Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant) {
        switch (variant) {
            case MatchAny: 
            case WithMask: 
            case FindTwoConsecutive: 
            case FindTwoConsecutiveWithMask: {
                return EnumSet.of(AMD64.CPUFeature.SSE2);
            }
            case MatchRange: {
                if (stride == Stride.S1) {
                    return EnumSet.of(AMD64.CPUFeature.SSE2);
                }
                return ArrayIndexOfNode.amd64FeaturesSSE41();
            }
            case Table: {
                return ArrayIndexOfNode.amd64FeaturesSSE41();
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)variant);
    }

    public static EnumSet<AMD64.CPUFeature> amd64FeaturesSSE41() {
        return EnumSet.of(AMD64.CPUFeature.SSE2, AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1);
    }

    public static EnumSet<AArch64.CPUFeature> aarch64FeaturesNone() {
        return EnumSet.noneOf(AArch64.CPUFeature.class);
    }

    public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
        return EnumSet.noneOf(AArch64.CPUFeature.class);
    }

    static boolean isSupported(Architecture arch, Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant) {
        return arch instanceof AMD64 && ((AMD64)arch).getFeatures().containsAll(ArrayIndexOfNode.minFeaturesAMD64(stride, variant)) || arch instanceof AArch64 && ((AArch64)arch).getFeatures().containsAll(ArrayIndexOfNode.minFeaturesAARCH64());
    }

    public LIRGeneratorTool.ArrayIndexOfVariant getVariant() {
        return this.variant;
    }

    public ValueNode getArrayPointer() {
        return this.arrayPointer;
    }

    public ValueNode getArrayOffset() {
        return this.arrayOffset;
    }

    public ValueNode getArrayLength() {
        return this.arrayLength;
    }

    public ValueNode getFromIndex() {
        return this.fromIndex;
    }

    public NodeInputList<ValueNode> getSearchValues() {
        return this.searchValues;
    }

    public int getNumberOfValues() {
        return this.searchValues.size();
    }

    public Stride getStride() {
        return this.stride;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return ArrayIndexOfForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        ValueNode[] args = new ValueNode[4 + this.searchValues.size()];
        args[0] = this.arrayPointer;
        args[1] = this.arrayOffset;
        args[2] = this.arrayLength;
        args[3] = this.fromIndex;
        for (int i = 0; i < this.searchValues.size(); ++i) {
            args[4 + i] = (ValueNode)this.searchValues.get(i);
        }
        return args;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayIndexOf(this.stride, this.variant, this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayPointer), gen.operand(this.arrayOffset), gen.operand(this.arrayLength), gen.operand(this.fromIndex), this.searchValuesAsOperands(gen)));
    }

    protected int getArrayBaseOffset(MetaAccessProvider metaAccessProvider, ValueNode array, JavaKind kind) {
        return metaAccessProvider.getArrayBaseOffset(kind);
    }

    private Value[] searchValuesAsOperands(NodeLIRBuilderTool gen) {
        Value[] searchValueOperands = new Value[this.searchValues.size()];
        for (int i = 0; i < this.searchValues.size(); ++i) {
            searchValueOperands[i] = gen.operand((Node)this.searchValues.get(i));
        }
        return searchValueOperands;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
            return this;
        }
        if (this.arrayPointer.isJavaConstant() && ((ConstantNode)this.arrayPointer).getStableDimension() > 0 && this.arrayOffset.isJavaConstant() && this.arrayLength.isJavaConstant() && this.fromIndex.isJavaConstant() && this.searchValuesConstant()) {
            int i;
            ConstantReflectionProvider provider = tool.getConstantReflection();
            JavaConstant arrayConstant = this.arrayPointer.asJavaConstant();
            JavaKind constantArrayKind = this.arrayPointer.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
            int actualArrayLength = provider.readArrayLength(arrayConstant);
            long arrayBaseOffsetBytesConstant = this.arrayOffset.asJavaConstant().asLong();
            long arrayOffsetConstant = (arrayBaseOffsetBytesConstant -= (long)this.getArrayBaseOffset(tool.getMetaAccess(), this.arrayPointer, constantArrayKind)) / (long)this.stride.value;
            int arrayLengthConstant = this.arrayLength.asJavaConstant().asInt();
            assert (arrayLengthConstant * this.stride.value <= actualArrayLength * constantArrayKind.getByteCount());
            int fromIndexConstant = this.fromIndex.asJavaConstant().asInt();
            int[] valuesConstant = new int[this.searchValues.size()];
            for (i = 0; i < this.searchValues.size(); ++i) {
                valuesConstant[i] = ((ValueNode)this.searchValues.get(i)).asJavaConstant().asInt();
            }
            if (arrayLengthConstant * this.stride.value < GraalOptions.StringIndexOfConstantLimit.getValue(tool.getOptions())) {
                switch (this.variant) {
                    case MatchAny: {
                        for (i = fromIndexConstant; i < arrayLengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                            for (int searchValue : valuesConstant) {
                                if (value != searchValue) continue;
                                return ConstantNode.forInt(i);
                            }
                        }
                        break;
                    }
                    case MatchRange: {
                        for (i = fromIndexConstant; i < arrayLengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                            for (int j = 0; j < valuesConstant.length; j += 2) {
                                if (valuesConstant[j] > value || value > valuesConstant[j + 1]) continue;
                                return ConstantNode.forInt(i);
                            }
                        }
                        break;
                    }
                    case WithMask: {
                        for (i = fromIndexConstant; i < arrayLengthConstant; ++i) {
                            int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                            if ((value | valuesConstant[1]) != valuesConstant[0]) continue;
                            return ConstantNode.forInt(i);
                        }
                        break;
                    }
                    case FindTwoConsecutive: {
                        for (i = fromIndexConstant; i < arrayLengthConstant - 1; ++i) {
                            int v0 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                            int v1 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i + 1L));
                            if (v0 != valuesConstant[0] || v1 != valuesConstant[1]) continue;
                            return ConstantNode.forInt(i);
                        }
                        break;
                    }
                    case FindTwoConsecutiveWithMask: {
                        for (i = fromIndexConstant; i < arrayLengthConstant - 1; ++i) {
                            int v0 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                            int v1 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i + 1L));
                            if ((v0 | valuesConstant[2]) != valuesConstant[0] || (v1 | valuesConstant[3]) != valuesConstant[1]) continue;
                            return ConstantNode.forInt(i);
                        }
                        break;
                    }
                }
                return ConstantNode.forInt(-1);
            }
        }
        return this;
    }

    private boolean searchValuesConstant() {
        for (ValueNode s : this.searchValues) {
            if (s.isJavaConstant()) continue;
            return false;
        }
        return true;
    }

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var2, Object var3, long var4, int var6, int var7, int var8);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter Stride var1, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var2, Object var3, long var4, int var6, int var7, int var8, int var9);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf1S1", parameters={"S1", "MatchAny"}), @GenerateStub(name="indexOf1S2", parameters={"S2", "MatchAny"}), @GenerateStub(name="indexOf1S4", parameters={"S4", "MatchAny"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, Object var2, long var3, int var5, int var6, int var7);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, @Node.ConstantNodeParameter EnumSet<?> var2, Object var3, long var4, int var6, int var7, int var8);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf2S1", parameters={"S1", "MatchAny"}), @GenerateStub(name="indexOf2S2", parameters={"S2", "MatchAny"}), @GenerateStub(name="indexOf2S4", parameters={"S4", "MatchAny"}), @GenerateStub(name="indexOfRange1S1", parameters={"S1", "MatchRange"}), @GenerateStub(name="indexOfRange1S2", parameters={"S2", "MatchRange"}, minimumCPUFeaturesAMD64="amd64FeaturesSSE41", minimumCPUFeaturesAARCH64="aarch64FeaturesNone"), @GenerateStub(name="indexOfRange1S4", parameters={"S4", "MatchRange"}, minimumCPUFeaturesAMD64="amd64FeaturesSSE41", minimumCPUFeaturesAARCH64="aarch64FeaturesNone"), @GenerateStub(name="indexOfWithMaskS1", parameters={"S1", "WithMask"}), @GenerateStub(name="indexOfWithMaskS2", parameters={"S2", "WithMask"}), @GenerateStub(name="indexOfWithMaskS4", parameters={"S4", "WithMask"}), @GenerateStub(name="indexOfTwoConsecutiveS1", parameters={"S1", "FindTwoConsecutive"}), @GenerateStub(name="indexOfTwoConsecutiveS2", parameters={"S2", "FindTwoConsecutive"}), @GenerateStub(name="indexOfTwoConsecutiveS4", parameters={"S4", "FindTwoConsecutive"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, Object var2, long var3, int var5, int var6, int var7, int var8);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, @Node.ConstantNodeParameter EnumSet<?> var2, Object var3, long var4, int var6, int var7, int var8, int var9);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf3S1", parameters={"S1", "MatchAny"}), @GenerateStub(name="indexOf3S2", parameters={"S2", "MatchAny"}), @GenerateStub(name="indexOf3S4", parameters={"S4", "MatchAny"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, Object var2, long var3, int var5, int var6, int var7, int var8, int var9);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, @Node.ConstantNodeParameter EnumSet<?> var2, Object var3, long var4, int var6, int var7, int var8, int var9, int var10);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOf4S1", parameters={"S1", "MatchAny"}), @GenerateStub(name="indexOf4S2", parameters={"S2", "MatchAny"}), @GenerateStub(name="indexOf4S4", parameters={"S4", "MatchAny"}), @GenerateStub(name="indexOfRange2S1", parameters={"S1", "MatchRange"}), @GenerateStub(name="indexOfRange2S2", parameters={"S2", "MatchRange"}, minimumCPUFeaturesAMD64="amd64FeaturesSSE41", minimumCPUFeaturesAARCH64="aarch64FeaturesNone"), @GenerateStub(name="indexOfRange2S4", parameters={"S4", "MatchRange"}, minimumCPUFeaturesAMD64="amd64FeaturesSSE41", minimumCPUFeaturesAARCH64="aarch64FeaturesNone"), @GenerateStub(name="indexOfTwoConsecutiveWithMaskS1", parameters={"S1", "FindTwoConsecutiveWithMask"}), @GenerateStub(name="indexOfTwoConsecutiveWithMaskS2", parameters={"S2", "FindTwoConsecutiveWithMask"}), @GenerateStub(name="indexOfTwoConsecutiveWithMaskS4", parameters={"S4", "FindTwoConsecutiveWithMask"})})
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, Object var2, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, @Node.ConstantNodeParameter EnumSet<?> var2, Object var3, long var4, int var6, int var7, int var8, int var9, int var10, int var11);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="indexOfTableS1", parameters={"S1", "Table"}, minimumCPUFeaturesAMD64="amd64FeaturesSSE41", minimumCPUFeaturesAARCH64="aarch64FeaturesNone"), @GenerateStub(name="indexOfTableS2", parameters={"S2", "Table"}, minimumCPUFeaturesAMD64="amd64FeaturesSSE41", minimumCPUFeaturesAARCH64="aarch64FeaturesNone"), @GenerateStub(name="indexOfTableS4", parameters={"S4", "Table"}, minimumCPUFeaturesAMD64="amd64FeaturesSSE41", minimumCPUFeaturesAARCH64="aarch64FeaturesNone")})
    public static native int optimizedArrayIndexOfTable(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, Object var2, long var3, int var5, int var6, byte[] var7);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOfTable(@Node.ConstantNodeParameter Stride var0, @Node.ConstantNodeParameter LIRGeneratorTool.ArrayIndexOfVariant var1, @Node.ConstantNodeParameter EnumSet<?> var2, Object var3, long var4, int var6, int var7, byte[] var8);
}

