/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.replacements.NodeStrideUtil;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsWithMaskForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public final class ArrayRegionEqualsWithMaskNode
extends PureFunctionStubIntrinsicNode
implements Canonicalizable,
ConstantReflectionUtil.ArrayBaseOffsetProvider {
    public static final NodeClass<ArrayRegionEqualsWithMaskNode> TYPE = NodeClass.create(ArrayRegionEqualsWithMaskNode.class);
    private final Stride strideA;
    private final Stride strideB;
    private final Stride strideMask;
    @Node.Input
    protected ValueNode arrayA;
    @Node.Input
    protected ValueNode offsetA;
    @Node.Input
    protected ValueNode arrayB;
    @Node.Input
    protected ValueNode offsetB;
    @Node.Input
    protected ValueNode arrayMask;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput
    protected ValueNode dynamicStrides;

    public ArrayRegionEqualsWithMaskNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB, @Node.ConstantNodeParameter Stride strideMask) {
        this(arrayA, offsetA, arrayB, offsetB, arrayMask, length, null, strideA, strideB, strideMask, null, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionEqualsWithMaskNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB, @Node.ConstantNodeParameter Stride strideMask, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(arrayA, offsetA, arrayB, offsetB, arrayMask, length, null, strideA, strideB, strideMask, runtimeCheckedCPUFeatures, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionEqualsWithMaskNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length, ValueNode dynamicStrides) {
        this(arrayA, offsetA, arrayB, offsetB, arrayMask, length, dynamicStrides, null, null, null, null, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionEqualsWithMaskNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length, ValueNode dynamicStrides, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(arrayA, offsetA, arrayB, offsetB, arrayMask, length, dynamicStrides, null, null, null, runtimeCheckedCPUFeatures, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionEqualsWithMaskNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length, ValueNode dynamicStrides, Stride strideA, Stride strideB, Stride strideMask, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forKind(JavaKind.Boolean), runtimeCheckedCPUFeatures, locationIdentity);
        assert (ArrayRegionEqualsWithMaskNode.validStride(strideA));
        assert (ArrayRegionEqualsWithMaskNode.validStride(strideB));
        assert (ArrayRegionEqualsWithMaskNode.validStride(strideMask));
        this.strideA = strideA;
        this.strideB = strideB;
        this.strideMask = strideMask;
        this.arrayA = arrayA;
        this.offsetA = offsetA;
        this.arrayB = arrayB;
        this.offsetB = offsetB;
        this.arrayMask = arrayMask;
        this.length = length;
        this.dynamicStrides = dynamicStrides;
    }

    private static boolean validStride(Stride stride) {
        return stride == null || stride.value <= 4;
    }

    public Stride getStrideA() {
        return this.strideA;
    }

    public Stride getStrideB() {
        return this.strideB;
    }

    public Stride getStrideMask() {
        return this.strideMask;
    }

    public ValueNode getDynamicStrides() {
        return this.dynamicStrides;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public int getDirectStubCallIndex() {
        return NodeStrideUtil.getDirectStubCallIndex(this.dynamicStrides, this.strideA, this.strideB);
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return ArrayEqualsWithMaskForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        if (this.getDirectStubCallIndex() < 0) {
            return new ValueNode[]{this.arrayA, this.offsetA, this.arrayB, this.offsetB, this.arrayMask, this.length, this.dynamicStrides};
        }
        return new ValueNode[]{this.arrayA, this.offsetA, this.arrayB, this.offsetB, this.arrayMask, this.length};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        if (this.getDirectStubCallIndex() < 0) {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayEqualsWithMaskDynamicStrides(this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.arrayMask), gen.operand(this.length), gen.operand(this.dynamicStrides)));
        } else {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayEqualsWithMask(NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideMask), this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.arrayMask), gen.operand(this.length)));
        }
    }

    @Override
    public int getArrayBaseOffset(MetaAccessProvider metaAccess, ValueNode array, JavaKind arrayKind) {
        return metaAccess.getArrayBaseOffset(arrayKind);
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="arrayRegionEqualsWithMaskS1S2S1", parameters={"S1", "S2", "S1"}), @GenerateStub(name="arrayRegionEqualsWithMaskS2S2S1", parameters={"S2", "S2", "S1"}), @GenerateStub(name="arrayRegionEqualsWithMaskS1S1", parameters={"S1", "S1", "S1"}), @GenerateStub(name="arrayRegionEqualsWithMaskS1S2", parameters={"S1", "S2", "S2"}), @GenerateStub(name="arrayRegionEqualsWithMaskS1S4", parameters={"S1", "S4", "S4"}), @GenerateStub(name="arrayRegionEqualsWithMaskS2S1", parameters={"S2", "S1", "S1"}), @GenerateStub(name="arrayRegionEqualsWithMaskS2S2", parameters={"S2", "S2", "S2"}), @GenerateStub(name="arrayRegionEqualsWithMaskS2S4", parameters={"S2", "S4", "S4"}), @GenerateStub(name="arrayRegionEqualsWithMaskS4S1", parameters={"S4", "S1", "S1"}), @GenerateStub(name="arrayRegionEqualsWithMaskS4S2", parameters={"S4", "S2", "S2"}), @GenerateStub(name="arrayRegionEqualsWithMaskS4S4", parameters={"S4", "S4", "S4"})})
    public static native boolean regionEquals(Object var0, long var1, Object var3, long var4, Pointer var6, int var7, @Node.ConstantNodeParameter Stride var8, @Node.ConstantNodeParameter Stride var9, @Node.ConstantNodeParameter Stride var10);

    @Node.NodeIntrinsic
    public static native boolean regionEquals(Object var0, long var1, Object var3, long var4, Pointer var6, int var7, @Node.ConstantNodeParameter Stride var8, @Node.ConstantNodeParameter Stride var9, @Node.ConstantNodeParameter Stride var10, @Node.ConstantNodeParameter EnumSet<?> var11);

    @Node.NodeIntrinsic
    @GenerateStub(name="arrayRegionEqualsWithMaskDynamicStrides")
    public static native boolean regionEquals(Object var0, long var1, Object var3, long var4, Pointer var6, int var7, int var8);

    @Node.NodeIntrinsic
    public static native boolean regionEquals(Object var0, long var1, Object var3, long var4, Pointer var6, int var7, int var8, @Node.ConstantNodeParameter EnumSet<?> var9);

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if ((this.dynamicStrides == null || this.dynamicStrides.isJavaConstant()) && this.length.isJavaConstant() && this.arrayMask instanceof ComputeObjectAddressNode) {
            int len = this.length.asJavaConstant().asInt();
            Stride constStrideA = NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA);
            Stride constStrideB = NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB);
            Stride constStrideMask = NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideMask);
            ValueNode arrayMaskNode = ((ComputeObjectAddressNode)this.arrayMask).getObject();
            ValueNode offsetMaskNode = ((ComputeObjectAddressNode)this.arrayMask).getOffset();
            if (len * Math.max(constStrideA.value, constStrideB.value) < GraalOptions.ArrayRegionEqualsConstantLimit.getValue(tool.getOptions()) && ConstantReflectionUtil.canFoldReads(tool, this.arrayA, this.offsetA, constStrideA, len, this) && ConstantReflectionUtil.canFoldReads(tool, this.arrayB, this.offsetB, constStrideB, len, this) && ConstantReflectionUtil.canFoldReads(tool, arrayMaskNode, offsetMaskNode, constStrideMask, len, this)) {
                Integer startIndexA = ConstantReflectionUtil.startIndex(tool, this.arrayA, this.offsetA.asJavaConstant(), constStrideA, this);
                Integer startIndexB = ConstantReflectionUtil.startIndex(tool, this.arrayB, this.offsetB.asJavaConstant(), constStrideB, this);
                Integer startIndexMask = ConstantReflectionUtil.startIndex(tool, arrayMaskNode, offsetMaskNode.asJavaConstant(), constStrideMask, this);
                return ConstantNode.forBoolean(ArrayRegionEqualsWithMaskNode.constantFold(tool, this.arrayA, startIndexA, this.arrayB, startIndexB, arrayMaskNode, startIndexMask, len, constStrideA, constStrideB, constStrideMask));
            }
        }
        return this;
    }

    private static boolean constantFold(CanonicalizerTool tool, ValueNode a, int startIndexA, ValueNode b, int startIndexB, ValueNode mask, int startIndexMask, int len, Stride constStrideA, Stride constStrideB, Stride constStrideMask) {
        JavaKind arrayKindA = a.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        JavaKind arrayKindB = b.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        JavaKind arrayKindM = mask.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        ConstantReflectionProvider constantReflection = tool.getConstantReflection();
        for (int i = 0; i < len; ++i) {
            int valueA = ConstantReflectionUtil.readTypePunned(constantReflection, a.asJavaConstant(), arrayKindA, constStrideA, startIndexA + i);
            int valueB = ConstantReflectionUtil.readTypePunned(constantReflection, b.asJavaConstant(), arrayKindB, constStrideB, startIndexB + i);
            int valueM = ConstantReflectionUtil.readTypePunned(constantReflection, mask.asJavaConstant(), arrayKindM, constStrideMask, startIndexMask + i);
            if ((valueA | valueM) == valueB) continue;
            return false;
        }
        return true;
    }
}

