/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_1024, size=NodeSize.SIZE_256)
public class BigIntegerMultiplyToLenNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<BigIntegerMultiplyToLenNode> TYPE = NodeClass.create(BigIntegerMultiplyToLenNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Int)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("multiplyToLen", Void.TYPE, new Class[]{Pointer.class, Integer.TYPE, Pointer.class, Integer.TYPE, Pointer.class, Integer.TYPE}, false, KILLED_LOCATIONS, false, false);
    @Node.Input
    protected ValueNode x;
    @Node.Input
    protected ValueNode xlen;
    @Node.Input
    protected ValueNode y;
    @Node.Input
    protected ValueNode ylen;
    @Node.Input
    protected ValueNode z;
    @Node.Input
    protected ValueNode zlen;

    public BigIntegerMultiplyToLenNode(ValueNode x, ValueNode xlen, ValueNode y, ValueNode ylen, ValueNode z, ValueNode zlen) {
        this(x, xlen, y, ylen, z, zlen, null);
    }

    public BigIntegerMultiplyToLenNode(ValueNode x, ValueNode xlen, ValueNode y, ValueNode ylen, ValueNode z, ValueNode zlen, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forVoid(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.x = x;
        this.xlen = xlen;
        this.y = y;
        this.ylen = ylen;
        this.z = z;
        this.zlen = zlen;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.x, this.xlen, this.y, this.ylen, this.z, this.zlen};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Node.NodeIntrinsic
    @GenerateStub(name="multiplyToLen")
    public static native void apply(Pointer var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    @Node.NodeIntrinsic
    public static native void apply(Pointer var0, int var1, Pointer var2, int var3, Pointer var4, int var5, @Node.ConstantNodeParameter EnumSet<?> var6);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitBigIntegerMultiplyToLen(gen.operand(this.x), gen.operand(this.xlen), gen.operand(this.y), gen.operand(this.ylen), gen.operand(this.z), gen.operand(this.zlen));
    }
}

