/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_32)
public final class FloatToHalfFloatNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<FloatToHalfFloatNode> TYPE = NodeClass.create(FloatToHalfFloatNode.class);

    public FloatToHalfFloatNode(ValueNode value) {
        super(TYPE, StampFactory.forKind(JavaKind.Short), value);
    }

    private static short floatToFloat16(float f) {
        try {
            Method floatToFloat16 = Float.class.getDeclaredMethod("floatToFloat16", Float.TYPE);
            return (Short)floatToFloat16.invoke(null, Float.valueOf(f));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere(e, "Float.floatToFloat16 is introduced in Java 20");
        }
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue instanceof ConstantNode) {
            float f = forValue.asJavaConstant().asFloat();
            return ConstantNode.forPrimitive((JavaConstant)JavaConstant.forShort((short)FloatToHalfFloatNode.floatToFloat16(f)));
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable result = gen.getLIRGeneratorTool().getArithmetic().emitFloatToHalfFloat(gen.operand(this.getValue()));
        gen.setResult(this, (Value)result);
    }
}

