/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeInterface;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

public interface IntrinsicMethodNodeInterface
extends ValueNodeInterface,
LIRLowerable {
    public StructuredGraph graph();

    public ForeignCallDescriptor getForeignCallDescriptor();

    public ValueNode[] getForeignCallArguments();

    @Override
    default public void generate(NodeLIRBuilderTool gen) {
        if (!GraalOptions.InlineGraalStubs.getValue(this.graph().getOptions()).booleanValue()) {
            ForeignCallDescriptor foreignCallDescriptor = this.getForeignCallDescriptor();
            ForeignCallLinkage linkage = gen.lookupGraalStub(this.asNode(), foreignCallDescriptor);
            if (linkage != null) {
                ValueNode[] args = this.getForeignCallArguments();
                Value[] operands = new Value[args.length];
                for (int i = 0; i < args.length; ++i) {
                    operands[i] = gen.operand(args[i]);
                }
                Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, operands);
                if (foreignCallDescriptor.getResultType() != Void.TYPE) {
                    gen.setResult(this.asNode(), (Value)result);
                }
                return;
            }
        }
        if (Services.IS_BUILDING_NATIVE_IMAGE && !this.canBeEmitted(gen.getLIRGeneratorTool().target().arch)) {
            gen.getLIRGeneratorTool().emitHalt();
            return;
        }
        this.emitIntrinsic(gen);
    }

    default public boolean canBeEmitted(Architecture arch) {
        return true;
    }

    public void emitIntrinsic(NodeLIRBuilderTool var1);
}

