/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.ForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_256)
public final class VectorizedHashCodeNode
extends PureFunctionStubIntrinsicNode {
    public static final NodeClass<VectorizedHashCodeNode> TYPE = NodeClass.create(VectorizedHashCodeNode.class);
    public static final ForeignCallDescriptor STUB_BOOLEAN = ForeignCalls.pureFunctionForeignCallDescriptor("vectorizedHashCodeBoolean", Integer.TYPE, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor STUB_CHAR = ForeignCalls.pureFunctionForeignCallDescriptor("vectorizedHashCodeChar", Integer.TYPE, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor STUB_BYTE = ForeignCalls.pureFunctionForeignCallDescriptor("vectorizedHashCodeByte", Integer.TYPE, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor STUB_SHORT = ForeignCalls.pureFunctionForeignCallDescriptor("vectorizedHashCodeShort", Integer.TYPE, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor STUB_INT = ForeignCalls.pureFunctionForeignCallDescriptor("vectorizedHashCodeInt", Integer.TYPE, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{STUB_BOOLEAN, STUB_CHAR, STUB_BYTE, STUB_SHORT, STUB_INT};
    @Node.Input
    protected ValueNode arrayStart;
    @Node.Input
    protected ValueNode length;
    @Node.Input
    protected ValueNode initialValue;
    private final JavaKind arrayKind;

    public VectorizedHashCodeNode(ValueNode arrayStart, ValueNode length, ValueNode initialValue, JavaKind arrayKind) {
        this(arrayStart, length, initialValue, arrayKind, null);
    }

    public VectorizedHashCodeNode(ValueNode arrayStart, ValueNode length, ValueNode initialValue, JavaKind arrayKind, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.intValue(), runtimeCheckedCPUFeatures, NamedLocationIdentity.getArrayLocation(arrayKind));
        this.arrayStart = arrayStart;
        this.length = length;
        this.initialValue = initialValue;
        this.arrayKind = arrayKind;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return switch (this.arrayKind) {
            case JavaKind.Boolean -> STUB_BOOLEAN;
            case JavaKind.Char -> STUB_CHAR;
            case JavaKind.Byte -> STUB_BYTE;
            case JavaKind.Short -> STUB_SHORT;
            case JavaKind.Int -> STUB_INT;
            default -> throw GraalError.shouldNotReachHere("Unsupported JavaKind " + this.arrayKind);
        };
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.arrayStart, this.length, this.initialValue};
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return EnumSet.of(AMD64.CPUFeature.SSE2, new AMD64.CPUFeature[]{AMD64.CPUFeature.SSE3, AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SSE4_2, AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2});
    }

    public static boolean isSupported(Architecture arch) {
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures().containsAll(VectorizedHashCodeNode.minFeaturesAMD64());
        }
        return false;
    }

    @Override
    public boolean canBeEmitted(Architecture arch) {
        return VectorizedHashCodeNode.isSupported(arch);
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitVectorizedHashCode(this.runtimeCheckedCPUFeatures, gen.operand(this.arrayStart), gen.operand(this.length), gen.operand(this.initialValue), this.arrayKind));
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="vectorizedHashCodeBoolean", parameters={"Boolean"}, minimumCPUFeaturesAMD64="minFeaturesAMD64"), @GenerateStub(name="vectorizedHashCodeChar", parameters={"Char"}, minimumCPUFeaturesAMD64="minFeaturesAMD64"), @GenerateStub(name="vectorizedHashCodeByte", parameters={"Byte"}, minimumCPUFeaturesAMD64="minFeaturesAMD64"), @GenerateStub(name="vectorizedHashCodeShort", parameters={"Short"}, minimumCPUFeaturesAMD64="minFeaturesAMD64"), @GenerateStub(name="vectorizedHashCodeInt", parameters={"Int"}, minimumCPUFeaturesAMD64="minFeaturesAMD64")})
    public static native int vectorizedHashCode(Pointer var0, int var1, int var2, @Node.ConstantNodeParameter JavaKind var3);

    @Node.NodeIntrinsic
    public static native int vectorizedHashCode(Pointer var0, int var1, int var2, @Node.ConstantNodeParameter JavaKind var3, @Node.ConstantNodeParameter EnumSet<?> var4);
}

