/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerNegExactNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerNegExactSplitNode;

@NodeInfo(cycles=NodeCycles.CYCLES_4, cyclesRationale="neg+cmp", size=NodeSize.SIZE_2)
public class IntegerNegExactOverflowNode
extends LogicNode
implements Simplifiable,
Canonicalizable {
    public static final NodeClass<IntegerNegExactOverflowNode> TYPE = NodeClass.create(IntegerNegExactOverflowNode.class);
    @Node.Input
    protected ValueNode value;

    public IntegerNegExactOverflowNode(ValueNode value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.value.isConstant()) {
            JavaConstant cst = this.value.asJavaConstant();
            try {
                if (cst.getJavaKind() == JavaKind.Int) {
                    Math.negateExact(cst.asInt());
                } else {
                    assert (cst.getJavaKind() == JavaKind.Long);
                    Math.negateExact(cst.asLong());
                }
            }
            catch (ArithmeticException ex) {
                return LogicConstantNode.forBoolean(true);
            }
            return LogicConstantNode.forBoolean(false);
        }
        if (!IntegerStamp.negateCanOverflow((IntegerStamp)this.value.stamp(NodeView.DEFAULT))) {
            return LogicConstantNode.forBoolean(false);
        }
        return this;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        for (IfNode ifNode : this.usages().filter(IfNode.class).snapshot()) {
            AbstractBeginNode next = ifNode.falseSuccessor();
            AbstractBeginNode overflow = ifNode.trueSuccessor();
            ifNode.clearSuccessors();
            List<IntegerNegExactNode> coupledNodes = next.usages().filter(IntegerNegExactNode.class).filter(n -> this.value == ((IntegerNegExactNode)n).getValue()).snapshot();
            Stamp splitStamp = this.value.stamp(NodeView.DEFAULT).unrestricted();
            if (!coupledNodes.isEmpty()) {
                splitStamp = ((IntegerNegExactNode)coupledNodes.iterator().next()).stamp(NodeView.DEFAULT);
            }
            IntegerExactArithmeticSplitNode split = this.graph().add(new IntegerNegExactSplitNode(splitStamp, this.value, next, overflow));
            ifNode.replaceAndDelete(split);
            coupledNodes.forEach(n -> n.replaceAndDelete(split));
        }
    }
}

