/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;

final class ParsingInlineInvokePlugin
implements InlineInvokePlugin {
    private final PartialEvaluator partialEvaluator;
    private final ReplacementsImpl replacements;
    private final InvocationPlugins invocationPlugins;
    private final LoopExplosionPlugin loopExplosionPlugin;

    ParsingInlineInvokePlugin(PartialEvaluator partialEvaluator, ReplacementsImpl replacements, InvocationPlugins invocationPlugins, LoopExplosionPlugin loopExplosionPlugin) {
        this.partialEvaluator = partialEvaluator;
        this.replacements = replacements;
        this.invocationPlugins = invocationPlugins;
        this.loopExplosionPlugin = loopExplosionPlugin;
    }

    private boolean hasMethodHandleArgument(ValueNode[] arguments) {
        for (ValueNode argument : arguments) {
            JavaConstant constant;
            if (!argument.isConstant() || (constant = argument.asJavaConstant()).getJavaKind() != JavaKind.Object || !constant.isNonNull() || !this.partialEvaluator.types.MethodHandle.isInstance(constant)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
        if (this.invocationPlugins.lookupInvocation(original, builder.getOptions()) != null || this.replacements.hasSubstitution(original, builder.getOptions())) {
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        if (this.loopExplosionPlugin.loopExplosionKind(original) != LoopExplosionPlugin.LoopExplosionKind.NONE) {
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        InlineInvokePlugin.InlineInfo inlineInfo = this.partialEvaluator.asInlineInfo(original);
        if (!inlineInfo.allowsInlining()) {
            return inlineInfo;
        }
        for (ResolvedJavaMethod neverInlineMethod : this.partialEvaluator.getNeverInlineMethods()) {
            if (!original.equals(neverInlineMethod)) continue;
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        if (this.hasMethodHandleArgument(arguments)) {
            return inlineInfo;
        }
        return null;
    }
}

