/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;

public final class PerformanceInformationHandler
implements Closeable {
    private static final ThreadLocal<PerformanceInformationHandler> instance = new ThreadLocal();
    private final TruffleCompilerRuntime runtime;
    private final OptionValues options;
    private final Set<TruffleCompilerOptions.PerformanceWarningKind> warningKinds = EnumSet.noneOf(TruffleCompilerOptions.PerformanceWarningKind.class);

    private PerformanceInformationHandler(TruffleCompilerRuntime runtime, OptionValues options) {
        this.options = options;
        this.runtime = runtime;
    }

    private void addWarning(TruffleCompilerOptions.PerformanceWarningKind warningKind) {
        this.warningKinds.add(warningKind);
    }

    private Set<TruffleCompilerOptions.PerformanceWarningKind> getWarnings() {
        return this.warningKinds;
    }

    @Override
    public void close() {
        assert (instance.get() != null) : "No PerformanceInformationHandler installed";
        instance.remove();
    }

    public static PerformanceInformationHandler install(TruffleCompilerRuntime runtime, OptionValues options) {
        assert (instance.get() == null) : "PerformanceInformationHandler already installed";
        PerformanceInformationHandler handler = new PerformanceInformationHandler(runtime, options);
        instance.set(handler);
        return handler;
    }

    public static boolean isWarningEnabled(TruffleCompilerOptions.PerformanceWarningKind warningKind) {
        PerformanceInformationHandler handler = instance.get();
        return TruffleCompilerOptions.TracePerformanceWarnings.getValue(handler.options).kinds().contains((Object)warningKind) || TruffleCompilerOptions.TreatPerformanceWarningsAsErrors.getValue(handler.options).kinds().contains((Object)warningKind);
    }

    public static void logPerformanceWarning(TruffleCompilerOptions.PerformanceWarningKind warningKind, TruffleCompilable compilable, List<? extends Node> locations, String details, Map<String, Object> properties) {
        PerformanceInformationHandler handler = instance.get();
        handler.addWarning(warningKind);
        handler.logPerformanceWarningImpl(compilable, "perf warn", details, properties, handler.getPerformanceStackTrace(locations));
    }

    private void logPerformanceInfo(TruffleCompilable compilable, List<? extends Node> locations, String details, Map<String, Object> properties) {
        this.logPerformanceWarningImpl(compilable, "perf info", details, properties, instance.get().getPerformanceStackTrace(locations));
    }

    private void logPerformanceWarningImpl(TruffleCompilable compilable, String event, String details, Map<String, Object> properties, String message) {
        this.runtime.logEvent(compilable, 0, event, String.format("%-60s|%s", compilable.getName(), details), properties, message);
    }

    private String getPerformanceStackTrace(List<? extends Node> locations) {
        Object stackTrace;
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        int limit = TruffleCompilerOptions.TraceStackTraceLimit.getValue(this.options);
        if (limit <= 0) {
            return null;
        }
        EconomicMap groupedByStackTrace = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        for (Node node : locations) {
            String stackTraceAsString;
            stackTrace = GraphUtil.approxSourceStackTraceElement(node);
            StringBuilder sb = new StringBuilder();
            String indent = "    ";
            for (int i = 0; i < ((StackTraceElement[])stackTrace).length && i < limit; ++i) {
                if (i != 0) {
                    sb.append('\n');
                }
                sb.append(indent).append("at ").append(stackTrace[i]);
            }
            if (((StackTraceElement[])stackTrace).length > limit) {
                sb.append('\n').append(indent).append("...");
            }
            if (!groupedByStackTrace.containsKey((Object)(stackTraceAsString = sb.toString()))) {
                groupedByStackTrace.put((Object)stackTraceAsString, new ArrayList());
            }
            ((List)groupedByStackTrace.get((Object)stackTraceAsString)).add(node);
        }
        StringBuilder builder = new StringBuilder();
        MapCursor mapCursor = groupedByStackTrace.getEntries();
        while (mapCursor.advance()) {
            stackTrace = (String)mapCursor.getKey();
            List locationGroup = (List)mapCursor.getValue();
            if (builder.length() > 0) {
                builder.append(String.format("%n", new Object[0]));
            }
            if (((String)stackTrace).isEmpty()) {
                builder.append(String.format("  No stack trace available for %s.", locationGroup));
                continue;
            }
            builder.append(String.format("  Approximated stack trace for %s (append --vm.XX:+UnlockDiagnosticVMOptions --vm.XX:+DebugNonSafepoints for more precise approximation):\n", locationGroup));
            builder.append((String)stackTrace);
        }
        return builder.toString();
    }

    public void reportPerformanceWarnings(TruffleTierContext context) {
        StructuredGraph graph = context.graph;
        DebugContext debug = context.debug;
        ArrayList<ValueNode> warnings = new ArrayList<ValueNode>();
        if (PerformanceInformationHandler.isWarningEnabled(TruffleCompilerOptions.PerformanceWarningKind.VIRTUAL_RUNTIME_CALL)) {
            for (MethodCallTargetNode methodCallTargetNode : context.graph.getNodes(MethodCallTargetNode.TYPE)) {
                ResolvedJavaMethod targetMethod = methodCallTargetNode.targetMethod();
                if (targetMethod.isNative() || !targetMethod.canBeInlined() || !context.getPartialEvaluator().getMethodInfo(targetMethod).inlineForPartialEvaluation().allowsInlining()) continue;
                PerformanceInformationHandler.logPerformanceWarning(TruffleCompilerOptions.PerformanceWarningKind.VIRTUAL_RUNTIME_CALL, context.compilable, Arrays.asList(methodCallTargetNode), String.format("Partial evaluation could not inline the virtual runtime call %s to %s (%s).", new Object[]{methodCallTargetNode.invokeKind(), targetMethod, methodCallTargetNode}), null);
                warnings.add(methodCallTargetNode);
            }
        }
        if (PerformanceInformationHandler.isWarningEnabled(TruffleCompilerOptions.PerformanceWarningKind.VIRTUAL_INSTANCEOF)) {
            EconomicMap groupedByType = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            for (InstanceOfNode instanceOf : graph.getNodes().filter(InstanceOfNode.class)) {
                ResolvedJavaType type;
                if (instanceOf.type().isExact() || !PerformanceInformationHandler.isSecondaryType(type = instanceOf.type().getType())) continue;
                warnings.add(instanceOf);
                if (!groupedByType.containsKey((Object)type)) {
                    groupedByType.put((Object)type, new ArrayList());
                }
                ((ArrayList)groupedByType.get((Object)type)).add(instanceOf);
            }
            MapCursor mapCursor = groupedByType.getEntries();
            while (mapCursor.advance()) {
                ResolvedJavaType type = (ResolvedJavaType)mapCursor.getKey();
                String reason = "Partial evaluation could not resolve virtual instanceof to an exact type due to: " + String.format(type.isInterface() ? "interface type check: %s" : "too deep in class hierarchy: %s", type);
                this.logPerformanceInfo(context.compilable, (List)mapCursor.getValue(), reason, Collections.singletonMap("Nodes", mapCursor.getValue()));
            }
        }
        if (PerformanceInformationHandler.isWarningEnabled(TruffleCompilerOptions.PerformanceWarningKind.MISSING_LOOP_FREQUENCY_INFO)) {
            ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, true, true, false);
            for (Loop loop : cfg.getLoops()) {
                List loopBlocks = loop.getBlocks();
                for (HIRBlock exit : loop.getLoopExits()) {
                    ControlSplitNode split;
                    HIRBlock exitDom = (HIRBlock)exit.getDominator();
                    while (!(exitDom.getEndNode() instanceof ControlSplitNode) && !loopBlocks.contains(exitDom)) {
                        exitDom = (HIRBlock)exitDom.getDominator();
                    }
                    if (!loopBlocks.contains(exitDom) || !(exitDom.getEndNode() instanceof ControlSplitNode) || ProfileData.ProfileSource.isTrusted((split = (ControlSplitNode)exitDom.getEndNode()).getProfileData().getProfileSource())) continue;
                    PerformanceInformationHandler.logPerformanceWarning(TruffleCompilerOptions.PerformanceWarningKind.MISSING_LOOP_FREQUENCY_INFO, context.compilable, Arrays.asList(((HIRBlock)loop.getHeader()).getBeginNode()), String.format("Missing loop profile for %s at loop %s.", split, ((HIRBlock)loop.getHeader()).getBeginNode()), null);
                }
            }
        }
        if (debug.areScopesEnabled() && !warnings.isEmpty()) {
            try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                debug.dump(1, (Object)graph, "performance warnings %s", warnings);
            }
            catch (Throwable t) {
                debug.handle(t);
            }
        }
        if (!Collections.disjoint(this.getWarnings(), TruffleCompilerOptions.TreatPerformanceWarningsAsErrors.getValue(this.options).kinds())) {
            throw new AssertionError((Object)"Performance warning detected and is treated as a compilation error.");
        }
    }

    private static boolean isPrimarySupertype(ResolvedJavaType type) {
        if (type.isInterface()) {
            return false;
        }
        int depth = 0;
        for (ResolvedJavaType supr = type; supr != null; supr = supr.getSuperclass()) {
            ++depth;
        }
        return depth <= 8;
    }

    private static boolean isSecondaryType(ResolvedJavaType type) {
        return !PerformanceInformationHandler.isPrimarySupertype(type);
    }
}

