/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import com.oracle.truffle.compiler.ConstantFieldInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleSourceLanguagePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.JavaMethodContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.truffle.compiler.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.graphio.GraphBlocks;
import org.graalvm.graphio.GraphStructure;

final class TruffleAST
implements JavaMethodContext {
    static final ASTDumpStructure AST_DUMP_STRUCTURE = new ASTDumpStructure();
    private final ASTNode root;
    private final List<ASTBlock> blocks = new ArrayList<ASTBlock>();
    private final List<ASTNode> nodes = new ArrayList<ASTNode>();
    private final TruffleCompilationTask task;
    private final TruffleCompilable compilable;
    private final PartialEvaluator partialEvaluator;
    private final CallTree callTree;
    private int currentId = 0;

    private TruffleAST(PartialEvaluator partialEvaluator, TruffleCompilationTask task, TruffleCompilable compilable, CallTree callTree) {
        this.partialEvaluator = partialEvaluator;
        this.compilable = compilable;
        this.callTree = callTree;
        this.task = task;
        JavaConstant rootNode = this.readRootNode(compilable);
        this.root = this.makeASTNode(null, null, rootNode);
        TruffleAST.injectRootName(this.root, compilable);
        this.buildTree(rootNode, this.root, this.root.block);
    }

    static TruffleAST create(PartialEvaluator config, TruffleCompilationTask task, TruffleCompilable compilable, CallTree callTree) {
        return new TruffleAST(config, task, compilable, callTree);
    }

    private JavaConstant readRootNode(TruffleCompilable c) {
        return this.constantReflection().readFieldValue(this.types().OptimizedCallTarget_rootNode, c.asJavaConstant());
    }

    private KnownTruffleTypes types() {
        return this.partialEvaluator.getTypes();
    }

    @Override
    public JavaMethod asJavaMethod() {
        return new TruffleDebugJavaMethod(this.task, this.compilable);
    }

    private ASTNode makeASTNode(ASTNode parent, ASTBlock blockParent, JavaConstant node) {
        ASTBlock block = null;
        block = blockParent == null ? this.makeASTBlock(null, this.callTree != null ? this.callTree.getRoot() : null) : blockParent;
        ASTNode astNode = new ASTNode(block, node);
        this.nodes.add(astNode);
        this.makeInlinedAST(parent, node, astNode);
        return astNode;
    }

    private void makeInlinedAST(ASTNode parent, JavaConstant node, ASTNode astNode) {
        if (this.callTree == null) {
            return;
        }
        if (this.types().OptimizedDirectCallNode.equals(this.metaAccess().lookupJavaType(node))) {
            Node found = null;
            for (CallNode callNode : parent.block.callNode.getChildren()) {
                if (!callNode.getCallNode().equals(node)) continue;
                found = callNode;
                break;
            }
            if (found != null) {
                for (Map.Entry entry : found.getDebugProperties().entrySet()) {
                    astNode.properties.put("call." + entry.getKey().toString(), entry.getValue());
                }
            }
            if (found != null && ((CallNode)found).getState() == CallNode.State.Inlined) {
                ASTBlock block = this.makeASTBlock(parent.block, (CallNode)found);
                TruffleCompilable truffleCompilable = block.callNode.getDirectCallTarget();
                this.buildTree(this.readRootNode(truffleCompilable), astNode, block);
                if (astNode.children.size() >= 1) {
                    ASTNode rootNode = astNode.children.get(0);
                    TruffleAST.injectRootName(rootNode, truffleCompilable);
                }
            }
        }
    }

    private static void injectRootName(ASTNode rootNode, TruffleCompilable ast) {
        String rootName = ast.getName();
        rootNode.properties.put("label", rootNode.properties.get("label") + " (" + rootName + ")");
        rootNode.properties.put("rootName", rootName);
    }

    private ASTBlock makeASTBlock(ASTBlock parentBlock, CallNode callNode) {
        ASTBlock astBlock = new ASTBlock(this.blocks.size(), callNode);
        this.blocks.add(astBlock);
        if (parentBlock != null) {
            parentBlock.successors.add(astBlock);
        }
        return astBlock;
    }

    private void buildTree(JavaConstant parent, ASTNode astParent, ASTBlock blockParent) {
        if (astParent == null) {
            return;
        }
        ResolvedJavaType type = this.metaAccess().lookupJavaType(parent);
        if (type != null) {
            ConstantReflectionProvider constantReflection = this.constantReflection();
            for (ResolvedJavaField field : type.getInstanceFields(true)) {
                JavaConstant array;
                String label = field.getName();
                ConstantFieldInfo info = this.partialEvaluator.getConstantFieldInfo(field);
                if (info == null) continue;
                if (info.isChild()) {
                    JavaConstant node = constantReflection.readFieldValue(field, parent);
                    ASTNode astNode = this.addNode(astParent, blockParent, node, label);
                    this.buildTree(node, astNode, blockParent);
                    continue;
                }
                if (!info.isChildren() || !(array = constantReflection.readFieldValue(field, parent)).isNonNull()) continue;
                for (int i = 0; i < constantReflection.readArrayLength(array); ++i) {
                    String arrayLabel = label + "[" + i + "]";
                    JavaConstant node = constantReflection.readArrayElement(array, i);
                    ASTNode astNode = this.addNode(astParent, blockParent, node, arrayLabel);
                    this.buildTree(node, astNode, blockParent);
                }
            }
        }
    }

    private MetaAccessProvider metaAccess() {
        return this.partialEvaluator.config.lastTier().providers().getMetaAccess();
    }

    private ConstantReflectionProvider constantReflection() {
        return this.partialEvaluator.config.lastTier().providers().getConstantReflection();
    }

    private ASTNode addNode(ASTNode parent, ASTBlock blockParent, JavaConstant node, String edgeLabel) {
        if (node.isNull()) {
            return null;
        }
        ASTNode astNode = this.makeASTNode(parent, blockParent, node);
        parent.edges.add(new ASTEdge(astNode, edgeLabel));
        parent.children.add(astNode);
        return astNode;
    }

    private final class ASTNode {
        final List<ASTEdge> edges = new ArrayList<ASTEdge>();
        private final int id;
        private final ResolvedJavaType nodeType;
        private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
        private final ASTNodeClass nodeClass;
        private final ASTBlock block;
        private final List<ASTNode> children = new ArrayList<ASTNode>();

        ASTNode(ASTBlock block, JavaConstant node) {
            TruffleSourceLanguagePosition position;
            this.block = block;
            this.id = TruffleAST.this.currentId++;
            this.nodeClass = new ASTNodeClass(this);
            this.nodeType = TruffleAST.this.metaAccess().lookupJavaType(node);
            this.properties.put("label", ASTNode.dropNodeSuffix(this.nodeType.getUnqualifiedName()));
            this.properties.put("cost", "NodeCost.MONOMORPHIC");
            this.properties.put("nodeClassName", this.nodeType.toJavaName(true));
            if (TruffleAST.this.callTree != null) {
                StructuredGraph graph = TruffleAST.this.callTree.getRoot().getIR();
                ConstantNode constant = null;
                for (Node irNode : graph.getNodes()) {
                    ConstantNode c;
                    if (!(irNode instanceof ConstantNode) || !node.equals((c = (ConstantNode)irNode).asJavaConstant())) continue;
                    constant = c;
                    break;
                }
                this.properties.put("graalIRNode", constant);
            }
            if ((position = TruffleAST.this.task.getPosition(node)) != null) {
                this.properties.put("sourceLanguage", position.getLanguage());
                this.properties.put("sourceDescription", position.getDescription());
                this.properties.put("nodeSourcePosition", new NodeSourcePosition(new PartialEvaluator.SourceLanguagePositionImpl(position), null, TruffleAST.this.types().OptimizedCallTarget_profiledPERoot, -1));
            }
            this.properties.putAll(TruffleAST.this.task.getDebugProperties(node));
            block.nodes.add(this);
        }

        private static String dropNodeSuffix(String className) {
            return className.replaceFirst("Node$", "").replaceFirst("NodeGen$", "");
        }
    }

    private static class ASTBlock {
        private final int id;
        private final List<ASTBlock> successors = new ArrayList<ASTBlock>();
        private final List<ASTNode> nodes = new ArrayList<ASTNode>();
        private final CallNode callNode;

        ASTBlock(int id, CallNode callNode) {
            this.id = id;
            this.callNode = callNode;
        }
    }

    private static class ASTEdge {
        final ASTNode node;
        final String label;

        ASTEdge(ASTNode node, String label) {
            this.node = node;
            this.label = label;
        }
    }

    static final class ASTDumpStructure
    implements GraphStructure<TruffleAST, ASTNode, ASTNodeClass, List<ASTEdge>>,
    GraphBlocks<TruffleAST, ASTBlock, ASTNode> {
        ASTDumpStructure() {
        }

        @Override
        public TruffleAST graph(TruffleAST currentGraph, Object obj) {
            return obj instanceof TruffleAST ? (TruffleAST)obj : null;
        }

        @Override
        public Iterable<? extends ASTNode> nodes(TruffleAST graph) {
            return graph.nodes;
        }

        @Override
        public int nodesCount(TruffleAST graph) {
            return graph.nodes.size();
        }

        @Override
        public int nodeId(ASTNode node) {
            return node.id;
        }

        @Override
        public boolean nodeHasPredecessor(ASTNode node) {
            return false;
        }

        @Override
        public void nodeProperties(TruffleAST graph, ASTNode node, Map<String, ? super Object> properties) {
            properties.putAll(node.properties);
        }

        @Override
        public ASTNode node(Object obj) {
            return obj instanceof ASTNode ? (ASTNode)obj : null;
        }

        @Override
        public ASTNodeClass nodeClass(Object obj) {
            return obj instanceof ASTNodeClass ? (ASTNodeClass)obj : null;
        }

        @Override
        public ASTNodeClass classForNode(ASTNode node) {
            return node.nodeClass;
        }

        @Override
        public String nameTemplate(ASTNodeClass nodeClass) {
            return "{p#label}";
        }

        @Override
        public Object nodeClassType(ASTNodeClass nodeClass) {
            return nodeClass.getClass();
        }

        @Override
        public List<ASTEdge> portInputs(ASTNodeClass nodeClass) {
            return Collections.emptyList();
        }

        @Override
        public List<ASTEdge> portOutputs(ASTNodeClass nodeClass) {
            return nodeClass.node.edges;
        }

        @Override
        public int portSize(List<ASTEdge> port) {
            return port.size();
        }

        @Override
        public boolean edgeDirect(List<ASTEdge> port, int index) {
            return true;
        }

        @Override
        public String edgeName(List<ASTEdge> port, int index) {
            return port.get((int)index).label;
        }

        @Override
        public Object edgeType(List<ASTEdge> port, int index) {
            return EdgeType.EDGE_TYPE;
        }

        @Override
        public Collection<? extends ASTNode> edgeNodes(TruffleAST graph, ASTNode node, List<ASTEdge> port, int index) {
            return List.of(port.get((int)index).node);
        }

        @Override
        public Collection<? extends ASTBlock> blocks(TruffleAST graph) {
            return graph.blocks;
        }

        @Override
        public int blockId(ASTBlock block) {
            return block.id;
        }

        @Override
        public Collection<? extends ASTNode> blockNodes(TruffleAST info, ASTBlock block) {
            return block.nodes;
        }

        @Override
        public Collection<? extends ASTBlock> blockSuccessors(ASTBlock block) {
            return block.successors;
        }
    }

    private static final class ASTNodeClass {
        final ASTNode node;

        ASTNodeClass(ASTNode node) {
            this.node = node;
        }
    }

    private static enum EdgeType {
        EDGE_TYPE;

    }
}

