/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.util.function.Consumer;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.LogStream;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;

public final class TruffleCompilation
implements AutoCloseable {
    private final TruffleCompilable compilable;
    private final TruffleCompilationTask task;
    private final TTY.Filter ttyFilter;
    TruffleCompilationIdentifier compilationId;

    TruffleCompilation(TruffleCompilerRuntime runtime, TruffleCompilationTask task, TruffleCompilable compilable) {
        this.compilable = compilable;
        this.task = task;
        this.ttyFilter = new TTY.Filter(new LogStream(new TTYToPolyglotLoggerBridge(runtime, compilable)));
    }

    public void setCompilationId(TruffleCompilationIdentifier compilationId) {
        this.compilationId = compilationId;
    }

    public TruffleCompilationIdentifier getCompilationId() {
        return this.compilationId;
    }

    public TruffleCompilable getCompilable() {
        return this.compilable;
    }

    public TruffleCompilationTask getTask() {
        return this.task;
    }

    public static boolean isTruffleCompilation(StructuredGraph graph) {
        return TruffleCompilation.lookupCompilable(graph) != null;
    }

    @Override
    public void close() {
        this.ttyFilter.close();
    }

    public static TruffleCompilationTask lookupTask(StructuredGraph graph) {
        CompilationIdentifier compilationIdentifier = graph.compilationId();
        if (compilationIdentifier instanceof TruffleCompilationIdentifier) {
            TruffleCompilationIdentifier id = (TruffleCompilationIdentifier)compilationIdentifier;
            return id.getTask();
        }
        return null;
    }

    public static TruffleCompilable lookupCompilable(StructuredGraph graph) {
        CompilationIdentifier compilationIdentifier = graph.compilationId();
        if (compilationIdentifier instanceof TruffleCompilationIdentifier) {
            TruffleCompilationIdentifier id = (TruffleCompilationIdentifier)compilationIdentifier;
            return id.getCompilable();
        }
        return null;
    }

    static final class TTYToPolyglotLoggerBridge
    implements Consumer<String> {
        private final TruffleCompilable compilable;
        private final TruffleCompilerRuntime runtime;

        TTYToPolyglotLoggerBridge(TruffleCompilerRuntime runtime, TruffleCompilable compilable) {
            this.compilable = compilable;
            this.runtime = runtime;
        }

        @Override
        public void accept(String message) {
            this.runtime.log("graal", this.compilable, message);
        }
    }
}

