/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.truffle.compiler.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.TruffleTierConfiguration;

public final class TruffleCompilerConfiguration {
    private final TruffleCompilerRuntime runtime;
    private final GraphBuilderConfiguration.Plugins plugins;
    private final SnippetReflectionProvider provider;
    private final TruffleTierConfiguration firstTier;
    private final TruffleTierConfiguration lastTier;
    private final KnownTruffleTypes types;
    private final Suites hostSuite;

    public TruffleCompilerConfiguration(TruffleCompilerRuntime runtime, GraphBuilderConfiguration.Plugins plugins, SnippetReflectionProvider provider, TruffleTierConfiguration firstTier, TruffleTierConfiguration lastTier, KnownTruffleTypes knownTruffleTypes, Suites hostSuite) {
        this.runtime = runtime;
        this.plugins = plugins;
        this.provider = provider;
        this.firstTier = firstTier;
        this.lastTier = lastTier;
        this.types = knownTruffleTypes;
        this.hostSuite = hostSuite;
    }

    public TruffleCompilerRuntime runtime() {
        return this.runtime;
    }

    public GraphBuilderConfiguration.Plugins plugins() {
        return this.plugins;
    }

    public SnippetReflectionProvider snippetReflection() {
        return this.provider;
    }

    public TruffleTierConfiguration firstTier() {
        return this.firstTier;
    }

    public TruffleTierConfiguration lastTier() {
        return this.lastTier;
    }

    public KnownTruffleTypes types() {
        return this.types;
    }

    public Suites hostSuite() {
        return this.hostSuite;
    }

    public TruffleCompilerConfiguration withFirstTier(TruffleTierConfiguration tier) {
        return new TruffleCompilerConfiguration(this.runtime, this.plugins, this.provider, tier, this.lastTier, this.types, this.hostSuite);
    }

    public List<Backend> backends() {
        if (this.lastTier.backend() == this.firstTier.backend()) {
            return Arrays.asList(this.lastTier.backend());
        }
        return Arrays.asList(this.firstTier.backend(), this.lastTier.backend());
    }

    public Architecture architecture() {
        Architecture arch = this.lastTier().backend().getTarget().arch;
        assert (arch.equals((Object)this.firstTier().backend().getTarget().arch)) : "target architecture must be the same for first and last tier.";
        return arch;
    }
}

