/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class TruffleElementCache<K, V> {
    private final Map<Object, V> elementCache;

    protected TruffleElementCache(final int maxSize) {
        this.elementCache = Collections.synchronizedMap(new LinkedHashMap<Object, V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, V> eldest) {
                return this.size() > maxSize;
            }
        });
    }

    protected abstract Object createKey(K var1);

    public final V get(K element) {
        Object key = this.createKey(element);
        V cache = this.elementCache.get(key);
        if (cache == null) {
            cache = this.computeValue(element);
            this.elementCache.putIfAbsent(key, cache);
        }
        return cache;
    }

    protected abstract V computeValue(K var1);

    public final String toString() {
        return this.elementCache.toString();
    }
}

