/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import com.oracle.truffle.compiler.HostMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleElementCache;
import org.graalvm.compiler.truffle.compiler.host.TruffleHostEnvironment;

final class HotSpotTruffleHostEnvironment
extends TruffleHostEnvironment {
    private final HostMethodInfoCache hostCache = new HostMethodInfoCache();

    HotSpotTruffleHostEnvironment(TruffleCompilerRuntime runtime, MetaAccessProvider metaAccess) {
        super(runtime, metaAccess);
    }

    @Override
    public HostMethodInfo getHostMethodInfo(ResolvedJavaMethod method) {
        return (HostMethodInfo)this.hostCache.get(method);
    }

    @Override
    protected TruffleCompilerImpl createCompiler(TruffleCompilable compilable) {
        TruffleCompilerRuntime runtime = this.runtime();
        try {
            return (TruffleCompilerImpl)runtime.getClass().getMethod("getTruffleCompiler", TruffleCompilable.class).invoke((Object)runtime, compilable);
        }
        catch (ReflectiveOperationException e) {
            throw GraalError.shouldNotReachHere(e);
        }
    }

    final class HostMethodInfoCache
    extends TruffleElementCache<ResolvedJavaMethod, HostMethodInfo> {
        HostMethodInfoCache() {
            super(4096);
        }

        @Override
        protected Object createKey(ResolvedJavaMethod method) {
            return method;
        }

        @Override
        protected HostMethodInfo computeValue(ResolvedJavaMethod method) {
            return HotSpotTruffleHostEnvironment.this.runtime().getHostMethodInfo(method);
        }
    }
}

