/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.truffle.compiler.host.TruffleHostEnvironment;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleHostEnvironment;

@ServiceProvider(value=TruffleHostEnvironment.Lookup.class)
public final class HotSpotTruffleHostEnvironmentLookup
implements TruffleHostEnvironment.Lookup {
    private static final AtomicReference<TruffleCompilerRuntime> RUNTIME = new AtomicReference();
    private TruffleHostEnvironment environment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TruffleHostEnvironment lookup(ResolvedJavaType forType) {
        TruffleCompilerRuntime runtime = RUNTIME.get();
        if (runtime == null) {
            return null;
        }
        TruffleHostEnvironment env = this.environment;
        if (env != null && env.runtime() == runtime) {
            return env;
        }
        HotSpotTruffleHostEnvironmentLookup hotSpotTruffleHostEnvironmentLookup = this;
        synchronized (hotSpotTruffleHostEnvironmentLookup) {
            env = this.environment;
            if (env != null && env.runtime() == runtime) {
                return env;
            }
            this.environment = env = new HotSpotTruffleHostEnvironment(runtime, HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getMetaAccess());
        }
        return env;
    }

    public static boolean registerRuntime(TruffleCompilerRuntime runtime) {
        return RUNTIME.compareAndSet(null, runtime);
    }
}

