/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.core.phases.CommunityCompilerConfiguration;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.compiler.host.HostInliningPhase;
import org.graalvm.compiler.truffle.compiler.host.InjectImmutableFrameFieldsPhase;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleInvocationPlugins;

public final class TruffleCommunityCompilerConfiguration
extends CommunityCompilerConfiguration {
    @Override
    public HighTier createHighTier(OptionValues options) {
        HighTier highTier = super.createHighTier(options);
        TruffleCommunityCompilerConfiguration.installCommunityHighTier(options, highTier);
        return highTier;
    }

    public static void installCommunityHighTier(OptionValues options, HighTier defaultHighTier) {
        HostInliningPhase.install(defaultHighTier, options);
        InjectImmutableFrameFieldsPhase.install(defaultHighTier, options);
    }

    @Override
    public void registerGraphBuilderPlugins(Architecture arch, GraphBuilderConfiguration.Plugins plugins, OptionValues options, Replacements replacements) {
        super.registerGraphBuilderPlugins(arch, plugins, options, replacements);
        TruffleCommunityCompilerConfiguration.registerCommunityGraphBuilderPlugins(arch, plugins, options, replacements);
    }

    public static void registerCommunityGraphBuilderPlugins(final Architecture arch, final GraphBuilderConfiguration.Plugins plugins, OptionValues options, final Replacements replacements) {
        HostInliningPhase.installInlineInvokePlugin(plugins, options);
        plugins.getInvocationPlugins().defer(new Runnable(){

            @Override
            public void run() {
                TruffleInvocationPlugins.register(arch, plugins.getInvocationPlugins(), replacements);
            }
        });
    }
}

