/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.asm.EntryPointDecorator;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotKnownTruffleTypes;

public abstract class TruffleEntryPointDecorator
implements EntryPointDecorator {
    protected MetaAccessProvider metaAccess;
    protected GraalHotSpotVMConfig config;
    protected HotSpotRegistersProvider registers;
    protected final int installedCodeOffset;
    protected final int entryPointOffset;

    public TruffleEntryPointDecorator(TruffleCompilerConfiguration compilerConfig, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        this.metaAccess = compilerConfig.lastTier().providers().getMetaAccess();
        this.config = config;
        this.registers = registers;
        HotSpotKnownTruffleTypes types = (HotSpotKnownTruffleTypes)compilerConfig.types();
        this.installedCodeOffset = types.HotSpotOptimizedCallTarget_installedCode.getOffset();
        this.entryPointOffset = types.InstalledCode_entryPoint.getOffset();
    }

    @Override
    public void initialize(CodeGenProviders providers, LIRGenerationResult lirGenRes) {
        if (this.config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
            ForeignCallLinkage callTarget = providers.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
            lirGenRes.getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        }
    }
}

