/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public final class IsCompilationConstantNode
extends FloatingNode
implements Lowerable,
Canonicalizable {
    public static final NodeClass<IsCompilationConstantNode> TYPE = NodeClass.create(IsCompilationConstantNode.class);
    @Node.Input
    ValueNode value;

    public IsCompilationConstantNode(ValueNode value) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.value = value;
    }

    @Override
    public void lower(LoweringTool tool) {
        ValueNode synonym = IsCompilationConstantNode.findSynonym(this.value);
        ValueNode result = synonym != null && synonym.isConstant() ? synonym : ConstantNode.forBoolean(false, this.graph());
        assert (result != null);
        this.replaceAtUsagesAndDelete(result);
    }

    public static ValueNode create(ValueNode value) {
        ValueNode synonym = IsCompilationConstantNode.findSynonym(value);
        if (synonym != null) {
            return synonym;
        }
        return new IsCompilationConstantNode(value);
    }

    public static ValueNode findSynonym(ValueNode value) {
        if (value instanceof BoxNode) {
            return IsCompilationConstantNode.create(((BoxNode)value).getValue());
        }
        if (value.isConstant()) {
            return ConstantNode.forBoolean(true);
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode synonym = IsCompilationConstantNode.findSynonym(this.value);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native boolean check(Object var0);
}

