/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;

public final class InliningAcrossTruffleBoundaryPhase
extends BasePhase<TruffleTierContext> {
    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        graph.checkCancellation();
        for (MethodCallTargetNode node : graph.getNodes(MethodCallTargetNode.TYPE)) {
            TruffleCompilerRuntime.InlineKind inlineKind = context.partialEvaluator.getMethodInfo(node.targetMethod()).inlineForTruffleBoundary();
            if (inlineKind.allowsInlining()) continue;
            node.invoke().setUseForInlining(false);
        }
    }
}

