/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import java.util.Iterator;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.NodeWithState;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.TruffleCompilation;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleSafepointNode;

public final class TruffleSafepointInsertionPhase
extends Phase {
    private final Providers providers;
    private final ResolvedJavaType nodeType;
    private final ResolvedJavaType rootNodeType;
    private final ResolvedJavaType osrRootNodeType;
    private final ResolvedJavaType callTargetClass;
    private final ResolvedJavaField rootNodeField;
    private final ResolvedJavaField parentField;
    private final ResolvedJavaField loopNodeField;
    private final ResolvedJavaMethod executeRootMethod;

    public TruffleSafepointInsertionPhase(KnownTruffleTypes types, Providers providers) {
        this.providers = providers;
        this.nodeType = types.Node;
        this.rootNodeType = types.RootNode;
        this.osrRootNodeType = types.BaseOSRRootNode;
        this.callTargetClass = types.OptimizedCallTarget;
        this.executeRootMethod = types.OptimizedCallTarget_executeRootNode;
        this.rootNodeField = types.OptimizedCallTarget_rootNode;
        this.parentField = types.Node_parent;
        this.loopNodeField = types.BaseOSRRootNode_loopNode;
    }

    public static boolean allowsSafepoints(StructuredGraph graph) {
        return TruffleCompilation.isTruffleCompilation(graph);
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    @Override
    protected void run(StructuredGraph graph) {
        Object s;
        if (!TruffleSafepointInsertionPhase.allowsSafepoints(graph)) {
            return;
        }
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            s = returnNode.withNodeSourcePosition();
            try {
                this.insertSafepoint(graph, returnNode);
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
        for (LoopBeginNode loopBeginNode : graph.getNodes(LoopBeginNode.TYPE)) {
            for (LoopEndNode loopEndNode : loopBeginNode.loopEnds()) {
                if (!loopEndNode.canGuestSafepoint()) continue;
                DebugCloseable s2 = loopEndNode.withNodeSourcePosition();
                try {
                    this.insertSafepoint(graph, loopEndNode);
                }
                finally {
                    if (s2 == null) continue;
                    s2.close();
                }
            }
        }
        for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
            s = callTarget.withNodeSourcePosition();
            try {
                this.insertSafepoint(graph, (FixedNode)((Object)callTarget.invoke()));
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
    }

    private void insertSafepoint(StructuredGraph graph, FixedNode returnNode) {
        ConstantNode node = this.findTruffleNode(returnNode);
        if (node == null) {
            JavaConstant javaConstant = TruffleCompilation.lookupCompilable(graph).asJavaConstant();
            JavaConstant rootNode = this.providers.getConstantReflection().readFieldValue(this.rootNodeField, javaConstant);
            ObjectStamp stamp = StampFactory.object(TypeReference.createExactTrusted(this.rootNodeField.getType().resolve(this.callTargetClass)));
            node = new ConstantNode((Constant)this.skipOSRRoot(rootNode), (Stamp)stamp);
        }
        assert (node.asJavaConstant() != null) : "must be a java constant";
        assert (this.nodeType.isAssignableFrom(node.stamp(NodeView.DEFAULT).javaType(this.providers.getMetaAccess()))) : "must be a truffle node";
        node = graph.addOrUnique(node);
        graph.addBeforeFixed(returnNode, graph.add(new TruffleSafepointNode(node)));
    }

    private ConstantNode findTruffleNode(Node node) {
        for (Node n = node; n != null; n = n.predecessor()) {
            FrameState innerMostState;
            Iterator iterator;
            if (!(n instanceof NodeWithState) || !(iterator = ((NodeWithState)((Object)n)).states().iterator()).hasNext()) continue;
            for (FrameState state = innerMostState = (FrameState)iterator.next(); state != null; state = state.outerFrameState()) {
                ConstantNode foundTruffleConstant = this.findTruffleNode(state);
                if (foundTruffleConstant != null) {
                    return foundTruffleConstant;
                }
                if (!state.getMethod().equals(this.executeRootMethod)) continue;
                throw GraalError.shouldNotReachHere("Found a frame state of executeRootNode but not a constant node.");
            }
        }
        return null;
    }

    private ConstantNode findTruffleNode(FrameState state) {
        ObjectStamp stamp;
        JavaConstant rootNode;
        ResolvedJavaMethod method = state.getMethod();
        if (!method.hasReceiver()) {
            return null;
        }
        ResolvedJavaType receiverType = method.getDeclaringClass();
        boolean truffleNode = this.nodeType.isAssignableFrom(receiverType);
        if (!truffleNode && !this.callTargetClass.isAssignableFrom(receiverType)) {
            return null;
        }
        if (state.localsSize() == 0) {
            return null;
        }
        ValueNode value = state.localAt(0);
        if (value == null) {
            return null;
        }
        JavaConstant javaConstant = value.asJavaConstant();
        if (javaConstant == null) {
            return null;
        }
        ResolvedJavaType javaType = value.stamp(NodeView.DEFAULT).javaType(this.providers.getMetaAccess());
        if (javaType == null) {
            return null;
        }
        if (!receiverType.isAssignableFrom(javaType)) {
            assert (false) : "unexpected case";
            return null;
        }
        if (truffleNode) {
            rootNode = this.getRootNode(javaConstant);
            if (rootNode == null) {
                return null;
            }
            stamp = StampFactory.object(TypeReference.createExactTrusted(this.rootNodeType));
        } else {
            rootNode = this.providers.getConstantReflection().readFieldValue(this.rootNodeField, javaConstant);
            stamp = StampFactory.object(TypeReference.createExactTrusted(this.rootNodeField.getType().resolve(this.callTargetClass)));
        }
        return new ConstantNode((Constant)this.skipOSRRoot(rootNode), (Stamp)stamp);
    }

    private JavaConstant skipOSRRoot(JavaConstant rootNode) {
        ResolvedJavaType type = this.providers.getMetaAccess().lookupJavaType(rootNode);
        if (this.osrRootNodeType.isAssignableFrom(type)) {
            JavaConstant loopNode = this.providers.getConstantReflection().readFieldValue(this.loopNodeField, rootNode);
            if (loopNode.isNull()) {
                throw GraalError.shouldNotReachHere(String.format("%s must never be null but is for node %s.", this.loopNodeField.toString(), rootNode));
            }
            return this.getRootNode(loopNode);
        }
        return rootNode;
    }

    private JavaConstant getRootNode(JavaConstant node) {
        JavaConstant current;
        JavaConstant parent = current = node;
        do {
            current = parent;
        } while (!(parent = this.providers.getConstantReflection().readFieldValue(this.parentField, current)).isNull());
        ResolvedJavaType type = this.providers.getMetaAccess().lookupJavaType(current);
        if (this.rootNodeType.isAssignableFrom(type)) {
            return current;
        }
        return null;
    }
}

