/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import org.graalvm.compiler.core.phases.BaseTier;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PostPartialEvaluationSuite;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.phases.InliningAcrossTruffleBoundaryPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentationSuite;
import org.graalvm.compiler.truffle.compiler.phases.MaterializeFramesPhase;
import org.graalvm.compiler.truffle.compiler.phases.NeverPartOfCompilationPhase;
import org.graalvm.compiler.truffle.compiler.phases.ReportPerformanceWarningsPhase;
import org.graalvm.compiler.truffle.compiler.phases.SetIdentityForValueTypesPhase;
import org.graalvm.compiler.truffle.compiler.phases.VerifyFrameDoesNotEscapePhase;
import org.graalvm.compiler.truffle.compiler.phases.inlining.AgnosticInliningPhase;

public class TruffleTier
extends BaseTier<TruffleTierContext> {
    public TruffleTier(OptionValues options, PartialEvaluator partialEvaluator, InstrumentationSuite instrumentationSuite, PostPartialEvaluationSuite postPartialEvaluationSuite) {
        this.appendPhase(new AgnosticInliningPhase(partialEvaluator, postPartialEvaluationSuite));
        this.appendPhase(instrumentationSuite);
        this.appendPhase(new ReportPerformanceWarningsPhase());
        this.appendPhase(new VerifyFrameDoesNotEscapePhase());
        this.appendPhase(new NeverPartOfCompilationPhase());
        this.appendPhase(new MaterializeFramesPhase());
        this.appendPhase(new SetIdentityForValueTypesPhase());
        if (!TruffleCompilerOptions.InlineAcrossTruffleBoundary.getValue(options).booleanValue()) {
            this.appendPhase(new InliningAcrossTruffleBoundaryPhase());
        }
    }
}

