/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;

final class TrivialOnlyInliningPolicy
implements InliningPolicy {
    private final OptionValues options;

    TrivialOnlyInliningPolicy(OptionValues options) {
        this.options = options;
    }

    @Override
    public void run(CallTree tree) {
        String inlineOnly = TruffleCompilerOptions.InlineOnly.getValue(this.options);
        for (CallNode child : tree.getRoot().getChildren()) {
            if (!InliningPolicy.acceptForInline(child, inlineOnly) || !child.isTrivial()) continue;
            child.expand();
            if (child.getState() != CallNode.State.Expanded) continue;
            child.inline();
        }
    }
}

