/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ExpirationTracker {
    private final long fileNum;
    private volatile Map<Integer, AtomicInteger> map = new HashMap<Integer, AtomicInteger>();
    private AtomicInteger pendingTrackCalls = new AtomicInteger(0);

    public ExpirationTracker(long fileNum) {
        this.fileNum = fileNum;
    }

    public long getFileNum() {
        return this.fileNum;
    }

    public void track(LogEntry entry, int size) {
        this.pendingTrackCalls.decrementAndGet();
        LogEntryType type = entry.getLogType();
        if (type.isUserLNType()) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            int expiration = lnEntry.getExpiration();
            if (expiration == 0) {
                return;
            }
            this.track(expiration, lnEntry.isExpirationInHours(), size);
            return;
        }
        if (!type.equals(LogEntryType.LOG_BIN) && !type.equals(LogEntryType.LOG_BIN_DELTA)) {
            return;
        }
        INLogEntry inEntry = (INLogEntry)entry;
        BIN bin = inEntry.getBINWithExpiration();
        if (bin == null) {
            return;
        }
        boolean inHours = bin.isExpirationInHours();
        int entrySize = size / bin.getNEntries();
        for (int i = 0; i < bin.getNEntries(); ++i) {
            int expiration = bin.getExpiration(i);
            if (expiration == 0) continue;
            this.track(expiration, inHours, entrySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void track(int expiration, boolean expirationInHours, int size) {
        Integer expInHours = expirationInHours ? expiration : 24 * expiration;
        AtomicInteger counter = this.map.get(expInHours);
        if (counter == null) {
            ExpirationTracker expirationTracker = this;
            synchronized (expirationTracker) {
                counter = this.map.get(expInHours);
                if (counter == null) {
                    HashMap<Integer, AtomicInteger> newMap = new HashMap<Integer, AtomicInteger>(this.map);
                    counter = new AtomicInteger(0);
                    newMap.put(expInHours, counter);
                    this.map = newMap;
                }
            }
        }
        counter.addAndGet(size);
    }

    public void incrementPendingTrackCalls() {
        this.pendingTrackCalls.incrementAndGet();
    }

    boolean hasPendingTrackCalls() {
        return this.pendingTrackCalls.get() > 0;
    }

    public int getExpiredBytes(long time) {
        int expLimit = (int)(time / 3600000L);
        int expiredSize = 0;
        for (Map.Entry<Integer, AtomicInteger> entry : this.map.entrySet()) {
            int exp = entry.getKey();
            if (exp > expLimit) continue;
            expiredSize += entry.getValue().get();
        }
        return expiredSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ExpTracker file= ").append(this.fileNum);
        for (Map.Entry<Integer, AtomicInteger> entry : new TreeMap<Integer, AtomicInteger>(this.map).entrySet()) {
            int exp = entry.getKey();
            sb.append(' ').append(TTL.formatExpiration(exp, true));
            sb.append('=').append(entry.getValue().get());
        }
        sb.append('}');
        return sb.toString();
    }

    public static String toString(byte[] serializedForm) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ExpSerialized");
        TupleInput in = new TupleInput(serializedForm, 1, serializedForm.length - 1);
        boolean hours = ExpirationTracker.isExpirationInHours(serializedForm);
        int prevExp = 0;
        while (in.available() > 0) {
            int exp = in.readPackedInt() + prevExp;
            int size = in.readPackedInt();
            sb.append(' ').append(TTL.formatExpiration(exp, hours));
            sb.append('=').append(size);
            prevExp = exp;
        }
        sb.append('}');
        return sb.toString();
    }

    static int getExpiredBytes(byte[] serializedForm, int dayLimit, int hourLimit) {
        int exp;
        int expLimit = ExpirationTracker.isExpirationInHours(serializedForm) ? hourLimit : dayLimit;
        TupleInput in = new TupleInput(serializedForm, 1, serializedForm.length - 1);
        int expiredSize = 0;
        int prevExp = 0;
        while (in.available() > 0 && (exp = in.readPackedInt() + prevExp) <= expLimit) {
            expiredSize += in.readPackedInt();
            prevExp = exp;
        }
        return expiredSize;
    }

    byte[] serialize() {
        Map<Integer, AtomicInteger> myMap = this.map;
        if (myMap.isEmpty()) {
            return Key.EMPTY_KEY;
        }
        ArrayList<Integer> expList = new ArrayList<Integer>(myMap.size());
        expList.addAll(myMap.keySet());
        Collections.sort(expList);
        boolean hours = false;
        Iterator iterator = expList.iterator();
        while (iterator.hasNext()) {
            int exp = (Integer)iterator.next();
            if (exp % 24 == 0) continue;
            hours = true;
            break;
        }
        TupleOutput out = new TupleOutput();
        out.write(hours ? 1 : 0);
        int prevExp = 0;
        Iterator iterator2 = expList.iterator();
        while (iterator2.hasNext()) {
            int exp = (Integer)iterator2.next();
            AtomicInteger counter = myMap.get(exp);
            if (!hours) {
                exp /= 24;
            }
            out.writePackedInt(exp - prevExp);
            out.writePackedInt(counter.get());
            prevExp = exp;
        }
        return out.toByteArray();
    }

    static boolean isExpirationInHours(byte[] serialized) {
        return serialized[0] == 1;
    }
}

