/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.CPUSamplerData;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

final class SVGSamplerOutput {
    private final StringBuilder output;
    private static double MINWIDTH = 3.0;
    private static double IMAGEWIDTH = 1200.0;
    private static double XPAD = 10.0;
    private static double FRAMEHEIGHT = 16.0;

    public static void printSamplingFlameGraph(PrintStream out, List<CPUSamplerData> data) {
        GraphOwner graph = new GraphOwner(new StringBuilder(), data);
        graph.addComponent(new SVGFlameGraph(graph));
        graph.addComponent(new SVGHistogram(graph));
        graph.generateSVG();
        out.print(graph.svg.toString());
    }

    SVGSamplerOutput(StringBuilder output) {
        this.output = output;
    }

    public void header(double width, double height) {
        this.output.append("<?xml version=\"1.0\" standalone=\"no\"?>\n");
        this.output.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
        this.output.append(String.format(Locale.ROOT, "<svg version=\"1.1\" width=\"%1$f\" height=\"%2$f\" onload=\"init(evt)\" viewBox=\"0 0 %1$f %2$f\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n", width, height));
    }

    public void include(String data) {
        this.output.append(data);
    }

    public static String allocateColor(int r, int g, int b) {
        return String.format(Locale.ROOT, "rgb(%d, %d, %d)", r, g, b);
    }

    public static String startGroup(Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        result.append("<g ");
        for (String key : new String[]{"class", "style", "onmouseover", "onmouseout", "onclick", "id"}) {
            if (!attributes.containsKey(key)) continue;
            result.append(String.format(Locale.ROOT, "%s=\"%s\"", key, attributes.get(key)));
            result.append(" ");
        }
        result.append(">\n");
        if (attributes.containsKey("g_extra")) {
            result.append(attributes.get("g_extra"));
        }
        if (attributes.containsKey("title")) {
            result.append(String.format(Locale.ROOT, "<title>%s</title>", attributes.get("title")));
        }
        if (attributes.containsKey("href")) {
            result.append(String.format(Locale.ROOT, "<a xlink:href=%s", attributes.get("href")));
            String target = attributes.containsKey("target") ? attributes.get("target") : "_top";
            result.append(String.format(Locale.ROOT, " target=%s", target));
        }
        return result.toString();
    }

    public static String endGroup(Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        if (attributes.containsKey("href")) {
            result.append("</a>\n");
        }
        result.append("</g>\n");
        return result.toString();
    }

    public static String startSubDrawing(Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        result.append("<svg ");
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            result.append(String.format(Locale.ROOT, "%s=\"%s\"", e.getKey(), e.getValue()));
            result.append(" ");
        }
        result.append(">\n");
        return result.toString();
    }

    public static String endSubDrawing() {
        StringBuilder result = new StringBuilder();
        result.append("</svg>\n");
        return result.toString();
    }

    public static String fillRectangle(double x1, double y1, double w, double h, String fill, String extras, Map<String, String> attributes) {
        StringBuilder result = new StringBuilder();
        result.append(String.format(Locale.ROOT, "<rect x=\"%f\" y=\"%f\" width=\"%f\" height=\"%f\" fill=\"%s\" %s", x1, y1, w, h, fill, extras));
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            result.append(String.format(Locale.ROOT, " %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        result.append("/>\n");
        return result.toString();
    }

    public static String ttfString(String color, String font, double size, double x, double y, String text, String loc, String extras) {
        return String.format(Locale.ROOT, "<text text-anchor=\"%s\" x=\"%f\" y=\"%f\" font-size=\"%f\" font-family=\"%s\" fill=\"%s\" %s >%s</text>\n", loc == null ? "left" : loc, x, y, size, font, color, extras == null ? "" : extras, SVGSamplerOutput.escape(text));
    }

    public void close() {
        this.output.append("</svg>");
    }

    public String toString() {
        return this.output.toString();
    }

    public static String escape(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String black() {
        return SVGSamplerOutput.allocateColor(0, 0, 0);
    }

    private static class GraphOwner
    implements SVGComponent {
        private final SVGSamplerOutput svg;
        private final List<CPUSamplerData> data;
        private ArrayList<SVGComponent> components;
        private Random random = new Random();
        private Map<GraphColorMap, String> languageColors;
        private Map<GraphColorMap, Map<SampleKey, String>> colorsForKeys = new HashMap<GraphColorMap, Map<SampleKey, String>>();
        private int sampleId;
        public final Map<String, Integer> nameHash = new HashMap<String, Integer>();
        public final Map<String, Integer> sourceHash = new HashMap<String, Integer>();
        public final Map<SampleKey, Integer> keyHash = new HashMap<SampleKey, Integer>();
        public final ArrayList<SampleKey> sampleKeys = new ArrayList();
        public int nameCounter = 0;
        public int sourceCounter = 0;
        public int keyCounter = 0;
        public final JSONArray sampleNames = new JSONArray();
        public final JSONArray sourceNames = new JSONArray();
        public final JSONArray sampleJsonKeys = new JSONArray();
        public final JSONArray sampleData = new JSONArray();
        private HashMap<Integer, HashMap<SampleKey, JSONObject>> recursiveChildMap = new HashMap();

        GraphOwner(StringBuilder output, List<CPUSamplerData> data) {
            this.svg = new SVGSamplerOutput(output);
            this.data = data;
            this.components = new ArrayList();
            this.languageColors = new HashMap<GraphColorMap, String>();
            this.languageColors.put(GraphColorMap.GRAY, "<none>");
            this.buildSampleData();
        }

        public String background1() {
            return "#eeeeee";
        }

        public String background2() {
            return "#eeeeb0";
        }

        public void generateSVG() {
            this.initSVG();
            this.svg.include(this.css());
            this.svg.include(this.script());
            this.svg.include(this.drawCanvas(0.0, 0.0));
            this.svg.close();
        }

        public void addComponent(SVGComponent component) {
            this.components.add(component);
        }

        public void initSVG() {
            this.svg.header(this.width(), this.height());
        }

        @Override
        public String css() {
            StringBuilder css = new StringBuilder();
            css.append("<defs>\n");
            css.append("    <linearGradient id=\"background\" y1=\"0\" y2=\"1\" x1=\"0\" x2=\"0\" >\n");
            css.append(String.format(Locale.ROOT, "        <stop stop-color=\"%s\" offset=\"5%%\" />\n", this.background1()));
            css.append(String.format(Locale.ROOT, "        <stop stop-color=\"%s\" offset=\"95%%\" />\n", this.background2()));
            css.append("    </linearGradient>\n");
            css.append("</defs>\n");
            css.append("<style type=\"text/css\">\n");
            for (SVGComponent component : this.components) {
                css.append(component.css());
            }
            css.append("</style>\n");
            return css.toString();
        }

        @Override
        public String script() {
            StringBuilder result = new StringBuilder();
            result.append("<script type=\"text/ecmascript\">\n<![CDATA[\n");
            result.append(this.getResource("graphowner.js"));
            result.append("'use strict';\n");
            result.append(String.format(Locale.ROOT, "var fontSize = %s;\n", this.fontSize()));
            result.append(String.format(Locale.ROOT, "var fontWidth = %s;\n", this.fontWidth()));
            result.append(this.samples());
            result.append(this.resizeFunction());
            result.append(this.initFunction("evt"));
            result.append(this.searchFunction("term"));
            result.append(this.resetSearchFunction());
            result.append(this.colorChangeFunction());
            for (SVGComponent component : this.components) {
                result.append(component.script());
            }
            result.append("]]>\n</script>");
            return result.toString();
        }

        private void buildSampleData() {
            ArrayDeque<Task> tasks = new ArrayDeque<Task>();
            JSONObject root = new JSONObject();
            this.sampleData.put((Object)root);
            root.put("k", this.indexForSampleKey("Thread: <top>", "<none>", 0));
            root.put("id", this.sampleId++);
            root.put("i", 0);
            root.put("c", 0);
            root.put("x", 0);
            root.put("l", GraphColorMap.GRAY.ordinal());
            long totalSamples = 0L;
            JSONArray children = new JSONArray();
            for (CPUSamplerData value : this.data) {
                for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> node : value.getThreadData().entrySet()) {
                    Thread thread = node.getKey();
                    totalSamples += this.threadSampleData(thread, node.getValue(), tasks, children, totalSamples);
                }
            }
            root.put("h", totalSamples);
            root.put("s", (Object)children);
            Task task = (Task)tasks.poll();
            while (task != null) {
                this.processSample(task, tasks);
                task = tasks.poll();
            }
            this.buildColorData();
            this.buildRecursiveData();
        }

        private int indexForSampleKey(String name, SourceSection section) {
            String sourceName;
            int sourceLine = 0;
            if (section != null && section.isAvailable()) {
                String path;
                sourceLine = section.getStartLine();
                Source source = section.getSource();
                sourceName = source != null ? ((path = source.getPath()) != null ? path : source.getName()) : "<none>";
            } else {
                sourceName = "<none>";
            }
            return this.indexForSampleKey(name, sourceName, sourceLine);
        }

        private int indexForSampleKey(String name, String sourceFile, int line) {
            int nameId = this.nameHash.computeIfAbsent(name, k -> {
                this.sampleNames.put(k);
                return this.nameCounter++;
            });
            int sourceId = this.sourceHash.computeIfAbsent(sourceFile, k -> {
                this.sourceNames.put(k);
                return this.sourceCounter++;
            });
            return this.keyHash.computeIfAbsent(new SampleKey(nameId, sourceId, line), k -> {
                this.sampleKeys.add((SampleKey)k);
                JSONArray jsonKey = new JSONArray();
                jsonKey.put(k.nameId);
                jsonKey.put(k.sourceId);
                jsonKey.put(k.sourceLine);
                this.sampleJsonKeys.put((Object)jsonKey);
                return this.keyCounter++;
            });
        }

        private HashMap<SampleKey, JSONObject> childrenByKeyForSample(JSONObject sample) {
            return this.recursiveChildMap.computeIfAbsent(sample.getInt("id"), k -> {
                HashMap childMap = new HashMap();
                return childMap;
            });
        }

        private void buildRecursiveData() {
            for (Object sample : this.sampleData) {
                this.calculateRecursiveData((JSONObject)sample);
            }
            ArrayDeque<RecursivePositionTask> tasks = new ArrayDeque<RecursivePositionTask>();
            RecursivePositionTask task = new RecursivePositionTask(this.sampleDataForId(0), 0L);
            while (task != null) {
                task.sample.put("rx", task.x);
                if (task.sample.has("rs")) {
                    long offset = task.x + (long)task.sample.getInt("ri") + (long)task.sample.getInt("rc");
                    for (Object childId : task.sample.getJSONArray("rs")) {
                        JSONObject child = this.sampleDataForId((Integer)childId);
                        tasks.add(new RecursivePositionTask(child, offset));
                        offset += (long)child.getInt("rh");
                    }
                }
                task = (RecursivePositionTask)tasks.poll();
            }
        }

        private void calculateRecursiveData(JSONObject sample) {
            if (sample.has("p")) {
                JSONObject parent = this.sampleDataForId(sample.getInt("p"));
                JSONObject owner = parent.has("ro") ? this.sampleDataForId(parent.getInt("ro")) : parent;
                if (parent.getInt("k") == sample.getInt("k")) {
                    GraphOwner.mergeCounts(owner, sample, true);
                } else {
                    SampleKey key;
                    HashMap<SampleKey, JSONObject> siblings = this.childrenByKeyForSample(owner);
                    if (siblings.containsKey(key = this.sampleKeys.get(sample.getInt("k")))) {
                        JSONObject sibling = siblings.get(key);
                        GraphOwner.mergeCounts(sibling, sample, false);
                    } else {
                        siblings.put(key, sample);
                        GraphOwner.addRecursiveChild(owner, sample);
                    }
                    sample.put("rp", owner.getInt("id"));
                }
            } else {
                sample.put("rc", sample.getInt("c"));
                sample.put("ri", sample.getInt("i"));
                sample.put("rh", sample.getInt("h"));
            }
        }

        private static void addRecursiveChild(JSONObject sample, JSONObject child) {
            JSONArray children;
            if (!sample.has("rs")) {
                children = new JSONArray();
                sample.put("rs", (Object)children);
            } else {
                children = sample.getJSONArray("rs");
            }
            children.put(child.getInt("id"));
            child.put("rc", child.getInt("c"));
            child.put("ri", child.getInt("i"));
            child.put("rh", child.getInt("h"));
        }

        private static void mergeCounts(JSONObject a, JSONObject b, boolean child) {
            int aRI = a.has("ri") ? a.getInt("ri") : a.getInt("i");
            int aRC = a.has("rc") ? a.getInt("rc") : a.getInt("c");
            int aRH = a.has("rh") ? a.getInt("rh") : a.getInt("h");
            aRI += b.getInt("i");
            aRC += b.getInt("c");
            if (!child) {
                aRH += b.getInt("h");
            }
            a.put("ri", aRI);
            a.put("rc", aRC);
            a.put("rh", aRH);
            b.put("ro", a.getInt("id"));
        }

        private long threadSampleData(Thread thread, Collection<ProfilerNode<CPUSampler.Payload>> samples, ArrayDeque<Task> tasks, JSONArray siblings, long x) {
            JSONObject threadSample = new JSONObject();
            long totalSamples = 0L;
            int id = this.sampleId++;
            threadSample.put("k", this.indexForSampleKey(thread.getName(), "<none>", 0));
            threadSample.put("id", id);
            threadSample.put("p", 0);
            this.sampleData.put((Object)threadSample);
            threadSample.put("i", 0);
            threadSample.put("c", 0);
            threadSample.put("l", GraphColorMap.GRAY.ordinal());
            threadSample.put("x", x);
            JSONArray children = new JSONArray();
            long childCount = 0L;
            for (ProfilerNode<CPUSampler.Payload> sample : samples) {
                tasks.addLast(new Task(sample, children, totalSamples + x, id));
                totalSamples += (long)sample.getPayload().getHitCount();
                ++childCount;
            }
            threadSample.put("h", totalSamples);
            if (childCount > 0L) {
                threadSample.put("s", (Object)children);
            }
            siblings.put(threadSample.getInt("id"));
            return totalSamples;
        }

        private String samples() {
            StringBuilder result = new StringBuilder();
            result.append("var profileNames = ");
            result.append(this.sampleNames.toString());
            result.append(";\n");
            result.append("var sourceNames = ");
            result.append(this.sourceNames.toString());
            result.append(";\n");
            result.append("var sampleKeys = ");
            result.append(this.sampleJsonKeys.toString());
            result.append(";\n");
            result.append("var profileData = ");
            result.append(this.sampleData.toString());
            result.append(";\n");
            result.append("var colorData = ");
            JSONArray colors = new JSONArray();
            for (GraphColorMap cm : GraphColorMap.values()) {
                if (this.colorsForKeys.containsKey((Object)cm)) {
                    JSONObject map = new JSONObject();
                    for (Map.Entry<SampleKey, String> e : this.colorsForKeys.get((Object)cm).entrySet()) {
                        map.put(this.keyHash.get(e.getKey()).toString(), (Object)e.getValue());
                    }
                    colors.put((Object)map);
                    continue;
                }
                colors.put((Object)new JSONObject());
            }
            result.append(colors.toString());
            result.append(";\n");
            result.append("var languageNames = ");
            JSONArray languageNames = new JSONArray();
            for (GraphColorMap cm : GraphColorMap.values()) {
                if (this.languageColors.containsKey((Object)cm)) {
                    languageNames.put((Object)this.languageColors.get((Object)cm));
                    continue;
                }
                languageNames.put((Object)"");
            }
            result.append(languageNames.toString());
            result.append(";\n");
            return result.toString();
        }

        private void processSample(Task task, ArrayDeque<Task> tasks) {
            JSONObject result = new JSONObject();
            result.put("k", this.indexForSampleKey(task.sample.getRootName(), task.sample.getSourceSection()));
            int id = this.sampleId++;
            result.put("id", id);
            result.put("p", task.parent);
            this.sampleData.put((Object)result);
            result.put("i", task.sample.getPayload().getTierSelfCount(0));
            int compiledSelfHits = 0;
            for (int i = 1; i < task.sample.getPayload().getNumberOfTiers(); ++i) {
                compiledSelfHits += task.sample.getPayload().getTierSelfCount(i);
            }
            result.put("c", compiledSelfHits);
            result.put("h", task.sample.getPayload().getHitCount());
            result.put("l", this.colorMapForLanguage(task.sample).ordinal());
            result.put("x", task.x);
            JSONArray children = new JSONArray();
            int childCount = 0;
            long offset = task.sample.getPayload().getSelfHitCount();
            for (ProfilerNode<CPUSampler.Payload> child : task.sample.getChildren()) {
                tasks.addLast(new Task(child, children, task.x + offset, id));
                offset += (long)child.getPayload().getHitCount();
                ++childCount;
            }
            if (childCount > 0) {
                result.put("s", (Object)children);
            }
            task.siblings.put(result.getInt("id"));
        }

        protected JSONObject sampleDataForId(int id) {
            return (JSONObject)this.sampleData.get(id);
        }

        protected String nameForKeyId(int keyId) {
            SampleKey key = this.sampleKeys.get(keyId);
            return this.sampleNames.getString(key.nameId);
        }

        private void buildColorData() {
            for (Object sample : this.sampleData) {
                this.buildColorDataForSample((JSONObject)sample);
            }
        }

        private void buildColorDataForSample(JSONObject sample) {
            this.colorForKey(sample.getInt("k"), GraphColorMap.FLAME);
            this.colorForKey(sample.getInt("k"), GraphColorMap.values()[sample.getInt("l")]);
        }

        @Override
        public String initFunction(String argName) {
            StringBuilder result = new StringBuilder();
            result.append(String.format(Locale.ROOT, "function init(%s) {\n", argName));
            for (SVGComponent component : this.components) {
                result.append(component.initFunction(argName));
            }
            result.append("resize();\n");
            result.append("}\n");
            return result.toString();
        }

        @Override
        public String resizeFunction() {
            StringBuilder result = new StringBuilder();
            result.append("function resize() {\n");
            result.append("owner_resize(document.firstElementChild.clientWidth);\n");
            for (SVGComponent component : this.components) {
                result.append(component.resizeFunction());
            }
            result.append("}\n");
            result.append("window.onresize = resize;\n");
            return result.toString();
        }

        @Override
        public String searchFunction(String argName) {
            StringBuilder result = new StringBuilder();
            result.append(String.format(Locale.ROOT, "var searchColor = \"%s\";\n", this.searchColor()));
            result.append(this.getResource("search.js"));
            result.append(String.format(Locale.ROOT, "function search(%s) {\n", argName));
            for (SVGComponent component : this.components) {
                result.append(component.searchFunction(argName));
            }
            result.append("}\n");
            return result.toString();
        }

        @Override
        public String resetSearchFunction() {
            StringBuilder result = new StringBuilder();
            result.append("    function reset_search() {\n");
            for (SVGComponent component : this.components) {
                result.append(component.resetSearchFunction());
            }
            result.append("}\n");
            return result.toString();
        }

        private String colorChangeFunction() {
            StringBuilder result = new StringBuilder();
            result.append(this.getResource("color_change.js"));
            return result.toString();
        }

        @Override
        public String drawCanvas(double x, double y) {
            double offset = y;
            StringBuilder canvas = new StringBuilder();
            for (SVGComponent component : this.components) {
                canvas.append(component.drawCanvas(x, offset));
                offset += component.height();
            }
            return canvas.toString();
        }

        public Map<SampleKey, String> colorsForType(GraphColorMap type) {
            if (this.colorsForKeys.containsKey((Object)type)) {
                return this.colorsForKeys.get((Object)type);
            }
            HashMap<SampleKey, String> colors = new HashMap<SampleKey, String>();
            this.colorsForKeys.put(type, colors);
            return colors;
        }

        public String colorForKey(int keyId, GraphColorMap type) {
            SampleKey key = this.sampleKeys.get(keyId);
            Map<SampleKey, String> colors = this.colorsForType(type);
            if (colors.containsKey(key)) {
                return colors.get(key);
            }
            int r = 0;
            int g = 9;
            int b = 0;
            double v1 = this.random.nextDouble();
            double v2 = this.random.nextDouble();
            double v3 = this.random.nextDouble();
            switch (type) {
                case FLAME: {
                    r = (int)(200.0 + 35.0 * v3);
                    g = (int)(100.0 + 100.0 * v1);
                    b = (int)(30.0 + 50.0 * v2);
                    break;
                }
                case RED: {
                    r = (int)(200.0 + 55.0 * v1);
                    b = g = (int)(80.0 * v1);
                    break;
                }
                case ORANGE: {
                    r = (int)(190.0 + 65.0 * v1);
                    g = (int)(90.0 + 65.0 * v1);
                    b = 0;
                    break;
                }
                case YELLOW: {
                    g = r = (int)(175.0 + 55.0 * v1);
                    b = (int)(50.0 + 20.0 * v1);
                    break;
                }
                case GREEN: {
                    g = (int)(200.0 + 55.0 * v1);
                    b = r = (int)(80.0 * v1);
                    break;
                }
                case AQUA: {
                    r = (int)(50.0 + 60.0 * v1);
                    g = (int)(165.0 + 55.0 * v1);
                    b = (int)(165.0 + 55.0 * v1);
                    break;
                }
                case BLUE: {
                    g = r = (int)(80.0 * v1);
                    b = (int)(200.0 + 55.0 * v1);
                    break;
                }
                case PURPLE: {
                    r = (int)(190.0 + 65.0 * v1);
                    g = (int)(80.0 + 60.0 * v1);
                    b = r;
                    break;
                }
                case GRAY: {
                    g = r = (int)(175.0 + 55.0 * v1);
                    b = r;
                }
            }
            String color = SVGSamplerOutput.allocateColor(r, g, b);
            colors.put(key, color);
            return color;
        }

        public GraphColorMap colorMapForLanguage(ProfilerNode<CPUSampler.Payload> sample) {
            Source source;
            String language = "<none>";
            SourceSection section = sample.getSourceSection();
            if (section != null && (source = section.getSource()) != null) {
                language = source.getLanguage();
            }
            GraphColorMap color = GraphColorMap.GRAY;
            if (this.languageColors.containsValue(language)) {
                for (Map.Entry<GraphColorMap, String> entry : this.languageColors.entrySet()) {
                    if (!language.equals(entry.getValue())) continue;
                    color = entry.getKey();
                    break;
                }
            } else {
                for (GraphColorMap key : GraphColorMap.values()) {
                    if (key == GraphColorMap.FLAME || this.languageColors.containsKey((Object)key)) continue;
                    color = key;
                    this.languageColors.put(key, language);
                    break;
                }
            }
            return color;
        }

        public String searchColor() {
            return "rgb(255, 0, 255)";
        }

        @Override
        public double width() {
            return this.components.stream().mapToDouble(c -> c.width()).reduce((a, b) -> Math.max(a, b)).orElse(0.0);
        }

        @Override
        public double height() {
            return this.components.stream().mapToDouble(c -> c.height()).reduce((a, b) -> a + b).orElse(0.0);
        }

        public String fontName() {
            return "Verdana";
        }

        public double fontSize() {
            return 12.0;
        }

        public double fontWidth() {
            return 0.5;
        }

        public String abbreviate(String fullText, double width) {
            int textLength = (int)(width / (this.fontSize() * this.fontWidth()));
            Object text = textLength > fullText.length() ? fullText : (textLength >= 3 ? fullText.substring(0, textLength - 2) + "..." : "");
            return text;
        }

        public String getResource(String name) {
            StringBuilder resource = new StringBuilder();
            try (InputStream stream = SVGHistogram.class.getResourceAsStream("resources/" + name);
                 Scanner scanner = new Scanner(stream);){
                while (scanner.hasNextLine()) {
                    resource.append(scanner.nextLine());
                    resource.append('\n');
                }
            }
            catch (IOException e) {
                throw new Error("Resources are missing from this build.");
            }
            return resource.toString();
        }

        private static final class Task {
            final ProfilerNode<CPUSampler.Payload> sample;
            final JSONArray siblings;
            final long x;
            final int parent;

            Task(ProfilerNode<CPUSampler.Payload> sample, JSONArray siblings, long x, int parent) {
                this.sample = sample;
                this.siblings = siblings;
                this.x = x;
                this.parent = parent;
            }
        }

        private static final class SampleKey {
            int nameId;
            int sourceId;
            int sourceLine;

            SampleKey(int nameId, int sourceId, int sourceLine) {
                this.nameId = nameId;
                this.sourceId = sourceId;
                this.sourceLine = sourceLine;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.nameId;
                result = 31 * result + this.sourceId;
                result = 31 * result + this.sourceLine;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SampleKey other = (SampleKey)obj;
                if (this.nameId != other.nameId) {
                    return false;
                }
                if (this.sourceId != other.sourceId) {
                    return false;
                }
                return this.sourceLine == other.sourceLine;
            }
        }

        private static final class RecursivePositionTask {
            JSONObject sample;
            long x;

            RecursivePositionTask(JSONObject sample, long x) {
                this.sample = sample;
                this.x = x;
            }
        }
    }

    private static class SVGFlameGraph
    implements SVGComponent {
        private final GraphOwner owner;
        private final double bottomPadding;
        private final double topPadding;
        private final int maxDepth;
        private final double widthPerTime;
        private final long sampleCount;

        SVGFlameGraph(GraphOwner owner) {
            this.owner = owner;
            this.bottomPadding = 2.0 * owner.fontSize() + 10.0;
            this.topPadding = 3.0 * owner.fontSize();
            this.sampleCount = owner.sampleDataForId(0).getInt("h");
            this.widthPerTime = (this.width() - 2.0 * XPAD) / (double)this.sampleCount;
            this.maxDepth = this.maxDepth(owner.sampleDataForId(0));
        }

        private int maxDepth(JSONObject samples) {
            double width = this.sampleWidth(samples);
            if (width < MINWIDTH) {
                return 0;
            }
            int childDepth = 0;
            if (samples.has("rs")) {
                for (Object child : samples.getJSONArray("rs")) {
                    childDepth = Integer.max(childDepth, this.maxDepth(this.owner.sampleDataForId((Integer)child)));
                }
            }
            return childDepth + 1;
        }

        @Override
        public String css() {
            return ".func_g:hover { stroke:black; stroke-width:0.5; cursor:pointer; }";
        }

        @Override
        public String script() {
            StringBuilder script = new StringBuilder();
            script.append(String.format(Locale.ROOT, "var xpad = %s;\nvar fg_width = 1200;\nvar fg_bottom_padding = %s;\nvar fg_min_width = %s;\n", XPAD, this.bottomPadding, MINWIDTH));
            script.append(String.format(Locale.ROOT, "var fg_frameheight = %s;\nvar fg_top_padding = %s;", FRAMEHEIGHT, this.topPadding));
            script.append(this.owner.getResource("flamegraph.js"));
            return script.toString();
        }

        @Override
        public String drawCanvas(double x, double y) {
            StringBuilder output = new StringBuilder();
            HashMap<String, String> svgattr = new HashMap<String, String>();
            svgattr.put("x", Double.toString(x));
            svgattr.put("y", Double.toString(y));
            svgattr.put("wdith", Double.toString(this.width()));
            svgattr.put("height", Double.toString(this.height()));
            svgattr.put("viewBox", String.format(Locale.ROOT, "0.0 -%f %f %f", this.height(), this.width(), this.height()));
            output.append(SVGSamplerOutput.startSubDrawing(svgattr));
            HashMap<String, String> attr = new HashMap<String, String>();
            HashMap<String, String> canvasAttr = new HashMap<String, String>();
            attr.put("id", "flamegraph");
            canvasAttr.put("id", "fg_canvas");
            output.append(SVGSamplerOutput.startGroup(attr));
            output.append(SVGSamplerOutput.fillRectangle(0.0, -this.height(), this.width(), this.height(), "url(#background)", "", canvasAttr));
            output.append(this.drawTree());
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize(), XPAD, -(this.bottomPadding / 2.0), " ", "", "id=\"details\""));
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize(), this.width() - XPAD - 100.0, -(this.bottomPadding / 2.0), " ", "", "id=\"matched\" onclick=\"search_prompt()\""));
            output.append(SVGSamplerOutput.endGroup(attr));
            output.append(SVGSamplerOutput.endSubDrawing());
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize() + 5.0, this.width() / 2.0, this.owner.fontSize() * 2.0, "Flamegraph", "middle", "id=\"fg_title\""));
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize(), this.width() / 2.0, this.owner.fontSize() * 3.0, "Press \"?\" for legend and help.", "middle", "id=\"fg_help\""));
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize(), XPAD, this.owner.fontSize() * 2.0, "Reset zoom", "", "id=\"unzoom\" onclick=\"unzoom()\" style=\"opacity:0.1;cursor:pointer\""));
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize(), this.width() - XPAD, this.owner.fontSize() * 2.0, "Search", "end", "id=\"search\"  onclick=\"search_prompt()\" onmouseover=\"fg_searchover()\" onmouseout=\"fg_searchout()\""));
            return output.toString();
        }

        private String drawTree() {
            StringBuilder output = new StringBuilder();
            double baseY = -FRAMEHEIGHT - this.bottomPadding;
            output.append(this.drawSamples(baseY, this.owner.sampleDataForId(0)));
            return output.toString();
        }

        private double sampleWidth(JSONObject sample) {
            long hitCount = sample.getInt("rh");
            return this.widthPerTime * (double)hitCount;
        }

        private double sampleX(JSONObject sample) {
            long x = sample.getInt("rx");
            return this.widthPerTime * (double)x + XPAD;
        }

        private String drawSamples(double y, JSONObject root) {
            ArrayDeque<DrawTask> tasks = new ArrayDeque<DrawTask>();
            StringBuilder output = new StringBuilder();
            DrawTask task = new DrawTask(root, 0);
            while (task != null) {
                output.append(this.drawSample(y, task, tasks));
                task = tasks.poll();
            }
            return output.toString();
        }

        private String drawSample(double baseY, DrawTask task, ArrayDeque<DrawTask> tasks) {
            StringBuilder output = new StringBuilder();
            JSONObject sample = task.sample;
            int depth = task.depth;
            double y = baseY - (double)depth * FRAMEHEIGHT;
            double width = this.sampleWidth(sample);
            double x = this.sampleX(sample);
            if (width < MINWIDTH) {
                return "";
            }
            HashMap<String, String> groupAttrs = new HashMap<String, String>();
            int id = sample.getInt("id");
            String fullText = this.owner.nameForKeyId(sample.getInt("k"));
            GraphOwner.SampleKey key = this.owner.sampleKeys.get(sample.getInt("k"));
            groupAttrs.put("class", "func_g");
            groupAttrs.put("onclick", id == 0 ? "unzoom()" : "zoom(this)");
            groupAttrs.put("onmouseover", "s(this)");
            groupAttrs.put("onmouseout", "c(this)");
            groupAttrs.put("id", "f_" + Integer.toString(id));
            StringBuilder title = new StringBuilder();
            title.append(fullText);
            title.append("\n");
            int interpreted = sample.getInt("i");
            int compiled = sample.getInt("c");
            int total = sample.getInt("h");
            double percent = 100.0 * (double)(compiled + interpreted) / (double)this.sampleCount;
            double totalPercent = 100.0 * (double)total / (double)this.sampleCount;
            title.append(String.format(Locale.ROOT, "Self samples: %d (%.2f%%)\n", interpreted + compiled, percent));
            title.append(String.format(Locale.ROOT, "total samples:  %d (%.2f%%)\n", total, totalPercent));
            title.append(String.format(Locale.ROOT, "Source location: %s:%d\n", this.owner.sourceNames.get(key.sourceId), key.sourceLine));
            groupAttrs.put("title", SVGSamplerOutput.escape(title.toString()));
            output.append(SVGSamplerOutput.startGroup(groupAttrs));
            HashMap<String, String> rectAttrs = new HashMap<String, String>();
            output.append(SVGSamplerOutput.fillRectangle(x, y, width, FRAMEHEIGHT, this.owner.colorForKey(sample.getInt("k"), GraphColorMap.FLAME), "rx=\"2\" ry=\"2\"", rectAttrs));
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize(), x + 3.0, y - 5.0 + FRAMEHEIGHT, this.owner.abbreviate(fullText, width), null, ""));
            output.append(SVGSamplerOutput.endGroup(groupAttrs));
            if (sample.has("rs")) {
                JSONArray children = sample.getJSONArray("rs");
                for (Object childId : children) {
                    JSONObject child = this.owner.sampleDataForId((Integer)childId);
                    tasks.add(new DrawTask(child, depth + 1));
                }
            }
            return output.toString();
        }

        @Override
        public double width() {
            return IMAGEWIDTH;
        }

        @Override
        public double height() {
            return FRAMEHEIGHT * (double)this.maxDepth + this.topPadding + this.bottomPadding;
        }

        @Override
        public String resizeFunction() {
            return "fg_resize(document.firstElementChild.clientWidth);\n";
        }

        @Override
        public String initFunction(String argName) {
            return String.format(Locale.ROOT, "fg_init(%s)\n", argName);
        }

        @Override
        public String searchFunction(String argName) {
            return String.format(Locale.ROOT, "fg_search(%s)\n", argName);
        }

        @Override
        public String resetSearchFunction() {
            return "fg_reset_search()\n";
        }

        private static final class DrawTask {
            final JSONObject sample;
            final int depth;

            DrawTask(JSONObject sample, int depth) {
                this.sample = sample;
                this.depth = depth;
            }
        }
    }

    private static interface SVGComponent {
        public String css();

        public String script();

        public String initFunction(String var1);

        public String resizeFunction();

        public String searchFunction(String var1);

        public String resetSearchFunction();

        public String drawCanvas(double var1, double var3);

        public double width();

        public double height();
    }

    private static class SVGHistogram
    implements SVGComponent {
        private final GraphOwner owner;
        private final double titlePadding;
        private final double bottomPadding;
        private final double timeMax;
        private final double widthPerTime;
        private final List<JSONObject> histogram;
        private final long sampleCount;

        SVGHistogram(GraphOwner owner) {
            this.owner = owner;
            this.titlePadding = owner.fontSize() * 3.0;
            this.bottomPadding = owner.fontSize() * 2.0 + 10.0;
            this.histogram = this.buildHistogram(owner.sampleDataForId(0));
            this.timeMax = this.histogram.get(0).getInt("i") + this.histogram.get(0).getInt("c");
            this.widthPerTime = (this.width() - 2.0 * XPAD) / this.timeMax;
            double minTime = MINWIDTH / this.widthPerTime;
            long count = 0L;
            for (JSONObject bar : this.histogram) {
                count += (long)(bar.getInt("i") + bar.getInt("c"));
            }
            this.sampleCount = count;
            this.histogram.removeIf(x -> (double)(x.getInt("i") + x.getInt("c")) < minTime);
        }

        private List<JSONObject> buildHistogram(JSONObject sample) {
            HashMap<GraphOwner.SampleKey, JSONObject> bars = new HashMap<GraphOwner.SampleKey, JSONObject>();
            ArrayDeque<JSONObject> samples = new ArrayDeque<JSONObject>();
            JSONObject next = sample;
            while (next != null) {
                this.buildHistogram(next, samples, bars);
                next = samples.poll();
            }
            ArrayList<JSONObject> lines = new ArrayList<JSONObject>(bars.values());
            Collections.sort(lines, (a, b) -> Integer.compare(b.getInt("i") + b.getInt("c"), a.getInt("i") + a.getInt("c")));
            return lines;
        }

        private void buildHistogram(JSONObject sample, ArrayDeque<JSONObject> samples, Map<GraphOwner.SampleKey, JSONObject> bars) {
            JSONObject bar = bars.computeIfAbsent(this.owner.sampleKeys.get(sample.getInt("k")), k -> {
                JSONObject entry = new JSONObject();
                entry.put("id", sample.getInt("id"));
                entry.put("i", 0);
                entry.put("c", 0);
                entry.put("l", sample.getInt("l"));
                entry.put("k", sample.getInt("k"));
                return entry;
            });
            bar.put("i", bar.getInt("i") + sample.getInt("i"));
            bar.put("c", bar.getInt("c") + sample.getInt("c"));
            if (sample.has("s")) {
                JSONArray children = sample.getJSONArray("s");
                for (Object childId : children) {
                    samples.add(this.owner.sampleDataForId((Integer)childId));
                }
            }
        }

        @Override
        public String css() {
            return ".func_h:hover { stroke:black; stroke-width:0.5; cursor:pointer; }";
        }

        @Override
        public String script() {
            StringBuilder script = new StringBuilder();
            script.append(String.format(Locale.ROOT, "var h_width = %s;\n", this.width()));
            script.append(String.format(Locale.ROOT, "var h_minwidth = %s;\n", MINWIDTH));
            script.append(String.format(Locale.ROOT, "var h_top_padding = %s;\n", this.titlePadding));
            script.append(String.format(Locale.ROOT, "var h_bottom_padding = %s;\n", this.bottomPadding));
            script.append(String.format(Locale.ROOT, "var h_frameheight = %s;\n", FRAMEHEIGHT));
            script.append("var histogramData = ");
            JSONArray data = new JSONArray();
            for (JSONObject bar : this.histogram) {
                data.put((Object)bar);
            }
            script.append(data.toString());
            script.append(";\n");
            script.append(this.owner.getResource("histogram.js"));
            return script.toString();
        }

        @Override
        public String drawCanvas(double x, double y) {
            StringBuilder output = new StringBuilder();
            HashMap<String, String> svgattr = new HashMap<String, String>();
            svgattr.put("x", Double.toString(x));
            svgattr.put("y", Double.toString(y));
            svgattr.put("wdith", Double.toString(this.width()));
            svgattr.put("height", Double.toString(this.height()));
            svgattr.put("viewBox", String.format(Locale.ROOT, "0.0 0.0 %f %f", this.width(), this.height()));
            output.append(SVGSamplerOutput.startSubDrawing(svgattr));
            HashMap<String, String> attr = new HashMap<String, String>();
            HashMap<String, String> canvasAttr = new HashMap<String, String>();
            attr.put("id", "histogram");
            canvasAttr.put("id", "h_canvas");
            output.append(SVGSamplerOutput.startGroup(attr));
            output.append(SVGSamplerOutput.fillRectangle(0.0, 0.0, this.width(), this.height(), "url(#background)", "", canvasAttr));
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize() + 5.0, this.width() / 2.0, this.owner.fontSize() * 2.0, "Histogram", "middle", "id=\"h_title\""));
            for (int position = 0; position < this.histogram.size(); ++position) {
                output.append(this.drawElement(this.histogram.get(position), position));
            }
            output.append(SVGSamplerOutput.endGroup(attr));
            output.append(SVGSamplerOutput.endSubDrawing());
            return output.toString();
        }

        private String drawElement(JSONObject bar, int position) {
            double textX;
            String name = this.owner.nameForKeyId(bar.getInt("k"));
            long selfTime = bar.getInt("c") + bar.getInt("i");
            double width = this.widthPerTime * (double)selfTime;
            double x1 = XPAD;
            double y1 = this.titlePadding + (double)position * FRAMEHEIGHT;
            StringBuilder output = new StringBuilder();
            if (width < MINWIDTH) {
                return "";
            }
            HashMap<String, String> groupAttrs = new HashMap<String, String>();
            groupAttrs.put("class", "func_h");
            groupAttrs.put("id", "h_" + Integer.toString(position));
            groupAttrs.put("onclick", "h_highlight(this)");
            groupAttrs.put("onmouseover", "s(this)");
            groupAttrs.put("onmouseout", "c(this)");
            StringBuilder title = new StringBuilder();
            title.append("Function: ");
            title.append(name);
            title.append("\n");
            int interpreted = bar.getInt("i");
            int compiled = bar.getInt("c");
            title.append(String.format(Locale.ROOT, "%d samples (%d interpreted, %d compiled).\n", interpreted + compiled, interpreted, compiled));
            double percent = 100.0 * (double)(compiled + interpreted) / (double)this.sampleCount;
            title.append(String.format(Locale.ROOT, "%.2f%% of displayed samples.\n", percent));
            groupAttrs.put("title", SVGSamplerOutput.escape(title.toString()));
            output.append(SVGSamplerOutput.startGroup(groupAttrs));
            HashMap<String, String> rectAttrs = new HashMap<String, String>();
            output.append(SVGSamplerOutput.fillRectangle(x1, y1, width, FRAMEHEIGHT, this.owner.colorForKey(bar.getInt("k"), GraphColorMap.FLAME), "rx=\"2\" ry=\"2\"", rectAttrs));
            double afterWidth = IMAGEWIDTH - width - XPAD * 2.0;
            int textLength = (int)(width / (this.owner.fontSize() / this.owner.fontWidth()));
            int afterLength = (int)(afterWidth / (this.owner.fontSize() / this.owner.fontWidth()));
            String text = name;
            if (textLength > name.length()) {
                textX = x1 + 3.0;
            } else if (afterLength > name.length()) {
                textX = x1 + 3.0 + width;
            } else if (textLength > afterLength) {
                textX = x1 + 3.0;
                text = this.owner.abbreviate(name, width);
            } else {
                textX = x1 + 3.0 + width;
                text = this.owner.abbreviate(name, afterWidth);
            }
            output.append(SVGSamplerOutput.ttfString(SVGSamplerOutput.black(), this.owner.fontName(), this.owner.fontSize(), textX, y1 - 5.0 + FRAMEHEIGHT, text, null, ""));
            output.append(SVGSamplerOutput.endGroup(groupAttrs));
            return output.toString();
        }

        @Override
        public double width() {
            return IMAGEWIDTH;
        }

        @Override
        public double height() {
            return (double)this.histogram.size() * FRAMEHEIGHT + this.titlePadding + this.bottomPadding;
        }

        @Override
        public String resizeFunction() {
            return "h_resize(document.firstElementChild.clientWidth);\n";
        }

        @Override
        public String initFunction(String argName) {
            return String.format(Locale.ROOT, "h_init(%s)\n", argName);
        }

        @Override
        public String searchFunction(String argName) {
            return String.format(Locale.ROOT, "h_search(%s)\n", argName);
        }

        @Override
        public String resetSearchFunction() {
            return "h_reset_search()\n";
        }
    }

    private static enum GraphColorMap {
        FLAME,
        AQUA,
        ORANGE,
        GREEN,
        RED,
        YELLOW,
        PURPLE,
        BLUE,
        GRAY;

    }
}

