/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.security.auth.x500.X500Principal;
import org.apache.directory.ldap.client.template.LdapConnectionTemplate;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.security.CertificateUtil;
import org.apache.directory.server.ldap.LdapServer;

public abstract class AbstractLdapTestUnit {
    public static DirectoryService classDirectoryService;
    public static DirectoryService methodDirectoryService;
    public static DirectoryService directoryService;
    public static LdapServer classLdapServer;
    public static LdapServer methodLdapServer;
    public static LdapServer ldapServer;
    public static LdapConnectionTemplate ldapConnectionTemplate;
    public static long revision;

    public DirectoryService getService() {
        return directoryService;
    }

    public void setService(DirectoryService directoryService) {
        AbstractLdapTestUnit.directoryService = directoryService;
    }

    public LdapServer getLdapServer() {
        return ldapServer;
    }

    public void setLdapServer(LdapServer ldapServer) {
        AbstractLdapTestUnit.ldapServer = ldapServer;
    }

    public void changeCertificate(String keyStoreFile, String password, String issuerDn, String subjectDn, int days, String algorithm) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] keyStorePassword = password.toCharArray();
        try (FileInputStream keyStoreData = new FileInputStream(keyStoreFile);){
            keyStore.load(null, keyStorePassword);
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X500Principal subject = new X500Principal("CN=" + subjectDn + ",OU=directory,O=apache,C=US");
        X500Principal issuer = new X500Principal("CN=" + issuerDn + ",OU=directory,O=apache,C=US");
        X509Certificate certificate = CertificateUtil.generateCertificate((X500Principal)subject, (X500Principal)issuer, (KeyPair)keyPair, (int)days, (String)algorithm);
        keyStore.setKeyEntry("apachedsKey", keyPair.getPrivate(), keyStorePassword, new X509Certificate[]{certificate});
        try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
            keyStore.store(out, keyStorePassword);
        }
    }

    protected Hashtable<String, Object> setDefaultJNDIEnv() {
        return this.setDefaultJNDIEnv("com.sun.jndi.ldap.LdapCtxFactory");
    }

    protected Hashtable<String, Object> setDefaultJNDIEnv(String factoryName) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(DirectoryService.JNDI_KEY, this.getService());
        env.put("java.naming.provider.url", "");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", factoryName);
        return env;
    }

    static {
        revision = 0L;
    }
}

