/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.memory;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.cache.memory.MemoryCacheLevel;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MemoryCacheController
implements CacheController {
    private MemoryCacheLevel referenceType = MemoryCacheLevel.WEAK;
    private Map cache = Collections.synchronizedMap(new HashMap());

    @Override
    public void setProperties(Properties props) {
        String refType = props.getProperty("reference-type");
        if (refType == null) {
            refType = props.getProperty("referenceType");
        }
        if (refType != null) {
            this.referenceType = MemoryCacheLevel.getByReferenceType(refType);
        }
    }

    public MemoryCacheLevel getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(MemoryCacheLevel referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    public void putObject(CacheModel cacheModel, Object key, Object value) {
        Object reference = null;
        if (this.referenceType.equals(MemoryCacheLevel.WEAK)) {
            reference = new WeakReference<Object>(value);
        } else if (this.referenceType.equals(MemoryCacheLevel.SOFT)) {
            reference = new SoftReference<Object>(value);
        } else if (this.referenceType.equals(MemoryCacheLevel.STRONG)) {
            reference = new StrongReference(value);
        }
        this.cache.put(key, reference);
    }

    @Override
    public Object getObject(CacheModel cacheModel, Object key) {
        Object value = null;
        Object ref = this.cache.get(key);
        if (ref != null) {
            if (ref instanceof StrongReference) {
                value = ((StrongReference)ref).get();
            } else if (ref instanceof SoftReference) {
                value = ((SoftReference)ref).get();
            } else if (ref instanceof WeakReference) {
                value = ((WeakReference)ref).get();
            }
        }
        return value;
    }

    @Override
    public Object removeObject(CacheModel cacheModel, Object key) {
        Object value = null;
        Object ref = this.cache.remove(key);
        if (ref != null) {
            if (ref instanceof StrongReference) {
                value = ((StrongReference)ref).get();
            } else if (ref instanceof SoftReference) {
                value = ((SoftReference)ref).get();
            } else if (ref instanceof WeakReference) {
                value = ((WeakReference)ref).get();
            }
        }
        return value;
    }

    @Override
    public void flush(CacheModel cacheModel) {
        this.cache.clear();
    }

    private static class StrongReference {
        private Object object;

        public StrongReference(Object object) {
            this.object = object;
        }

        public Object get() {
            return this.object;
        }
    }
}

