/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.parameter;

import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterMap {
    private static final Log log = LogFactory.getLog(ParameterMap.class);
    private String id;
    private Class parameterClass;
    private ParameterMapping[] parameterMappings;
    private Boolean useSetObjectForNullValue;
    private int sqlTypeToUseForNullValue;
    private DataExchange dataExchange;
    private String resource;
    private Map parameterMappingIndex = new HashMap();
    private SqlMapExecutorDelegate delegate;

    public ParameterMap(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class getParameterClass() {
        return this.parameterClass;
    }

    public void setParameterClass(Class parameterClass) {
        this.parameterClass = parameterClass;
    }

    public DataExchange getDataExchange() {
        return this.dataExchange;
    }

    public void setDataExchange(DataExchange dataExchange) {
        this.dataExchange = dataExchange;
    }

    public ParameterMapping[] getParameterMappings() {
        return this.parameterMappings;
    }

    public void setParameterMappingList(List parameterMappingList) {
        this.parameterMappings = parameterMappingList.toArray(new ParameterMapping[parameterMappingList.size()]);
        this.parameterMappingIndex.clear();
        for (int i = 0; i < this.parameterMappings.length; ++i) {
            this.parameterMappingIndex.put(this.parameterMappings[i].getPropertyName(), i);
        }
        HashMap<String, ParameterMap> props = new HashMap<String, ParameterMap>();
        props.put("map", this);
        this.dataExchange = this.delegate.getDataExchangeFactory().getDataExchangeForClass(this.parameterClass);
        this.dataExchange.initialize(props);
    }

    public int getParameterIndex(String propertyName) {
        Integer idx = null;
        idx = (Integer)this.parameterMappingIndex.get(propertyName);
        return idx == null ? -1 : idx;
    }

    public int getParameterCount() {
        return this.parameterMappings.length;
    }

    public void setParameters(StatementScope statementScope, PreparedStatement ps, Object[] parameters) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("applying a parameter map");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        errorContext.setMoreInfo("Check the parameter map.");
        if (this.parameterMappings != null) {
            for (int i = 0; i < this.parameterMappings.length; ++i) {
                ParameterMapping mapping = this.parameterMappings[i];
                errorContext.setMoreInfo(mapping.getErrorString());
                if (!mapping.isInputAllowed()) continue;
                this.setParameter(ps, mapping, parameters, i);
            }
        }
    }

    public Object[] getParameterObjectValues(StatementScope statementScope, Object parameterObject) {
        return this.dataExchange.getData(statementScope, this, parameterObject);
    }

    public CacheKey getCacheKey(StatementScope statementScope, Object parameterObject) {
        return this.dataExchange.getCacheKey(statementScope, this, parameterObject);
    }

    public void refreshParameterObjectValues(StatementScope statementScope, Object parameterObject, Object[] values) {
        this.dataExchange.setData(statementScope, this, parameterObject, values);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    protected void setParameter(PreparedStatement ps, ParameterMapping mapping, Object[] parameters, int i) throws SQLException {
        TypeHandler handler;
        Object value = parameters[i];
        String nullValueString = mapping.getNullValue();
        if (nullValueString != null && (handler = mapping.getTypeHandler()).equals(value, nullValueString)) {
            value = null;
        }
        TypeHandler typeHandler = mapping.getTypeHandler();
        if (value != null) {
            typeHandler.setParameter(ps, i + 1, value, mapping.getJdbcTypeName());
        } else if (typeHandler instanceof CustomTypeHandler) {
            typeHandler.setParameter(ps, i + 1, value, mapping.getJdbcTypeName());
        } else {
            int jdbcType = mapping.getJdbcType();
            if (jdbcType != -99999999) {
                ps.setNull(i + 1, jdbcType);
            } else {
                if (this.useSetObjectForNullValue == null) {
                    this.useSetObjectForNullValue = Boolean.FALSE;
                    this.sqlTypeToUseForNullValue = 0;
                    try {
                        DatabaseMetaData dbmd = ps.getConnection().getMetaData();
                        String databaseProductName = dbmd.getDatabaseProductName();
                        String jdbcDriverName = dbmd.getDriverName();
                        if (databaseProductName.startsWith("Informix") || databaseProductName.startsWith("Microsoft SQL Server")) {
                            this.useSetObjectForNullValue = Boolean.TRUE;
                        } else if (databaseProductName.startsWith("DB2") || jdbcDriverName.startsWith("jConnect") || jdbcDriverName.startsWith("SQLServer") || jdbcDriverName.startsWith("Apache Derby Embedded")) {
                            this.sqlTypeToUseForNullValue = 12;
                        }
                    }
                    catch (Throwable ex) {
                        log.debug("Could not check database or driver name: " + ex.getMessage());
                    }
                }
                if (this.useSetObjectForNullValue.booleanValue()) {
                    ps.setObject(i + 1, null);
                } else {
                    ps.setNull(i + 1, this.sqlTypeToUseForNullValue);
                }
            }
        }
    }
}

