/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.impl.ModuleAccess;
import org.graalvm.polyglot.impl.UnnamedAccess;
import org.graalvm.polyglot.impl.UnnamedToModuleAccessGen;
import org.graalvm.polyglot.impl.UnnamedToModuleByteSequenceGen;
import org.graalvm.polyglot.impl.UnnamedToModuleContextDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleEngineDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleExceptionDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleExecutionEventDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleExecutionListenerDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleFileSystemGen;
import org.graalvm.polyglot.impl.UnnamedToModuleInstrumentDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleLanguageDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleMessageEndpointGen;
import org.graalvm.polyglot.impl.UnnamedToModuleOptionDescriptorsGen;
import org.graalvm.polyglot.impl.UnnamedToModulePolyglotImplGen;
import org.graalvm.polyglot.impl.UnnamedToModuleSourceDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleSourceSectionDispatchGen;
import org.graalvm.polyglot.impl.UnnamedToModuleStackFrameImplGen;
import org.graalvm.polyglot.impl.UnnamedToModuleValueDispatchGen;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageEndpoint;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;

public final class UnnamedToModuleBridge {
    private static volatile boolean bridgeInitialized;
    private static volatile UnnamedToModuleBridge instance;
    private final MethodHandles.Lookup moduleLookup;
    private AbstractPolyglotImpl polyglot;
    private ModuleAccess moduleAccess;

    public AbstractPolyglotImpl getPolyglot() {
        return this.polyglot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static UnnamedToModuleBridge create(Class<?> modulePolyglotClass, Object modulePolyglotInstance) {
        MethodHandles.Lookup lookup;
        try {
            Method m = modulePolyglotClass.getDeclaredMethod("getLookup", new Class[0]);
            m.setAccessible(true);
            lookup = (MethodHandles.Lookup)m.invoke(modulePolyglotInstance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
        UnnamedToModuleBridge bridge = instance;
        if (bridge == null) {
            Class<UnnamedToModuleBridge> clazz = UnnamedToModuleBridge.class;
            // MONITORENTER : org.graalvm.polyglot.impl.UnnamedToModuleBridge.class
            bridge = instance;
            if (bridge == null) {
                if (bridgeInitialized) {
                    throw new InternalError("Classes used for the module bridge are already initialized.");
                }
                bridge = instance = new UnnamedToModuleBridge(lookup);
                bridge.polyglot = new UnnamedToModulePolyglotImplGen(modulePolyglotInstance);
            }
            // MONITOREXIT : clazz
        }
        if (!bridge.moduleLookup.equals(lookup)) throw new InternalError("Polyglot bridge was already initialized with a different lookup.");
        return bridge;
    }

    UnnamedToModuleBridge(MethodHandles.Lookup unnamedLookup) {
        this.moduleLookup = unnamedLookup;
    }

    static abstract class UnnamedToModuleExecutionListenerDispatch
    extends AbstractPolyglotImpl.AbstractExecutionListenerDispatch {
        UnnamedToModuleExecutionListenerDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModuleExecutionEventDispatch
    extends AbstractPolyglotImpl.AbstractExecutionEventDispatch {
        UnnamedToModuleExecutionEventDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModuleContextDispatch
    extends AbstractPolyglotImpl.AbstractContextDispatch {
        UnnamedToModuleContextDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModuleEngineDispatch
    extends AbstractPolyglotImpl.AbstractEngineDispatch {
        private static final SandboxPolicy[] SANDBOX_POLICIES = SandboxPolicy.values();

        UnnamedToModuleEngineDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        static OptionDescriptors fromOptionDescriptors(Object value) {
            if (value == null) {
                return null;
            }
            return new UnnamedToModuleOptionDescriptorsGen(value);
        }

        static SandboxPolicy fromSandboxPolicy(Object value) {
            if (value == null) {
                return null;
            }
            return SANDBOX_POLICIES[UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.fromSandboxPolicy(value)];
        }

        static Object toSandboxPolicy(SandboxPolicy value) {
            if (value == null) {
                return null;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toSandboxPolicy(value.ordinal());
        }

        static Object toProcessHandler(ProcessHandler value) {
            if (value == null) {
                return null;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toProcessHandler(value);
        }
    }

    static abstract class UnnamedToModuleByteSequence
    implements ByteSequence {
        UnnamedToModuleByteSequence() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        static ByteSequence fromByteSequence(Object value) {
            return (ByteSequence)UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.fromByteSequence(value);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return super.toString();
        }
    }

    static abstract class UnnamedToModuleFileSystem
    implements FileSystem {
        UnnamedToModuleFileSystem() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return super.toString();
        }
    }

    static abstract class UnnamedToModuleExceptionDispatch
    extends AbstractPolyglotImpl.AbstractExceptionDispatch {
        UnnamedToModuleExceptionDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModuleLanguageDispatch
    extends AbstractPolyglotImpl.AbstractLanguageDispatch {
        UnnamedToModuleLanguageDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        static OptionDescriptors fromOptionDescriptors(Object value) {
            if (value == null) {
                return null;
            }
            return new UnnamedToModuleOptionDescriptorsGen(value);
        }
    }

    static abstract class UnnamedToModuleValueDispatch
    extends AbstractPolyglotImpl.AbstractValueDispatch {
        UnnamedToModuleValueDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModuleInstrumentDispatch
    extends AbstractPolyglotImpl.AbstractInstrumentDispatch {
        UnnamedToModuleInstrumentDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        static OptionDescriptors fromOptionDescriptors(Object value) {
            if (value == null) {
                return null;
            }
            return new UnnamedToModuleOptionDescriptorsGen(value);
        }
    }

    static abstract class UnnamedToModuleOptionDescriptors
    implements OptionDescriptors {
        UnnamedToModuleOptionDescriptors() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        static OptionDescriptor fromOptionDescriptor(Object value) {
            if (value == null) {
                return null;
            }
            Object[] array = UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.fromOptionDescriptor(value);
            OptionType type = new OptionType((String)array[7], (Function)array[8], (Consumer)array[9]);
            OptionKey<Object> key = new OptionKey<Object>(array[6], type);
            OptionDescriptor.Builder b = OptionDescriptor.newBuilder(key, (String)array[0]);
            b.help((String)array[1]);
            b.category(OptionCategory.values()[(Integer)array[2]]);
            b.stability(OptionStability.values()[(Integer)array[3]]);
            b.deprecated((Boolean)array[4]);
            b.usageSyntax((String)array[5]);
            return b.build();
        }
    }

    static abstract class UnnamedToModuleStackFrameImpl
    extends AbstractPolyglotImpl.AbstractStackFrameImpl {
        UnnamedToModuleStackFrameImpl() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModuleSourceSectionDispatch
    extends AbstractPolyglotImpl.AbstractSourceSectionDispatch {
        UnnamedToModuleSourceSectionDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModuleSourceDispatch
    extends AbstractPolyglotImpl.AbstractSourceDispatch {
        UnnamedToModuleSourceDispatch() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        public static ByteSequence fromByteSequence(Object value) {
            return (ByteSequence)UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.fromByteSequence(value);
        }
    }

    static abstract class UnnamedToModuleMessageEndpoint
    implements MessageEndpoint {
        UnnamedToModuleMessageEndpoint() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    static abstract class UnnamedToModulePolyglotImpl
    extends AbstractPolyglotImpl {
        static final UnnamedToModuleBridge BRIDGE = instance;

        UnnamedToModulePolyglotImpl() {
        }

        static MethodHandles.Lookup moduleLookup() {
            if (BRIDGE == null) {
                return null;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleLookup;
        }

        @Override
        public final void initialize() {
            super.initialize();
            Object m = this.initializeModuleToUnnamedAccess(MethodHandles.lookup(), new UnnamedAccessImpl(), this.getAPIAccess(), this.getIO(), this.getManagement());
            UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess = new UnnamedToModuleAccessGen(m);
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }

        static ProcessHandler fromProcessHandler(Object value) {
            if (value == null) {
                return null;
            }
            return (ProcessHandler)UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.fromProcessHandler(value);
        }

        static OptionDescriptors fromOptionDescriptors(Object value) {
            throw new AssertionError((Object)"Method is not expected to be called from polyglot.");
        }

        static FileSystem fromFileSystem(Object value) {
            if (value == null) {
                return null;
            }
            return new UnnamedToModuleFileSystemGen(value);
        }

        static AbstractPolyglotImpl.ThreadScope fromThreadScope(Object value) {
            if (value == null) {
                return null;
            }
            return (AbstractPolyglotImpl.ThreadScope)UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.fromThreadScope(value);
        }

        static Object toFileSystem(FileSystem value) {
            if (value == null) {
                return null;
            }
            Object fs = value;
            if (fs instanceof UnnamedToModuleFileSystemGen) {
                fs = ((UnnamedToModuleFileSystemGen)fs).receiver;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toFileSystem(fs);
        }

        static Object toProcessHandler(ProcessHandler value) {
            if (value == null) {
                return null;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toProcessHandler(value);
        }

        static Object toMessageTransport(MessageTransport value) {
            if (value == null) {
                return null;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toMessageTransport(value);
        }

        static Object toSandboxPolicy(SandboxPolicy value) {
            if (value == null) {
                return null;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toSandboxPolicy(value.ordinal());
        }

        static Object toTargetMappingPrecedence(HostAccess.TargetMappingPrecedence value) {
            if (value == null) {
                return null;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toTargetMappingPrecedence(value.ordinal());
        }

        static Object toOptionDescriptorsArray(OptionDescriptors[] optionDescriptors) {
            throw new UnsupportedOperationException("Cannot be called from the unnamed module.");
        }

        static {
            bridgeInitialized = true;
        }
    }

    static abstract class UnnamedToModuleAccess
    extends ModuleAccess {
        UnnamedToModuleAccess() {
        }

        static MethodHandles.Lookup methodHandleLookup() {
            return UnnamedToModulePolyglotImpl.moduleLookup();
        }
    }

    private static final class UnnamedAccessImpl
    extends UnnamedAccess {
        private UnnamedAccessImpl() {
        }

        @Override
        public Object toSourceDispatch(Object receiver) {
            return new UnnamedToModuleSourceDispatchGen(receiver);
        }

        @Override
        public Object toSourceSectionDispatch(Object dispatch) {
            return new UnnamedToModuleSourceSectionDispatchGen(dispatch);
        }

        @Override
        public Object toStackFrameImpl(Object dispatch) {
            return new UnnamedToModuleStackFrameImplGen(dispatch);
        }

        @Override
        public Object toInstrumentDispatch(Object dispatch) {
            return new UnnamedToModuleInstrumentDispatchGen(dispatch);
        }

        @Override
        public Object toValueDispatch(Object dispatch) {
            return new UnnamedToModuleValueDispatchGen(dispatch);
        }

        @Override
        public Object toLanguageDispatch(Object dispatch) {
            return new UnnamedToModuleLanguageDispatchGen(dispatch);
        }

        @Override
        public Object toExceptionDispatch(Object dispatch) {
            return new UnnamedToModuleExceptionDispatchGen(dispatch);
        }

        @Override
        public Object toEngineDispatch(Object dispatch) {
            return new UnnamedToModuleEngineDispatchGen(dispatch);
        }

        @Override
        public Object toContextDispatch(Object dispatch) {
            return new UnnamedToModuleContextDispatchGen(dispatch);
        }

        @Override
        public Object fromSourceDispatch(Object dispatch) {
            return ((UnnamedToModuleSourceDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromSourceSectionDispatch(Object dispatch) {
            return ((UnnamedToModuleSourceSectionDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromStackFrameImpl(Object dispatch) {
            return ((UnnamedToModuleStackFrameImplGen)dispatch).receiver;
        }

        @Override
        public Object fromInstrumentDispatch(Object dispatch) {
            return ((UnnamedToModuleInstrumentDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromValueDispatch(Object dispatch) {
            return ((UnnamedToModuleValueDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromLanguageDispatch(Object dispatch) {
            return ((UnnamedToModuleLanguageDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromExceptionDispatch(Object dispatch) {
            return ((UnnamedToModuleExceptionDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromEngineDispatch(Object dispatch) {
            return ((UnnamedToModuleEngineDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromContextDispatch(Object dispatch) {
            return ((UnnamedToModuleContextDispatchGen)dispatch).receiver;
        }

        @Override
        public Object fromMessageEndpoint(Object dispatch) {
            return ((UnnamedToModuleMessageEndpointGen)dispatch).receiver;
        }

        @Override
        public Object toMessageEndpoint(Object dispatch) {
            return new UnnamedToModuleMessageEndpointGen(dispatch);
        }

        @Override
        public Object fromByteSequence(Object value) {
            return ((UnnamedToModuleByteSequenceGen)value).receiver;
        }

        @Override
        public Object fromFileSystem(Object value) {
            if (value instanceof UnnamedToModuleFileSystemGen) {
                return ((UnnamedToModuleFileSystemGen)value).receiver;
            }
            return UnnamedToModulePolyglotImpl.BRIDGE.moduleAccess.toFileSystem(value);
        }

        @Override
        public Object toFileSystem(Object value) {
            return new UnnamedToModuleFileSystemGen(value);
        }

        @Override
        public Object toExecutionListenerDispatch(Object value) {
            return new UnnamedToModuleExecutionListenerDispatchGen(value);
        }

        @Override
        public Object fromExecutionListenerDispatch(Object value) {
            return ((UnnamedToModuleExecutionListenerDispatchGen)value).receiver;
        }

        @Override
        public Object toExecutionEventDispatch(Object value) {
            return new UnnamedToModuleExecutionEventDispatchGen(value);
        }

        @Override
        public Object fromExecutionEventDispatch(Object value) {
            return ((UnnamedToModuleExecutionEventDispatchGen)value).receiver;
        }

        @Override
        public Object[] fromOptionDescriptor(Object value) {
            OptionDescriptor d = (OptionDescriptor)value;
            OptionKey<?> key = d.getKey();
            OptionType<?> type = key.getType();
            return new Object[]{d.getName(), d.getHelp(), d.getCategory().ordinal(), d.getStability().ordinal(), d.isDeprecated(), d.getUsageSyntax(), key.getDefaultValue(), type.getName(), o -> type.convert((String)o), o -> type.validate(o)};
        }

        @Override
        public Object toProcessCommand(Object[] value) {
            return ProcessHandler.ProcessCommand.create((List)value[0], (String)value[1], (Map)value[2], (Boolean)value[3], UnnamedAccessImpl.deserializeRedirect(value[4]), UnnamedAccessImpl.deserializeRedirect(value[5]), UnnamedAccessImpl.deserializeRedirect(value[6]));
        }

        private static ProcessHandler.Redirect deserializeRedirect(Object r) {
            if (r instanceof Integer) {
                switch ((Integer)r) {
                    case 0: {
                        return ProcessHandler.Redirect.INHERIT;
                    }
                    case 1: {
                        return ProcessHandler.Redirect.PIPE;
                    }
                }
                return null;
            }
            return ProcessHandler.Redirect.createRedirectToStream((OutputStream)r);
        }

        @Override
        public int[] fromMutableTargetMappingArray(Object value) {
            HostAccess.MutableTargetMapping[] array = (HostAccess.MutableTargetMapping[])value;
            int[] ordinals = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                ordinals[i] = array[i].ordinal();
            }
            return ordinals;
        }

        public Object[] fromProcessCommand(Object value) {
            return UnnamedAccessImpl.serializeProcessCommand(value);
        }

        private static Object[] serializeProcessCommand(Object value) {
            ProcessHandler.ProcessCommand c = (ProcessHandler.ProcessCommand)value;
            return new Object[]{c.getCommand(), c.getDirectory(), c.getEnvironment(), c.isRedirectErrorStream(), UnnamedAccessImpl.serializeRedirect(c.getInputRedirect()), UnnamedAccessImpl.serializeRedirect(c.getOutputRedirect()), UnnamedAccessImpl.serializeRedirect(c.getErrorRedirect())};
        }

        private static Object serializeRedirect(ProcessHandler.Redirect r) {
            if (r.equals(ProcessHandler.Redirect.INHERIT)) {
                return 0;
            }
            if (r.equals(ProcessHandler.Redirect.PIPE)) {
                return 1;
            }
            return r.getOutputStream();
        }

        @Override
        public Object toByteSequence(Object value) {
            return new UnnamedToModuleByteSequenceGen(value);
        }
    }
}

