/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.graalvm.polyglot.impl.UnnamedToModuleBridge;
import org.graalvm.polyglot.io.ByteSequence;

final class UnnamedToModuleByteSequenceGen
extends UnnamedToModuleBridge.UnnamedToModuleByteSequence {
    private static final Handles HANDLES;
    final Object receiver;

    public UnnamedToModuleByteSequenceGen(Object receiver) {
        this.receiver = Objects.requireNonNull(receiver);
    }

    @Override
    public byte byteAt(int index_) {
        try {
            byte result = UnnamedToModuleByteSequenceGen.HANDLES.byteAt_.invoke(this.receiver, index_);
            return result;
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    @Override
    public IntStream bytes() {
        try {
            IntStream result = UnnamedToModuleByteSequenceGen.HANDLES.bytes_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    @Override
    public boolean equals(Object obj_) {
        try {
            boolean result = UnnamedToModuleByteSequenceGen.HANDLES.equals_.invoke(this.receiver, obj_);
            return result;
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    @Override
    public int hashCode() {
        try {
            int result = UnnamedToModuleByteSequenceGen.HANDLES.hashCode_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    @Override
    public int length() {
        try {
            int result = UnnamedToModuleByteSequenceGen.HANDLES.length_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    @Override
    public ByteSequence subSequence(int startIndex_, int endIndex_) {
        try {
            Object result = UnnamedToModuleByteSequenceGen.HANDLES.subSequence_.invoke(this.receiver, startIndex_, endIndex_);
            return UnnamedToModuleBridge.UnnamedToModuleByteSequence.fromByteSequence(result);
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] result = UnnamedToModuleByteSequenceGen.HANDLES.toByteArray_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    @Override
    public String toString() {
        try {
            String result = UnnamedToModuleByteSequenceGen.HANDLES.toString_.invoke(this.receiver);
            return result;
        }
        catch (Throwable t) {
            throw UnnamedToModuleByteSequenceGen.handleException_(t);
        }
    }

    private static <T extends Throwable> RuntimeException handleException_(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandles.Lookup lookup = UnnamedToModuleByteSequenceGen.methodHandleLookup();
        if (lookup != null) {
            try {
                HANDLES = new Handles(lookup);
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError("Failed to initialize method handles for module bridge.", e);
            }
        } else {
            HANDLES = null;
        }
    }

    static final class Handles {
        private final MethodHandle byteAt_;
        private final MethodHandle bytes_;
        private final MethodHandle equals_;
        private final MethodHandle hashCode_;
        private final MethodHandle length_;
        private final MethodHandle subSequence_;
        private final MethodHandle toByteArray_;
        private final MethodHandle toString_;

        Handles(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            Class<?> typeByteSequence_ = lookup.findClass(ByteSequence.class.getName());
            Class<?> typeByteSequence = lookup.findClass(ByteSequence.class.getName());
            Class<?> typeObject = lookup.findClass(Object.class.getName());
            this.byteAt_ = lookup.findVirtual(typeByteSequence, "byteAt", MethodType.methodType(Byte.TYPE, List.of(Integer.TYPE)));
            this.bytes_ = lookup.findVirtual(typeByteSequence, "bytes", MethodType.methodType(IntStream.class, List.of()));
            this.equals_ = lookup.findVirtual(typeObject, "equals", MethodType.methodType(Boolean.TYPE, List.of(Object.class)));
            this.hashCode_ = lookup.findVirtual(typeObject, "hashCode", MethodType.methodType(Integer.TYPE, List.of()));
            this.length_ = lookup.findVirtual(typeByteSequence, "length", MethodType.methodType(Integer.TYPE, List.of()));
            this.subSequence_ = lookup.findVirtual(typeByteSequence, "subSequence", MethodType.methodType(typeByteSequence_, List.of(Integer.TYPE, Integer.TYPE)));
            this.toByteArray_ = lookup.findVirtual(typeByteSequence, "toByteArray", MethodType.methodType(byte[].class, List.of()));
            this.toString_ = lookup.findVirtual(typeObject, "toString", MethodType.methodType(String.class, List.of()));
        }
    }
}

