/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.util.Properties;
import org.lsc.configuration.JaxbXmlConfigurationHelper;
import org.lsc.configuration.LscConfiguration;
import org.lsc.exception.LscConfigurationException;
import org.lsc.exception.LscException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    public static String location;
    private static boolean loggingSetup;
    public static String DN_PEOPLE;
    public static String DN_LDAP_SCHEMA;
    public static String DN_ENHANCED_SCHEMA;
    public static String DN_STRUCTURES;
    public static String DN_ACCOUNTS;
    public static String OBJECTCLASS_PERSON;
    public static String OBJECTCLASS_EMPLOYEE;
    public static int DAYS_BEFORE_SUPPRESSION;
    public static String DN_REAL_ROOT;
    public static int UID_MAX_LENGTH;
    public static final String LSC_TASKS_PREFIX = "lsc.tasks";
    public static final String LSC_SYNCOPTIONS_PREFIX = "lsc.syncoptions";
    public static final int MAX_CONCURRENT_SYNCHRONIZED = 100000;

    protected Configuration() {
    }

    public static Properties getPropertiesSubset(Properties originalProperties, String prefix) {
        if (originalProperties == null) {
            return null;
        }
        Properties result = new Properties();
        for (Object propertyName : originalProperties.keySet()) {
            String propertyNameStr = (String)propertyName;
            if (!propertyNameStr.startsWith(prefix + ".")) continue;
            String newPropertyName = propertyNameStr.substring(prefix.length() + 1);
            result.put(newPropertyName, originalProperties.getProperty(propertyNameStr));
        }
        return result;
    }

    private static String cleanup(String path) {
        String ret = path.trim();
        if (ret.charAt(0) == '\'' && ret.charAt(ret.length() - 1) == '\'') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    public static String getConfigurationDirectory() {
        if (location == null) {
            Configuration.setUp();
        }
        return location != null ? new File(location).getAbsolutePath() + File.separator : "";
    }

    public static void setUp() {
        if (LscConfiguration.isInitialized()) {
            return;
        }
        try {
            if (new File(System.getProperty("LSC_HOME"), "etc").isDirectory() && new File(System.getProperty("LSC_HOME"), "etc/lsc.xml").exists()) {
                Configuration.setUp(new File(System.getProperty("LSC_HOME"), "etc").getAbsolutePath(), false);
            } else if (Configuration.class.getClassLoader().getResource("etc") != null) {
                Configuration.setUp(Configuration.class.getClassLoader().getResource("etc").getPath(), false);
            }
        }
        catch (LscException le) {
            System.err.println("Something strange appened: " + le.getMessage());
        }
    }

    public static void setUp(String lscConfigurationPath) throws LscException {
        Configuration.setUp(lscConfigurationPath, true);
    }

    public static void setUp(String lscConfigurationPath, boolean validate) throws LscException {
        Object message = null;
        ConfigType configType = ConfigType.FILE;
        if (lscConfigurationPath == null) {
            message = "No configuration provided. LSC configuration loading will fail !";
            LOGGER.error((String)message);
            throw new RuntimeException((String)message);
        }
        if (new File(lscConfigurationPath).isDirectory()) {
            if (!new File(lscConfigurationPath, "lsc.xml").isFile()) {
                message = "The location (" + lscConfigurationPath + ") does not contain a lsc.xml configuration file. LSC configuration loading will fail !";
                LOGGER.error((String)message);
                throw new RuntimeException((String)message);
            }
            configType = ConfigType.DIRECTORY;
        } else if (!new File(lscConfigurationPath).isFile()) {
            message = "Defined configuration file (" + lscConfigurationPath + ") does not exist. LSC configuration loading will fail !";
            LOGGER.error((String)message);
            throw new RuntimeException((String)message);
        }
        try {
            location = Configuration.cleanup(lscConfigurationPath);
            if (!LscConfiguration.isInitialized()) {
                File xml;
                if (configType == ConfigType.DIRECTORY) {
                    xml = new File(location, "lsc.xml");
                    if (!xml.exists() && !xml.isFile()) {
                        message = "Unable to load configuration inside the directory: " + location;
                        LOGGER.error((String)message);
                        return;
                    }
                } else {
                    xml = new File(location);
                }
                LscConfiguration.loadFromInstance(new JaxbXmlConfigurationHelper().getConfiguration(xml.toString(), System.getenv()));
            } else {
                LOGGER.error("LSC already configured. Unable to load new parameters ...");
            }
        }
        catch (LscConfigurationException e) {
            message = "Unable to load configuration (" + String.valueOf(e.getCause()) + ")";
            LOGGER.error((String)message, (Throwable)e);
            return;
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        context.reset();
        String logBackXMLPropertiesFile = new File(Configuration.getConfigurationDirectory(), "logback.xml").getAbsolutePath();
        try {
            configurator.doConfigure(logBackXMLPropertiesFile);
            LOGGER.info("Logging configuration successfully loaded from " + logBackXMLPropertiesFile + " ");
        }
        catch (JoranException je) {
            System.err.println("Cannot find logging configuration file (" + logBackXMLPropertiesFile + ") !");
        }
        Configuration.setLoggingSetup(true);
        if (validate) {
            LscConfiguration.getInstance().validate();
        }
        LOGGER.info("LSC configuration successfully loaded from {}", (Object)Configuration.getConfigurationDirectory());
    }

    public static void assertPropertyNotEmpty(String propertyName, String propertyValue, String location) throws LscConfigurationException {
        if (propertyValue == null || propertyValue.length() == 0) {
            throw new RuntimeException("No " + propertyName + " property specified in " + location + ". Aborting.");
        }
    }

    public static void setLoggingSetup(boolean loggingSetup) {
        Configuration.loggingSetup = loggingSetup;
    }

    public static boolean isLoggingSetup() {
        return loggingSetup;
    }

    static {
        loggingSetup = false;
        DN_PEOPLE = "ou=People";
        DN_LDAP_SCHEMA = "cn=Subschema";
        DN_ENHANCED_SCHEMA = "ou=Schema,ou=System";
        DN_STRUCTURES = "ou=Structures";
        DN_ACCOUNTS = "ou=Accounts";
        OBJECTCLASS_PERSON = "inetOrgPerson";
        OBJECTCLASS_EMPLOYEE = "inetOrgPerson";
        DAYS_BEFORE_SUPPRESSION = 90;
        DN_REAL_ROOT = "dc=lsc-project,dc=org";
        UID_MAX_LENGTH = 8;
    }

    private static enum ConfigType {
        DIRECTORY,
        FILE;

    }
}

