/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsc.Configuration;
import org.lsc.beans.syncoptions.ForceSyncOptions;
import org.lsc.beans.syncoptions.ISyncOptions;
import org.lsc.beans.syncoptions.SyncOptionsFactory;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscConfigurationException;
import org.lsc.service.IService;
import org.lsc.service.IWritableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    private String name;
    private IWritableService destinationService;
    private IService sourceService;
    private ISyncOptions syncOptions;
    private Object[] customLibraries;
    private List<File> scriptIncludes;
    private Map<String, Object> scriptingVars = new HashMap<String, Object>();
    private String cleanHook;
    private String syncHook;
    private TaskType taskType;
    private Boolean errorIfEmptySource;
    private Boolean errorIfEmptyDestination;

    public Task(TaskType t) throws LscConfigurationException {
        this.name = t.getName();
        this.taskType = t;
        try {
            this.cleanHook = t.getCleanHook();
            this.syncHook = t.getSyncHook();
            this.errorIfEmptySource = t.isErrorIfEmptySource();
            this.errorIfEmptyDestination = t.isErrorIfEmptyDestination();
            if (LscConfiguration.getSourceService(t) == null) {
                throw new LscConfigurationException("Missing source service for task=" + t.getName());
            }
            if (LscConfiguration.getDestinationService(t) == null) {
                throw new LscConfigurationException("Missing destination service for task=" + t.getName());
            }
            Constructor<?> constr = LscConfiguration.getServiceImplementation(LscConfiguration.getDestinationService(t)).getConstructor(TaskType.class);
            this.destinationService = (IWritableService)constr.newInstance(t);
            if (t.getCustomLibrary() != null && t.getCustomLibrary().getString() != null) {
                this.customLibraries = new Object[t.getCustomLibrary().getString().size()];
                int customLibrariesIndex = 0;
                for (String custumLibraryClassName : t.getCustomLibrary().getString()) {
                    this.customLibraries[customLibrariesIndex++] = Class.forName(custumLibraryClassName).newInstance();
                }
            }
            if (t.getScriptInclude() != null && t.getScriptInclude().getString() != null) {
                this.scriptIncludes = new ArrayList<File>();
                for (String script : t.getScriptInclude().getString()) {
                    File scriptFile = new File(Configuration.getConfigurationDirectory() + "/" + script);
                    if (scriptFile.exists()) {
                        this.scriptIncludes.add(scriptFile);
                        continue;
                    }
                    LOGGER.warn("File " + scriptFile.getAbsolutePath() + "doesn't exist.");
                }
            }
            Constructor<?> constrSrcService = LscConfiguration.getServiceImplementation(LscConfiguration.getSourceService(t)).getConstructor(TaskType.class);
            this.sourceService = (IService)constrSrcService.newInstance(t);
            this.initializeSyncOptions(t);
        }
        catch (InvocationTargetException e) {
            throw new LscConfigurationException(e.getCause());
        }
        catch (LscConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LscConfigurationException((Throwable)e);
        }
    }

    protected void initializeSyncOptions(TaskType t) throws LscConfigurationException {
        this.syncOptions = SyncOptionsFactory.convert(t);
        if (this.syncOptions == null) {
            if (this.name == null || this.name.length() == 0) {
                LOGGER.info("No SyncOptions configuration. Defaulting to Force policy ...");
            } else {
                LOGGER.warn("Unknown '{}' synchronization task name. Defaulting to Force policy ...", (Object)this.name);
            }
            this.syncOptions = new ForceSyncOptions();
        }
    }

    public String getCleanHook() {
        return this.cleanHook;
    }

    public String getSyncHook() {
        return this.syncHook;
    }

    public Boolean getErrorIfEmptySource() {
        return this.errorIfEmptySource;
    }

    public Boolean getErrorIfEmptyDestination() {
        return this.errorIfEmptyDestination;
    }

    public String getName() {
        return this.name;
    }

    public IService getSourceService() {
        return this.sourceService;
    }

    public IWritableService getDestinationService() {
        return this.destinationService;
    }

    public ISyncOptions getSyncOptions() {
        return this.syncOptions;
    }

    public Object[] getCustomLibraries() {
        return this.customLibraries;
    }

    public List<File> getScriptIncludes() {
        return this.scriptIncludes;
    }

    public Map<String, Object> getScriptingVars() {
        return this.scriptingVars;
    }

    public void addScriptingVar(String identifier, Object value) {
        this.scriptingVars.put(identifier, value);
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public static enum Mode {
        clean,
        sync,
        async;

    }
}

