/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.beans.syncoptions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.lsc.LscModificationType;
import org.lsc.beans.syncoptions.ISyncOptions;
import org.lsc.configuration.DatasetType;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.PolicyType;
import org.lsc.configuration.PropertiesBasedSyncOptionsType;
import org.lsc.configuration.TaskType;
import org.lsc.configuration.ValuesType;

public class PropertiesBasedSyncOptions
implements ISyncOptions {
    private PropertiesBasedSyncOptionsType conf;

    @Override
    public void initialize(TaskType task) {
        this.conf = task.getPropertiesBasedSyncOptions();
    }

    @Override
    public final PolicyType getStatus(String id, String attributeName) {
        PolicyType statusType = LscConfiguration.getDataset(this.conf, attributeName).getPolicy();
        return statusType != null ? statusType : this.conf.getDefaultPolicy();
    }

    @Override
    public final List<String> getDefaultValues(String id, String attributeName) {
        ValuesType datasetValues = LscConfiguration.getDataset(this.conf, attributeName).getDefaultValues();
        ArrayList<String> copy = null;
        if (datasetValues != null && datasetValues.getString().size() > 0) {
            copy = new ArrayList<String>(datasetValues.getString());
        }
        return copy;
    }

    @Override
    public final List<String> getCreateValues(String id, String attributeName) {
        ValuesType datasetValues = LscConfiguration.getDataset(this.conf, attributeName).getCreateValues();
        ArrayList<String> copy = null;
        if (datasetValues != null && datasetValues.getString().size() > 0) {
            copy = new ArrayList<String>(datasetValues.getString());
        }
        return copy;
    }

    @Override
    public final List<String> getForceValues(String id, String attributeName) {
        ValuesType datasetValues = LscConfiguration.getDataset(this.conf, attributeName).getForceValues();
        ArrayList<String> copy = null;
        if (datasetValues != null && datasetValues.getString().size() > 0) {
            copy = new ArrayList<String>(datasetValues.getString());
        }
        return copy;
    }

    @Override
    public Set<String> getCreateAttributeNames() {
        HashSet<String> createAttrs = new HashSet<String>();
        for (DatasetType attr : this.conf.getDataset()) {
            if (attr.getCreateValues().getString().isEmpty()) continue;
            createAttrs.add(attr.getName());
        }
        return createAttrs;
    }

    @Override
    public Set<String> getDefaultValuedAttributeNames() {
        HashSet<String> createAttrs = new HashSet<String>();
        for (DatasetType attr : this.conf.getDataset()) {
            if (attr.getDefaultValues().getString().isEmpty()) continue;
            createAttrs.add(attr.getName());
        }
        return createAttrs;
    }

    @Override
    public Set<String> getForceValuedAttributeNames() {
        HashSet<String> createAttrs = new HashSet<String>();
        for (DatasetType attr : this.conf.getDataset()) {
            if (attr.getForceValues().getString().isEmpty()) continue;
            createAttrs.add(attr.getName());
        }
        return createAttrs;
    }

    @Override
    public String getDn() {
        return this.conf.getMainIdentifier();
    }

    @Override
    public String getCreateCondition() {
        if (this.conf.getConditions() == null || this.conf.getConditions().getCreate() == null) {
            return "true";
        }
        return this.conf.getConditions().getCreate();
    }

    @Override
    public String getDeleteCondition() {
        if (this.conf.getConditions() == null || this.conf.getConditions().getDelete() == null) {
            return "true";
        }
        return this.conf.getConditions().getDelete();
    }

    @Override
    public String getUpdateCondition() {
        if (this.conf.getConditions() == null || this.conf.getConditions().getUpdate() == null) {
            return "true";
        }
        return this.conf.getConditions().getUpdate();
    }

    @Override
    public String getChangeIdCondition() {
        if (this.conf.getConditions() == null || this.conf.getConditions().getChangeId() == null) {
            return "true";
        }
        return this.conf.getConditions().getChangeId();
    }

    @Override
    public String getCondition(LscModificationType operation) {
        String result = "true";
        switch (operation) {
            case CREATE_OBJECT: {
                result = this.getCreateCondition();
                break;
            }
            case UPDATE_OBJECT: {
                result = this.getUpdateCondition();
                break;
            }
            case DELETE_OBJECT: {
                result = this.getDeleteCondition();
                break;
            }
            case CHANGE_ID: {
                result = this.getChangeIdCondition();
            }
        }
        return result;
    }

    @Override
    public ISyncOptions.OutputFormat getPostHookOutputFormat() {
        if (this.conf.getHooks() == null || this.conf.getHooks().getOutputFormat() == null) {
            return ISyncOptions.OutputFormat.LDIF;
        }
        switch (this.conf.getHooks().getOutputFormat()) {
            case "json": {
                return ISyncOptions.OutputFormat.JSON;
            }
        }
        return ISyncOptions.OutputFormat.LDIF;
    }

    @Override
    public Optional<String> getCreatePostHook() {
        Optional<String> hook = Optional.ofNullable(this.conf.getHooks()).map(o -> o.getCreatePostHook()).filter(s -> !s.isEmpty());
        return hook;
    }

    @Override
    public Optional<String> getDeletePostHook() {
        Optional<String> hook = Optional.ofNullable(this.conf.getHooks()).map(o -> o.getDeletePostHook()).filter(s -> !s.isEmpty());
        return hook;
    }

    @Override
    public Optional<String> getUpdatePostHook() {
        Optional<String> hook = Optional.ofNullable(this.conf.getHooks()).map(o -> o.getUpdatePostHook()).filter(s -> !s.isEmpty());
        return hook;
    }

    @Override
    public Optional<String> getChangeIdPostHook() {
        Optional<String> hook = Optional.ofNullable(this.conf.getHooks()).map(o -> o.getChangeIdPostHook()).filter(s -> !s.isEmpty());
        return hook;
    }

    @Override
    public Optional<String> getPostHook(LscModificationType operation) {
        switch (operation) {
            case CREATE_OBJECT: {
                return this.getCreatePostHook();
            }
            case UPDATE_OBJECT: {
                return this.getUpdatePostHook();
            }
            case DELETE_OBJECT: {
                return this.getDeletePostHook();
            }
            case CHANGE_ID: {
                return this.getChangeIdPostHook();
            }
        }
        return Optional.empty();
    }

    @Override
    public String getDelimiter(String name) {
        DatasetType dataset = LscConfiguration.getDataset(this.conf, name);
        if (dataset != null && dataset.getDelimiter() != null) {
            return dataset.getDelimiter();
        }
        return this.conf.getDefaultDelimiter();
    }
}

