/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.NamingException;
import org.lsc.LscDatasets;
import org.lsc.configuration.LdapSourceServiceType;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.SimpleJndiSrcService;
import org.lsc.service.IAsynchronousService;

public class PullableJndiSrcService
extends SimpleJndiSrcService
implements IAsynchronousService {
    private Date lastSuccessfulSync;
    private Set<Map.Entry<String, LscDatasets>> listPivots;
    private String filterTimestamp;
    private String dateFormat;
    private SimpleDateFormat dateFormater;
    private int interval;

    @Deprecated
    public PullableJndiSrcService(Properties props, String beanClassName) throws LscServiceConfigurationException {
        super(props, beanClassName);
        this.filterTimestamp = props.getProperty("filterAsync", "modifytimestamp>={0}");
        this.dateFormat = props.getProperty("dateFormat", "yyyyMMddHHmmss'Z'");
        this.interval = Integer.parseInt(props.getProperty("interval", "5"));
        try {
            this.dateFormater = new SimpleDateFormat(this.dateFormat);
            this.dateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        catch (IllegalArgumentException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    public PullableJndiSrcService(TaskType task) throws LscServiceConfigurationException {
        super(task);
        LdapSourceServiceType asyncService = (LdapSourceServiceType)LscConfiguration.getSourceService(task);
        this.filterTimestamp = asyncService.getFilterAsync() != null ? asyncService.getFilterAsync() : "modifytimestamp>={0}";
        this.dateFormat = asyncService.getDateFormat() != null ? asyncService.getDateFormat() : "yyyyMMddHHmmss'Z'";
        this.interval = asyncService.getInterval() != null ? asyncService.getInterval() : 5;
        try {
            this.dateFormater = new SimpleDateFormat(this.dateFormat);
            this.dateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        catch (IllegalArgumentException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    @Override
    public Map.Entry<String, LscDatasets> getNextId() throws LscServiceException {
        if (this.listPivots != null && !this.listPivots.isEmpty()) {
            Map.Entry<String, LscDatasets> entry = this.listPivots.iterator().next();
            this.listPivots.remove(entry);
            if (this.listPivots.isEmpty()) {
                this.listPivots = null;
            }
            return entry;
        }
        if (this.lastSuccessfulSync == null) {
            this.lastSuccessfulSync = new Date();
            this.listPivots = this.getListPivots().entrySet();
        } else {
            String date = this.dateFormater.format(this.lastSuccessfulSync);
            this.lastSuccessfulSync = new Date();
            try {
                this.listPivots = this.jndiServices.getAttrsList(this.getBaseDn(), this.filterTimestamp.replaceAll("\\{0\\}", date), 2, this.getAttrsId()).entrySet();
            }
            catch (NamingException e) {
                throw new LscServiceException(e);
            }
            if (this.listPivots.isEmpty()) {
                return null;
            }
        }
        return this.getNextId();
    }

    @Override
    public long getInterval() {
        return this.interval * 1000;
    }

    public Date getLastSuccessfulSync() {
        return this.lastSuccessfulSync;
    }

    public void setLastSuccessfulSync(Date lastSuccessfulSync) {
        this.lastSuccessfulSync = lastSuccessfulSync;
    }
}

